/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import jakarta.persistence.PersistenceException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.PlatformEmailSendException;
import org.apache.fineract.infrastructure.security.service.PlatformPasswordEncoder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserPreviousPassword;
import org.apache.fineract.useradministration.domain.AppUserPreviousPasswordRepository;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.apache.fineract.useradministration.domain.Role;
import org.apache.fineract.useradministration.domain.RoleRepository;
import org.apache.fineract.useradministration.domain.UserDomainService;
import org.apache.fineract.useradministration.exception.PasswordPreviouslyUsedException;
import org.apache.fineract.useradministration.exception.RoleNotFoundException;
import org.apache.fineract.useradministration.exception.UserNotFoundException;
import org.apache.fineract.useradministration.service.AppUserWritePlatformService;
import org.apache.fineract.useradministration.service.UserDataValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

public class AppUserWritePlatformServiceJpaRepositoryImpl
implements AppUserWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppUserWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final UserDomainService userDomainService;
    private final PlatformPasswordEncoder platformPasswordEncoder;
    private final AppUserRepository appUserRepository;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final RoleRepository roleRepository;
    private final UserDataValidator fromApiJsonDeserializer;
    private final AppUserPreviousPasswordRepository appUserPreviewPasswordRepository;
    private final StaffRepositoryWrapper staffRepositoryWrapper;
    private final ClientRepositoryWrapper clientRepositoryWrapper;

    @Transactional
    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    public CommandProcessingResult createUser(JsonCommand command) {
        try {
            List clients;
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            String officeIdParamName = "officeId";
            Long officeId = command.longValueOfParameterNamed("officeId");
            Office userOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            String[] roles = command.arrayValueOfParameterNamed("roles");
            Set allRoles = this.assembleSetOfRoles(roles);
            String staffIdParamName = "staffId";
            Long staffId = command.longValueOfParameterNamed("staffId");
            Staff linkedStaff = staffId != null ? this.staffRepositoryWrapper.findByOfficeWithNotFoundDetection(staffId, (Long)userOffice.getId()) : null;
            if (command.hasParameter("isSelfServiceUser") && command.booleanPrimitiveValueOfParameterNamed("isSelfServiceUser") && command.hasParameter("clients")) {
                JsonArray clientsArray = command.arrayOfParameterNamed("clients");
                HashSet<Long> clientIds = new HashSet<Long>();
                for (JsonElement clientElement : clientsArray) {
                    clientIds.add(clientElement.getAsLong());
                }
                clients = this.clientRepositoryWrapper.findAll(clientIds);
            } else {
                clients = null;
            }
            AppUser appUser = AppUser.fromJson((Office)userOffice, (Staff)linkedStaff, (Set)allRoles, clients, (JsonCommand)command);
            Boolean sendPasswordToEmail = command.booleanObjectValueOfParameterNamed("sendPasswordToEmail");
            this.userDomainService.create(appUser, sendPasswordToEmail);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)appUser.getId()).withOfficeId((Long)userOffice.getId()).build();
        }
        catch (DataIntegrityViolationException dve) {
            throw this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
        }
        catch (PersistenceException | JpaSystemException | AuthenticationServiceException dve) {
            log.error("createUser: JpaSystemException | PersistenceException | AuthenticationServiceException", dve);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            throw this.handleDataIntegrityIssues(command, throwable, (Exception)dve);
        }
        catch (PlatformEmailSendException e) {
            log.error("createUser: PlatformEmailSendException", (Throwable)e);
            String email = command.stringValueOfParameterNamed("email");
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.user.email.invalid", (String)("Sending email failed; is parameter email is invalid? More details available in server log: " + e.getMessage()), (String)"email", (Object[])new Object[]{email});
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", List.of(error), (Throwable)e);
        }
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    public CommandProcessingResult updateUser(Long userId, JsonCommand command) {
        try {
            Map changes;
            this.context.authenticatedUser(new CommandWrapperBuilder().updateUser(null).build());
            this.fromApiJsonDeserializer.validateForUpdate(command.json(), this.context.authenticatedUser());
            AppUser userToUpdate = (AppUser)this.appUserRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
            AppUserPreviousPassword currentPasswordToSaveAsPreview = this.getCurrentPasswordToSaveAsPreview(userToUpdate, command);
            List clients = null;
            boolean isSelfServiceUser = userToUpdate.isSelfServiceUser();
            if (command.hasParameter("isSelfServiceUser")) {
                isSelfServiceUser = command.booleanPrimitiveValueOfParameterNamed("isSelfServiceUser");
            }
            if (isSelfServiceUser && command.hasParameter("clients")) {
                JsonArray clientsArray = command.arrayOfParameterNamed("clients");
                HashSet<Long> clientIds = new HashSet<Long>();
                for (JsonElement clientElement : clientsArray) {
                    clientIds.add(clientElement.getAsLong());
                }
                clients = this.clientRepositoryWrapper.findAll(clientIds);
            }
            if ((changes = userToUpdate.update(command, this.platformPasswordEncoder, clients)).containsKey("officeId")) {
                Long officeId = (Long)changes.get("officeId");
                Office office = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
                userToUpdate.changeOffice(office);
            }
            if (changes.containsKey("staffId")) {
                Long staffId = (Long)changes.get("staffId");
                Staff linkedStaff = null;
                if (staffId != null) {
                    linkedStaff = this.staffRepositoryWrapper.findByOfficeWithNotFoundDetection(staffId, (Long)userToUpdate.getOffice().getId());
                }
                userToUpdate.changeStaff(linkedStaff);
            }
            if (changes.containsKey("roles")) {
                String[] roleIds = (String[])changes.get("roles");
                Set allRoles = this.assembleSetOfRoles(roleIds);
                userToUpdate.updateRoles(allRoles);
            }
            if (!changes.isEmpty()) {
                this.appUserRepository.saveAndFlush((Object)userToUpdate);
                if (currentPasswordToSaveAsPreview != null) {
                    this.appUserPreviewPasswordRepository.save((Object)currentPasswordToSaveAsPreview);
                }
            }
            return new CommandProcessingResultBuilder().withEntityId(userId).withOfficeId((Long)userToUpdate.getOffice().getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException dve) {
            throw this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
        }
        catch (PersistenceException | JpaSystemException | AuthenticationServiceException dve) {
            log.error("updateUser: JpaSystemException | PersistenceException | AuthenticationServiceException", dve);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            throw this.handleDataIntegrityIssues(command, throwable, (Exception)dve);
        }
    }

    private AppUserPreviousPassword getCurrentPasswordToSaveAsPreview(AppUser user, JsonCommand command) {
        String passWordEncodedValue = user.getEncodedPassword(command, this.platformPasswordEncoder);
        AppUserPreviousPassword currentPasswordToSaveAsPreview = null;
        if (passWordEncodedValue != null) {
            PageRequest pageRequest = PageRequest.of((int)0, (int)3, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"removalDate"});
            List nLastUsedPasswords = this.appUserPreviewPasswordRepository.findByUserId((Long)user.getId(), (Pageable)pageRequest);
            for (AppUserPreviousPassword aPreviewPassword : nLastUsedPasswords) {
                if (!aPreviewPassword.getPassword().equals(passWordEncodedValue)) continue;
                throw new PasswordPreviouslyUsedException();
            }
            currentPasswordToSaveAsPreview = new AppUserPreviousPassword(user);
        }
        return currentPasswordToSaveAsPreview;
    }

    private Set<Role> assembleSetOfRoles(String[] rolesArray) {
        HashSet<Role> allRoles = new HashSet<Role>();
        if (!ObjectUtils.isEmpty((Object[])rolesArray)) {
            for (String roleId : rolesArray) {
                Long id = Long.valueOf(roleId);
                Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new RoleNotFoundException(id));
                allRoles.add(role);
            }
        }
        return allRoles;
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    public CommandProcessingResult deleteUser(Long userId) {
        AppUser user = (AppUser)this.appUserRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (user.isDeleted()) {
            throw new UserNotFoundException(userId);
        }
        user.delete();
        this.appUserRepository.save((Object)user);
        return new CommandProcessingResultBuilder().withEntityId(userId).withOfficeId((Long)user.getOffice().getId()).build();
    }

    private RuntimeException handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("username_org")) {
            String username = command.stringValueOfParameterNamed("username");
            String defaultMessage = "User with username " + username + " already exists.";
            return new PlatformDataIntegrityException("error.msg.user.duplicate.username", defaultMessage, "username", new Object[]{username});
        }
        if (realCause.getMessage().contains("unique_self_client")) {
            return new PlatformDataIntegrityException("error.msg.user.self.service.user.already.exist", "Self Service User Id is already created. Go to Admin->Users to edit or delete the self-service user.", new Object[0]);
        }
        log.error("handleDataIntegrityIssues: Neither duplicate username nor existing user; unknown error occured", (Throwable)dve);
        return ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public AppUserWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, UserDomainService userDomainService, PlatformPasswordEncoder platformPasswordEncoder, AppUserRepository appUserRepository, OfficeRepositoryWrapper officeRepositoryWrapper, RoleRepository roleRepository, UserDataValidator fromApiJsonDeserializer, AppUserPreviousPasswordRepository appUserPreviewPasswordRepository, StaffRepositoryWrapper staffRepositoryWrapper, ClientRepositoryWrapper clientRepositoryWrapper) {
        this.context = context;
        this.userDomainService = userDomainService;
        this.platformPasswordEncoder = platformPasswordEncoder;
        this.appUserRepository = appUserRepository;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.roleRepository = roleRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.appUserPreviewPasswordRepository = appUserPreviewPasswordRepository;
        this.staffRepositoryWrapper = staffRepositoryWrapper;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
    }
}

