/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_appuser_previous_password")
public class AppUserPreviousPassword
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="user_id", nullable=false)
    private Long userId;
    @Column(name="removal_date")
    private LocalDate removalDate;
    @Column(name="password", nullable=false)
    private String password;
    static final long serialVersionUID = 7237440918444371131L;

    protected AppUserPreviousPassword() {
    }

    public AppUserPreviousPassword(AppUser user) {
        this.userId = (Long)user.getId();
        this.password = user.getPassword().trim();
        this.removalDate = DateUtils.getLocalDateOfTenant();
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AppUserPreviousPassword();
    }

    public Object _persistence_get(String string) {
        if (string == "password") {
            return this.password;
        }
        if (string == "removalDate") {
            return this.removalDate;
        }
        if (string == "userId") {
            return this.userId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "removalDate") {
            this.removalDate = (LocalDate)object;
            return;
        }
        if (string == "userId") {
            this.userId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this._persistence_propertyChange("password", (Object)this.password, (Object)string);
        this.password = string;
    }

    public LocalDate _persistence_get_removalDate() {
        this._persistence_checkFetched("removalDate");
        return this.removalDate;
    }

    public void _persistence_set_removalDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("removalDate");
        this._persistence_propertyChange("removalDate", (Object)this.removalDate, (Object)localDate);
        this.removalDate = localDate;
    }

    public Long _persistence_get_userId() {
        this._persistence_checkFetched("userId");
        return this.userId;
    }

    public void _persistence_set_userId(Long l) {
        this._persistence_checkFetchedForSet("userId");
        this._persistence_propertyChange("userId", (Object)this.userId, (Object)l);
        this.userId = l;
    }
}

