/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.template.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateFunctions;
import org.apache.fineract.template.exception.TemplateForbiddenException;
import org.apache.fineract.template.service.TrustModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class TemplateMergeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateMergeService.class);
    private final FineractProperties fineractProperties;

    private static String getStringFromInputStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error("getStringFromInputStream() failed", (Throwable)e);
        }
        return sb.toString();
    }

    public String compile(Template template, Map<String, Object> scopes) {
        scopes.put("static", new TemplateFunctions());
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(template.getText()), template.getName());
        this.getCompiledMapFromMappers((Map)template.getMappersAsMap(), scopes);
        this.expandMapArrays(scopes);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, scopes);
        return stringWriter.toString();
    }

    private Map<String, Object> getCompiledMapFromMappers(Map<String, String> data, Map<String, Object> scopes) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                Mustache mappersMustache = mf.compile((Reader)new StringReader(entry.getValue()), "");
                StringWriter stringWriter = new StringWriter();
                mappersMustache.execute((Writer)stringWriter, scopes);
                Object url = stringWriter.toString();
                if (!((String)url).startsWith("http")) {
                    url = String.valueOf(scopes.get("BASE_URI")) + (String)url;
                }
                try {
                    scopes.put(entry.getKey(), this.getMapFromUrl((String)url));
                }
                catch (IOException e) {
                    log.error("getCompiledMapFromMappers() failed", (Throwable)e);
                }
            }
        }
        return scopes;
    }

    private Map<String, Object> getMapFromUrl(String url) throws IOException {
        HttpURLConnection connection = this.getConnection(url);
        String response = TemplateMergeService.getStringFromInputStream((InputStream)connection.getInputStream());
        HashMap result = new HashMap();
        if (connection.getContentType().equals("text/plain")) {
            result.put("src", response);
        } else {
            result = (HashMap)new ObjectMapper().readValue(response, HashMap.class);
        }
        return result;
    }

    private HttpURLConnection getConnection(String url) {
        String authToken;
        if (this.fineractProperties.getTemplate() != null && this.fineractProperties.getTemplate().isRegexWhitelistEnabled()) {
            boolean whitelisted = false;
            if (this.fineractProperties.getTemplate().getRegexWhitelist() != null && !this.fineractProperties.getTemplate().getRegexWhitelist().isEmpty()) {
                for (String urlPattern : this.fineractProperties.getTemplate().getRegexWhitelist()) {
                    Pattern pattern = Pattern.compile(urlPattern);
                    Matcher matcher = pattern.matcher(url);
                    if (!matcher.matches()) continue;
                    whitelisted = true;
                    break;
                }
            }
            if (!whitelisted) {
                throw new TemplateForbiddenException(url);
            }
        }
        if ((authToken = ThreadLocalContextUtil.getAuthToken()) == null) {
            String name = SecurityContextHolder.getContext().getAuthentication().getName();
            String password = SecurityContextHolder.getContext().getAuthentication().getCredentials().toString();
            Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            if (authToken != null) {
                connection.setRequestProperty("Authorization", "Basic " + authToken);
            }
            TrustModifier.relaxHostChecking((HttpURLConnection)connection);
            connection.setDoInput(true);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("getConnection() failed, return null", (Throwable)e);
        }
        return connection;
    }

    private void expandMapArrays(Object value) {
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            HashMap valueAsMapTemp = new HashMap();
            for (Map.Entry valueAsMapEntry : valueAsMap.entrySet()) {
                Object valueAsMapEntryValue = valueAsMapEntry.getValue();
                if (valueAsMapEntryValue instanceof Map) {
                    this.expandMapArrays(valueAsMapEntryValue);
                    continue;
                }
                if (!(valueAsMapEntryValue instanceof Iterable)) continue;
                Iterable valueAsMapEntryValueIterable = (Iterable)valueAsMapEntryValue;
                String valueAsMapEntryKey = (String)valueAsMapEntry.getKey();
                int i = 0;
                for (Object object : valueAsMapEntryValueIterable) {
                    valueAsMapTemp.put((CallSite)((Object)(valueAsMapEntryKey + "#" + i)), object);
                    ++i;
                    this.expandMapArrays(object);
                }
            }
            valueAsMap.putAll(valueAsMapTemp);
        }
    }

    @Generated
    public TemplateMergeService(FineractProperties fineractProperties) {
        this.fineractProperties = fineractProperties;
    }
}

