/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.spm.domain.Component;
import org.apache.fineract.spm.domain.Question;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_surveys")
public class Survey
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @OneToMany(mappedBy="survey", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequenceNo")
    private List<Component> components;
    @OneToMany(mappedBy="survey", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequenceNo")
    private List<Question> questions;
    @Column(name="a_key", length=32)
    private String key;
    @Column(name="a_name", length=255)
    private String name;
    @Column(name="description", length=4096)
    private String description;
    @Column(name="country_code", length=2)
    private String countryCode;
    @Column(name="valid_from")
    private LocalDate validFrom;
    @Column(name="valid_to")
    private LocalDate validTo;
    static final long serialVersionUID = 8667828682491690344L;

    public List<Component> getComponents() {
        return this._persistence_get_components();
    }

    public void setComponents(List<Component> components) {
        this._persistence_set_components(components);
    }

    public List<Question> getQuestions() {
        return this._persistence_get_questions();
    }

    public void setQuestions(List<Question> questions) {
        if (this._persistence_get_questions() != null) {
            this._persistence_get_questions().clear();
        } else {
            this._persistence_set_questions(new ArrayList());
        }
        this._persistence_get_questions().addAll(questions);
    }

    public String getKey() {
        return this._persistence_get_key();
    }

    public void setKey(String key) {
        this._persistence_set_key(key);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getCountryCode() {
        return this._persistence_get_countryCode();
    }

    public void setCountryCode(String countryCode) {
        this._persistence_set_countryCode(countryCode);
    }

    public LocalDate getValidFrom() {
        return this._persistence_get_validFrom();
    }

    public void setValidFrom(LocalDate validFrom) {
        this._persistence_set_validFrom(validFrom);
    }

    public LocalDate getValidTo() {
        return this._persistence_get_validTo();
    }

    public void setValidTo(LocalDate validTo) {
        this._persistence_set_validTo(validTo);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Survey();
    }

    public Object _persistence_get(String string) {
        if (string == "components") {
            return this.components;
        }
        if (string == "countryCode") {
            return this.countryCode;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "questions") {
            return this.questions;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "validFrom") {
            return this.validFrom;
        }
        if (string == "key") {
            return this.key;
        }
        if (string == "validTo") {
            return this.validTo;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "components") {
            this.components = (List)object;
            return;
        }
        if (string == "countryCode") {
            this.countryCode = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "questions") {
            this.questions = (List)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "validFrom") {
            this.validFrom = (LocalDate)object;
            return;
        }
        if (string == "key") {
            this.key = (String)object;
            return;
        }
        if (string == "validTo") {
            this.validTo = (LocalDate)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_components() {
        this._persistence_checkFetched("components");
        return this.components;
    }

    public void _persistence_set_components(List list) {
        this._persistence_checkFetchedForSet("components");
        this.components = list;
    }

    public String _persistence_get_countryCode() {
        this._persistence_checkFetched("countryCode");
        return this.countryCode;
    }

    public void _persistence_set_countryCode(String string) {
        this._persistence_checkFetchedForSet("countryCode");
        this.countryCode = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public List _persistence_get_questions() {
        this._persistence_checkFetched("questions");
        return this.questions;
    }

    public void _persistence_set_questions(List list) {
        this._persistence_checkFetchedForSet("questions");
        this.questions = list;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public LocalDate _persistence_get_validFrom() {
        this._persistence_checkFetched("validFrom");
        return this.validFrom;
    }

    public void _persistence_set_validFrom(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validFrom");
        this.validFrom = localDate;
    }

    public String _persistence_get_key() {
        this._persistence_checkFetched("key");
        return this.key;
    }

    public void _persistence_set_key(String string) {
        this._persistence_checkFetchedForSet("key");
        this.key = string;
    }

    public LocalDate _persistence_get_validTo() {
        this._persistence_checkFetched("validTo");
        return this.validTo;
    }

    public void _persistence_set_validTo(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validTo");
        this.validTo = localDate;
    }
}

