/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_product_market_price")
public class ShareProductMarketPrice
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="product_id", referencedColumnName="id", nullable=false)
    private ShareProduct product;
    @Column(name="from_date")
    private LocalDate fromDate;
    @Column(name="share_value", nullable=false)
    private BigDecimal shareValue;
    static final long serialVersionUID = -4590790244834588922L;

    public ShareProductMarketPrice() {
    }

    public ShareProductMarketPrice(LocalDate fromDate, BigDecimal shareValue) {
        this.fromDate = fromDate;
        this.shareValue = shareValue;
    }

    public void setShareProduct(ShareProduct product) {
        this._persistence_set_product(product);
    }

    public LocalDate getStartDate() {
        return this._persistence_get_fromDate();
    }

    public BigDecimal getPrice() {
        return this._persistence_get_shareValue();
    }

    public void setStartDate(LocalDate date) {
        this._persistence_set_fromDate(date);
    }

    public void setShareValue(BigDecimal value) {
        this._persistence_set_shareValue(value);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareProductMarketPrice();
    }

    public Object _persistence_get(String string) {
        if (string == "fromDate") {
            return this.fromDate;
        }
        if (string == "product") {
            return this.product;
        }
        if (string == "shareValue") {
            return this.shareValue;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "fromDate") {
            this.fromDate = (LocalDate)object;
            return;
        }
        if (string == "product") {
            this.product = (ShareProduct)object;
            return;
        }
        if (string == "shareValue") {
            this.shareValue = (BigDecimal)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_fromDate() {
        this._persistence_checkFetched("fromDate");
        return this.fromDate;
    }

    public void _persistence_set_fromDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("fromDate");
        this._persistence_propertyChange("fromDate", (Object)this.fromDate, (Object)localDate);
        this.fromDate = localDate;
    }

    public ShareProduct _persistence_get_product() {
        this._persistence_checkFetched("product");
        return this.product;
    }

    public void _persistence_set_product(ShareProduct shareProduct) {
        this._persistence_checkFetchedForSet("product");
        this._persistence_propertyChange("product", (Object)this.product, (Object)shareProduct);
        this.product = shareProduct;
    }

    public BigDecimal _persistence_get_shareValue() {
        this._persistence_checkFetched("shareValue");
        return this.shareValue;
    }

    public void _persistence_set_shareValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("shareValue");
        this._persistence_propertyChange("shareValue", (Object)this.shareValue, (Object)bigDecimal);
        this.shareValue = bigDecimal;
    }
}

