/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendDetails;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividendStatusType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_product_dividend_pay_out")
public class ShareProductDividendPayOutDetails
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="product_id", nullable=true)
    private Long shareProductId;
    @Column(name="amount", scale=6, precision=19)
    private BigDecimal amount;
    @Column(name="dividend_period_start_date")
    private LocalDate dividendPeriodStartDate;
    @Column(name="dividend_period_end_date")
    private LocalDate dividendPeriodEndDate;
    @Column(name="status", nullable=false)
    private Integer status;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="productDividentPayOutDetails")
    private List<ShareAccountDividendDetails> accountDividendDetails = new ArrayList();
    static final long serialVersionUID = 5781258009730539412L;

    protected ShareProductDividendPayOutDetails() {
    }

    public ShareProductDividendPayOutDetails(Long shareProductId, BigDecimal amount, LocalDate dividendPeriodStartDate, LocalDate dividendPeriodEndDate) {
        this.shareProductId = shareProductId;
        this.amount = amount;
        this.dividendPeriodStartDate = dividendPeriodStartDate;
        this.dividendPeriodEndDate = dividendPeriodEndDate;
        this.status = ShareProductDividendStatusType.INITIATED.getValue();
    }

    public LocalDate getDividendPeriodEndDateAsLocalDate() {
        return this._persistence_get_dividendPeriodEndDate();
    }

    public List<ShareAccountDividendDetails> getAccountDividendDetails() {
        return this._persistence_get_accountDividendDetails();
    }

    public void approveDividendPayout() {
        this._persistence_set_status(ShareProductDividendStatusType.APPROVED.getValue());
    }

    public ShareProductDividendStatusType getStatus() {
        return ShareProductDividendStatusType.fromInt((Integer)this._persistence_get_status());
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareProductDividendPayOutDetails();
    }

    public Object _persistence_get(String string) {
        if (string == "dividendPeriodStartDate") {
            return this.dividendPeriodStartDate;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "shareProductId") {
            return this.shareProductId;
        }
        if (string == "accountDividendDetails") {
            return this.accountDividendDetails;
        }
        if (string == "dividendPeriodEndDate") {
            return this.dividendPeriodEndDate;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "dividendPeriodStartDate") {
            this.dividendPeriodStartDate = (LocalDate)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "shareProductId") {
            this.shareProductId = (Long)object;
            return;
        }
        if (string == "accountDividendDetails") {
            this.accountDividendDetails = (List)object;
            return;
        }
        if (string == "dividendPeriodEndDate") {
            this.dividendPeriodEndDate = (LocalDate)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_dividendPeriodStartDate() {
        this._persistence_checkFetched("dividendPeriodStartDate");
        return this.dividendPeriodStartDate;
    }

    public void _persistence_set_dividendPeriodStartDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dividendPeriodStartDate");
        this.dividendPeriodStartDate = localDate;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this.amount = bigDecimal;
    }

    public Long _persistence_get_shareProductId() {
        this._persistence_checkFetched("shareProductId");
        return this.shareProductId;
    }

    public void _persistence_set_shareProductId(Long l) {
        this._persistence_checkFetchedForSet("shareProductId");
        this.shareProductId = l;
    }

    public List _persistence_get_accountDividendDetails() {
        this._persistence_checkFetched("accountDividendDetails");
        return this.accountDividendDetails;
    }

    public void _persistence_set_accountDividendDetails(List list) {
        this._persistence_checkFetchedForSet("accountDividendDetails");
        this.accountDividendDetails = list;
    }

    public LocalDate _persistence_get_dividendPeriodEndDate() {
        this._persistence_checkFetched("dividendPeriodEndDate");
        return this.dividendPeriodEndDate;
    }

    public void _persistence_set_dividendPeriodEndDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dividendPeriodEndDate");
        this.dividendPeriodEndDate = localDate;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this.status = n;
    }
}

