/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductMarketPriceData;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductMarketPrice;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_product")
public class ShareProduct
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="name", nullable=false, unique=true)
    private String name;
    @Column(name="short_name", nullable=false, unique=true)
    private String shortName;
    @Column(name="description")
    private String description;
    @Column(name="start_date")
    private LocalDate startDate;
    @Column(name="end_date")
    private LocalDate endDate;
    @Column(name="external_id", length=100, nullable=true, unique=true)
    private String externalId;
    @Embedded
    private MonetaryCurrency currency;
    @Column(name="total_shares", nullable=false)
    private Long totalShares;
    @Column(name="issued_shares", nullable=false)
    private Long totalSharesIssued;
    @Column(name="totalsubscribed_shares", nullable=true)
    private Long totalSubscribedShares;
    @Column(name="unit_price", nullable=false)
    private BigDecimal unitPrice;
    @Column(name="capital_amount", nullable=false)
    private BigDecimal shareCapital;
    @Column(name="minimum_client_shares")
    private Long minimumShares;
    @Column(name="nominal_client_shares", nullable=false)
    private Long nominalShares;
    @Column(name="maximum_client_shares")
    private Long maximumShares;
    @OrderBy(value="fromDate,id")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="product", orphanRemoval=true, fetch=FetchType.EAGER)
    Set<ShareProductMarketPrice> marketPrice;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="m_share_product_charge", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="charge_id")})
    private Set<Charge> charges;
    @Column(name="allow_dividends_inactive_clients")
    private Boolean allowDividendCalculationForInactiveClients;
    @Column(name="lockin_period_frequency")
    private Integer lockinPeriod;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="lockin_period_frequency_enum", nullable=true)
    private PeriodFrequencyType lockPeriodType;
    @Column(name="minimum_active_period_frequency")
    private Integer minimumActivePeriod;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="minimum_active_period_frequency_enum", nullable=true)
    private PeriodFrequencyType minimumActivePeriodType;
    @Column(name="accounting_type", nullable=false)
    protected Integer accountingRule;
    static final long serialVersionUID = 6088586915659072691L;

    protected ShareProduct() {
    }

    public ShareProduct(String name, String shortName, String description, String externalId, MonetaryCurrency currency, Long totalShares, Long totalSharesIssued, BigDecimal unitPrice, BigDecimal shareCapital, Long minimumShares, Long nominalShares, Long maximumShares, Set<ShareProductMarketPrice> marketPrice, Set<Charge> charges, Boolean allowDividendCalculationForInactiveClients, Integer lockinPeriod, PeriodFrequencyType lockPeriodType, Integer minimumActivePeriod, PeriodFrequencyType minimumActivePeriodForDividendsType, AccountingRuleType accountingRuleType) {
        this.name = name;
        this.shortName = shortName;
        this.description = description;
        this.externalId = externalId;
        this.currency = currency;
        this.totalShares = totalShares;
        this.totalSharesIssued = totalSharesIssued;
        this.unitPrice = unitPrice;
        this.shareCapital = shareCapital;
        this.minimumShares = minimumShares;
        this.nominalShares = nominalShares;
        this.maximumShares = maximumShares;
        this.marketPrice = marketPrice;
        this.charges = charges;
        this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
        this.lockinPeriod = lockinPeriod;
        this.lockPeriodType = lockPeriodType;
        this.minimumActivePeriod = minimumActivePeriod;
        this.minimumActivePeriodType = minimumActivePeriodForDividendsType;
        this.startDate = DateUtils.getBusinessLocalDate();
        this.endDate = DateUtils.getBusinessLocalDate();
        if (accountingRuleType != null) {
            this.accountingRule = accountingRuleType.getValue();
        }
    }

    public boolean setProductName(String productName) {
        boolean returnValue = false;
        if (!this._persistence_get_name().equals(productName)) {
            this._persistence_set_name(productName);
            returnValue = true;
        }
        return returnValue;
    }

    public String getProductName() {
        return this._persistence_get_name();
    }

    public boolean setShortName(String shortName) {
        boolean returnValue = false;
        if (!this._persistence_get_shortName().equals(shortName)) {
            this._persistence_set_shortName(shortName);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setDescription(String description) {
        boolean returnValue = false;
        if (this._persistence_get_description() == null || !this._persistence_get_description().equals(description)) {
            this._persistence_set_description(description);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setExternalId(String externalId) {
        boolean returnValue = false;
        if (this._persistence_get_externalId() == null || !this._persistence_get_externalId().equals(externalId)) {
            this._persistence_set_externalId(externalId);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setTotalShares(Long totalShares) {
        boolean returnValue = false;
        if (!this._persistence_get_totalShares().equals(totalShares)) {
            this._persistence_set_totalShares(totalShares);
            returnValue = true;
        }
        return returnValue;
    }

    public Long getTotalShares() {
        return this._persistence_get_totalShares();
    }

    public boolean setTotalIssuedShares(Long totalSharesIssued) {
        boolean returnValue = false;
        if (this._persistence_get_totalSharesIssued() == null || !this._persistence_get_totalSharesIssued().equals(totalSharesIssued)) {
            this._persistence_set_totalSharesIssued(totalSharesIssued);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setMonetaryCurrency(MonetaryCurrency currency) {
        boolean returnValue = false;
        if (!this._persistence_get_currency().equals(currency)) {
            this._persistence_set_currency(currency);
            returnValue = true;
        }
        return returnValue;
    }

    public MonetaryCurrency getCurrency() {
        return this._persistence_get_currency();
    }

    public boolean setUnitPrice(BigDecimal unitPrice) {
        boolean returnValue = false;
        if (this._persistence_get_unitPrice().compareTo(unitPrice) != 0) {
            this._persistence_set_unitPrice(unitPrice);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setMinimumShares(Long minimumShares) {
        boolean returnValue = false;
        if (this._persistence_get_minimumShares() == null || !this._persistence_get_minimumShares().equals(minimumShares)) {
            this._persistence_set_minimumShares(minimumShares);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setNominalShares(Long nominalShares) {
        boolean returnValue = false;
        if (!this._persistence_get_nominalShares().equals(nominalShares)) {
            this._persistence_set_nominalShares(nominalShares);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setMaximumShares(Long maximumShares) {
        boolean returnValue = false;
        if (this._persistence_get_maximumShares() == null || !this._persistence_get_maximumShares().equals(maximumShares)) {
            this._persistence_set_maximumShares(maximumShares);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setMarketPrice(Set<ShareProductMarketPriceData> marketPrice) {
        boolean update = true;
        HashSet<ShareProductMarketPrice> marketPriceTemp = new HashSet<ShareProductMarketPrice>();
        if (marketPrice != null && marketPrice.size() > 0) {
            for (ShareProductMarketPriceData data : marketPrice) {
                if (data.getId() == null) {
                    ShareProductMarketPrice entity = new ShareProductMarketPrice(data.getFromDate(), data.getShareValue());
                    entity.setShareProduct(this);
                    marketPriceTemp.add(entity);
                    continue;
                }
                for (ShareProductMarketPrice priceData : this._persistence_get_marketPrice()) {
                    if (!((Long)priceData.getId()).equals(data.getId())) continue;
                    priceData.setStartDate(data.getFromDate());
                    priceData.setShareValue(data.getShareValue());
                    marketPriceTemp.add(priceData);
                }
            }
        }
        this._persistence_set_marketPrice(marketPriceTemp);
        return update;
    }

    public boolean setCharges(Set<Charge> charges) {
        this._persistence_get_charges().clear();
        this._persistence_get_charges().addAll(charges);
        return true;
    }

    public boolean setAllowDividendCalculationForInactiveClients(Boolean allowDividendCalculationForInactiveClients) {
        boolean returnValue = false;
        if (this._persistence_get_allowDividendCalculationForInactiveClients() == null || !this._persistence_get_allowDividendCalculationForInactiveClients().equals(allowDividendCalculationForInactiveClients)) {
            this._persistence_set_allowDividendCalculationForInactiveClients(allowDividendCalculationForInactiveClients);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setLockinPeriod(Integer lockinPeriod) {
        boolean returnValue = false;
        if (this._persistence_get_lockinPeriod() == null || !this._persistence_get_lockinPeriod().equals(lockinPeriod)) {
            this._persistence_set_lockinPeriod(lockinPeriod);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setLockPeriodFrequencyType(PeriodFrequencyType lockPeriod) {
        boolean returnValue = false;
        if (this._persistence_get_lockPeriodType() == null || !this._persistence_get_lockPeriodType().equals((Object)lockPeriod)) {
            this._persistence_set_lockPeriodType(lockPeriod);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setminimumActivePeriod(Integer minimumActivePeriod) {
        boolean returnValue = false;
        if (this._persistence_get_minimumActivePeriod() == null || !this._persistence_get_minimumActivePeriod().equals(minimumActivePeriod)) {
            this._persistence_set_minimumActivePeriod(minimumActivePeriod);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setminimumActivePeriodFrequencyType(PeriodFrequencyType minimumActivePeriodForDividends) {
        boolean returnValue = false;
        if (this._persistence_get_minimumActivePeriodType() == null || !this._persistence_get_minimumActivePeriodType().equals((Object)minimumActivePeriodForDividends)) {
            this._persistence_set_minimumActivePeriodType(minimumActivePeriodForDividends);
            returnValue = true;
        }
        return returnValue;
    }

    public String getShortName() {
        return this._persistence_get_shortName();
    }

    public boolean setshareCapitalValue(BigDecimal shareCapitalValue) {
        boolean updated = false;
        if (this._persistence_get_shareCapital() == null || this._persistence_get_shareCapital().compareTo(shareCapitalValue) != 0) {
            this._persistence_set_shareCapital(shareCapitalValue);
            updated = true;
        }
        return updated;
    }

    public boolean setAccountingRule(Integer accountingRule) {
        boolean returnValue = false;
        if (!this._persistence_get_accountingRule().equals(accountingRule)) {
            this._persistence_set_accountingRule(accountingRule);
            returnValue = true;
        }
        return returnValue;
    }

    public Long getSharesIssued() {
        return this._persistence_get_totalSharesIssued();
    }

    public BigDecimal getUnitPrice() {
        return this._persistence_get_unitPrice();
    }

    public Integer getAccountingType() {
        return this._persistence_get_accountingRule();
    }

    public boolean isSharesAllowed(Long requestedShares) {
        boolean allowed = true;
        if (this._persistence_get_minimumShares() != null && this._persistence_get_maximumShares() != null && (requestedShares < this._persistence_get_minimumShares() || requestedShares > this._persistence_get_maximumShares())) {
            allowed = false;
        }
        return allowed;
    }

    public BigDecimal deriveMarketPrice(LocalDate currentDate) {
        BigDecimal marketValue = this._persistence_get_unitPrice();
        if (this._persistence_get_marketPrice() != null && !this._persistence_get_marketPrice().isEmpty()) {
            for (ShareProductMarketPrice data : this._persistence_get_marketPrice()) {
                LocalDate startDate = data.getStartDate();
                if (DateUtils.isAfter((LocalDate)startDate, (LocalDate)currentDate)) continue;
                marketValue = data.getPrice();
            }
        }
        return marketValue;
    }

    public void addSubscribedShares(Long subscribedShares) {
        if (this._persistence_get_totalSubscribedShares() == null) {
            this._persistence_set_totalSubscribedShares(Long.valueOf(0L));
        }
        this._persistence_set_totalSubscribedShares(Long.valueOf(this._persistence_get_totalSubscribedShares() + subscribedShares));
    }

    public void removeSubscribedShares(Long subscribedShares) {
        this._persistence_set_totalSubscribedShares(Long.valueOf(this._persistence_get_totalSubscribedShares() - subscribedShares));
    }

    public Long getSubscribedShares() {
        return this._persistence_get_totalSubscribedShares();
    }

    public Long getMinimumClientShares() {
        return this._persistence_get_minimumShares();
    }

    public Long getMaximumClientShares() {
        return this._persistence_get_maximumShares();
    }

    public Long getDefaultClientShares() {
        return this._persistence_get_nominalShares();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareProduct();
    }

    public Object _persistence_get(String string) {
        if (string == "totalSharesIssued") {
            return this.totalSharesIssued;
        }
        if (string == "marketPrice") {
            return this.marketPrice;
        }
        if (string == "lockPeriodType") {
            return this.lockPeriodType;
        }
        if (string == "endDate") {
            return this.endDate;
        }
        if (string == "minimumActivePeriod") {
            return this.minimumActivePeriod;
        }
        if (string == "nominalShares") {
            return this.nominalShares;
        }
        if (string == "allowDividendCalculationForInactiveClients") {
            return this.allowDividendCalculationForInactiveClients;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "minimumShares") {
            return this.minimumShares;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "lockinPeriod") {
            return this.lockinPeriod;
        }
        if (string == "unitPrice") {
            return this.unitPrice;
        }
        if (string == "externalId") {
            return this.externalId;
        }
        if (string == "totalShares") {
            return this.totalShares;
        }
        if (string == "charges") {
            return this.charges;
        }
        if (string == "totalSubscribedShares") {
            return this.totalSubscribedShares;
        }
        if (string == "shareCapital") {
            return this.shareCapital;
        }
        if (string == "accountingRule") {
            return this.accountingRule;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "minimumActivePeriodType") {
            return this.minimumActivePeriodType;
        }
        if (string == "shortName") {
            return this.shortName;
        }
        if (string == "startDate") {
            return this.startDate;
        }
        if (string == "maximumShares") {
            return this.maximumShares;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "totalSharesIssued") {
            this.totalSharesIssued = (Long)object;
            return;
        }
        if (string == "marketPrice") {
            this.marketPrice = (Set)object;
            return;
        }
        if (string == "lockPeriodType") {
            this.lockPeriodType = (PeriodFrequencyType)object;
            return;
        }
        if (string == "endDate") {
            this.endDate = (LocalDate)object;
            return;
        }
        if (string == "minimumActivePeriod") {
            this.minimumActivePeriod = (Integer)object;
            return;
        }
        if (string == "nominalShares") {
            this.nominalShares = (Long)object;
            return;
        }
        if (string == "allowDividendCalculationForInactiveClients") {
            this.allowDividendCalculationForInactiveClients = (Boolean)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "minimumShares") {
            this.minimumShares = (Long)object;
            return;
        }
        if (string == "currency") {
            this.currency = (MonetaryCurrency)object;
            return;
        }
        if (string == "lockinPeriod") {
            this.lockinPeriod = (Integer)object;
            return;
        }
        if (string == "unitPrice") {
            this.unitPrice = (BigDecimal)object;
            return;
        }
        if (string == "externalId") {
            this.externalId = (String)object;
            return;
        }
        if (string == "totalShares") {
            this.totalShares = (Long)object;
            return;
        }
        if (string == "charges") {
            this.charges = (Set)object;
            return;
        }
        if (string == "totalSubscribedShares") {
            this.totalSubscribedShares = (Long)object;
            return;
        }
        if (string == "shareCapital") {
            this.shareCapital = (BigDecimal)object;
            return;
        }
        if (string == "accountingRule") {
            this.accountingRule = (Integer)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "minimumActivePeriodType") {
            this.minimumActivePeriodType = (PeriodFrequencyType)object;
            return;
        }
        if (string == "shortName") {
            this.shortName = (String)object;
            return;
        }
        if (string == "startDate") {
            this.startDate = (LocalDate)object;
            return;
        }
        if (string == "maximumShares") {
            this.maximumShares = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_totalSharesIssued() {
        this._persistence_checkFetched("totalSharesIssued");
        return this.totalSharesIssued;
    }

    public void _persistence_set_totalSharesIssued(Long l) {
        this._persistence_checkFetchedForSet("totalSharesIssued");
        this.totalSharesIssued = l;
    }

    public Set _persistence_get_marketPrice() {
        this._persistence_checkFetched("marketPrice");
        return this.marketPrice;
    }

    public void _persistence_set_marketPrice(Set set) {
        this._persistence_checkFetchedForSet("marketPrice");
        this.marketPrice = set;
    }

    public PeriodFrequencyType _persistence_get_lockPeriodType() {
        this._persistence_checkFetched("lockPeriodType");
        return this.lockPeriodType;
    }

    public void _persistence_set_lockPeriodType(PeriodFrequencyType periodFrequencyType) {
        this._persistence_checkFetchedForSet("lockPeriodType");
        this.lockPeriodType = periodFrequencyType;
    }

    public LocalDate _persistence_get_endDate() {
        this._persistence_checkFetched("endDate");
        return this.endDate;
    }

    public void _persistence_set_endDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("endDate");
        this.endDate = localDate;
    }

    public Integer _persistence_get_minimumActivePeriod() {
        this._persistence_checkFetched("minimumActivePeriod");
        return this.minimumActivePeriod;
    }

    public void _persistence_set_minimumActivePeriod(Integer n) {
        this._persistence_checkFetchedForSet("minimumActivePeriod");
        this.minimumActivePeriod = n;
    }

    public Long _persistence_get_nominalShares() {
        this._persistence_checkFetched("nominalShares");
        return this.nominalShares;
    }

    public void _persistence_set_nominalShares(Long l) {
        this._persistence_checkFetchedForSet("nominalShares");
        this.nominalShares = l;
    }

    public Boolean _persistence_get_allowDividendCalculationForInactiveClients() {
        this._persistence_checkFetched("allowDividendCalculationForInactiveClients");
        return this.allowDividendCalculationForInactiveClients;
    }

    public void _persistence_set_allowDividendCalculationForInactiveClients(Boolean bl) {
        this._persistence_checkFetchedForSet("allowDividendCalculationForInactiveClients");
        this.allowDividendCalculationForInactiveClients = bl;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public Long _persistence_get_minimumShares() {
        this._persistence_checkFetched("minimumShares");
        return this.minimumShares;
    }

    public void _persistence_set_minimumShares(Long l) {
        this._persistence_checkFetchedForSet("minimumShares");
        this.minimumShares = l;
    }

    public MonetaryCurrency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        return this.currency;
    }

    public void _persistence_set_currency(MonetaryCurrency monetaryCurrency) {
        this._persistence_checkFetchedForSet("currency");
        this.currency = monetaryCurrency;
    }

    public Integer _persistence_get_lockinPeriod() {
        this._persistence_checkFetched("lockinPeriod");
        return this.lockinPeriod;
    }

    public void _persistence_set_lockinPeriod(Integer n) {
        this._persistence_checkFetchedForSet("lockinPeriod");
        this.lockinPeriod = n;
    }

    public BigDecimal _persistence_get_unitPrice() {
        this._persistence_checkFetched("unitPrice");
        return this.unitPrice;
    }

    public void _persistence_set_unitPrice(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("unitPrice");
        this.unitPrice = bigDecimal;
    }

    public String _persistence_get_externalId() {
        this._persistence_checkFetched("externalId");
        return this.externalId;
    }

    public void _persistence_set_externalId(String string) {
        this._persistence_checkFetchedForSet("externalId");
        this.externalId = string;
    }

    public Long _persistence_get_totalShares() {
        this._persistence_checkFetched("totalShares");
        return this.totalShares;
    }

    public void _persistence_set_totalShares(Long l) {
        this._persistence_checkFetchedForSet("totalShares");
        this.totalShares = l;
    }

    public Set _persistence_get_charges() {
        this._persistence_checkFetched("charges");
        return this.charges;
    }

    public void _persistence_set_charges(Set set) {
        this._persistence_checkFetchedForSet("charges");
        this.charges = set;
    }

    public Long _persistence_get_totalSubscribedShares() {
        this._persistence_checkFetched("totalSubscribedShares");
        return this.totalSubscribedShares;
    }

    public void _persistence_set_totalSubscribedShares(Long l) {
        this._persistence_checkFetchedForSet("totalSubscribedShares");
        this.totalSubscribedShares = l;
    }

    public BigDecimal _persistence_get_shareCapital() {
        this._persistence_checkFetched("shareCapital");
        return this.shareCapital;
    }

    public void _persistence_set_shareCapital(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("shareCapital");
        this.shareCapital = bigDecimal;
    }

    public Integer _persistence_get_accountingRule() {
        this._persistence_checkFetched("accountingRule");
        return this.accountingRule;
    }

    public void _persistence_set_accountingRule(Integer n) {
        this._persistence_checkFetchedForSet("accountingRule");
        this.accountingRule = n;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public PeriodFrequencyType _persistence_get_minimumActivePeriodType() {
        this._persistence_checkFetched("minimumActivePeriodType");
        return this.minimumActivePeriodType;
    }

    public void _persistence_set_minimumActivePeriodType(PeriodFrequencyType periodFrequencyType) {
        this._persistence_checkFetchedForSet("minimumActivePeriodType");
        this.minimumActivePeriodType = periodFrequencyType;
    }

    public String _persistence_get_shortName() {
        this._persistence_checkFetched("shortName");
        return this.shortName;
    }

    public void _persistence_set_shortName(String string) {
        this._persistence_checkFetchedForSet("shortName");
        this.shortName = string;
    }

    public LocalDate _persistence_get_startDate() {
        this._persistence_checkFetched("startDate");
        return this.startDate;
    }

    public void _persistence_set_startDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("startDate");
        this.startDate = localDate;
    }

    public Long _persistence_get_maximumShares() {
        this._persistence_checkFetched("maximumShares");
        return this.maximumShares;
    }

    public void _persistence_set_maximumShares(Long l) {
        this._persistence_checkFetchedForSet("maximumShares");
        this.maximumShares = l;
    }
}

