/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountDividendData;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendStatusType;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountDividendReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountDividendReadPlatformServiceImpl;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividendStatusType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ShareAccountDividendReadPlatformServiceImpl
implements ShareAccountDividendReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ColumnValidator columnValidator;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public List<Map<String, Object>> retriveDividendDetailsForPostDividents() {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(" sadd.id as id, ");
        sb.append(" sa.savings_account_id as savingsAccountId ");
        sb.append(" from m_share_account_dividend_details sadd");
        sb.append(" inner join m_share_product_dividend_pay_out spdpo on spdpo.id = sadd.dividend_pay_out_id ");
        sb.append(" inner join m_share_account sa on sa.id = sadd.account_id ");
        sb.append(" where spdpo.status = ? and sadd.status = ?");
        return this.jdbcTemplate.queryForList(sb.toString(), new Object[]{ShareProductDividendStatusType.APPROVED.getValue(), ShareAccountDividendStatusType.INITIATED.getValue()});
    }

    public Page<ShareAccountDividendData> retriveAll(Long payoutDetailId, SearchParameters searchParameters) {
        ShareAccountDividendMapper shareAccountDividendMapper = new ShareAccountDividendMapper();
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(shareAccountDividendMapper.schema());
        sqlBuilder.append(" where sadd.dividend_pay_out_id = ? ");
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(payoutDetailId);
        if (searchParameters.getAccountNo() != null) {
            sqlBuilder.append(" and sa.account_no = ? ");
            params.add(searchParameters.getAccountNo());
        }
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] paramsObj = params.toArray();
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), paramsObj, (RowMapper)shareAccountDividendMapper);
    }

    @Generated
    public ShareAccountDividendReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ColumnValidator columnValidator, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
    }
}

