/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendStatusType;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividendPayOutDetails;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_account_dividend_details")
public class ShareAccountDividendDetails
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="account_id", nullable=false)
    private Long shareAccountId;
    @Column(name="amount", scale=6, precision=19)
    private BigDecimal amount;
    @Column(name="status")
    private Integer status;
    @Column(name="savings_transaction_id")
    private Long savingsTransactionId;
    @ManyToOne
    @JoinColumn(name="dividend_pay_out_id", nullable=false)
    private ShareProductDividendPayOutDetails productDividentPayOutDetails;
    static final long serialVersionUID = 4536338358152417638L;

    protected ShareAccountDividendDetails() {
    }

    public ShareAccountDividendDetails(Long shareAccountId, BigDecimal amount, ShareProductDividendPayOutDetails productDividentPayOutDetails) {
        this.shareAccountId = shareAccountId;
        this.amount = amount;
        this.productDividentPayOutDetails = productDividentPayOutDetails;
        this.status = ShareAccountDividendStatusType.INITIATED.getValue();
    }

    public void update(Integer status, Long savingsTransactionId) {
        this._persistence_set_status(status);
        this._persistence_set_savingsTransactionId(savingsTransactionId);
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public ShareProductDividendPayOutDetails getProductDividentPayOutDetails() {
        return this._persistence_get_productDividentPayOutDetails();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareAccountDividendDetails();
    }

    public Object _persistence_get(String string) {
        if (string == "shareAccountId") {
            return this.shareAccountId;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "productDividentPayOutDetails") {
            return this.productDividentPayOutDetails;
        }
        if (string == "savingsTransactionId") {
            return this.savingsTransactionId;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "shareAccountId") {
            this.shareAccountId = (Long)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "productDividentPayOutDetails") {
            this.productDividentPayOutDetails = (ShareProductDividendPayOutDetails)object;
            return;
        }
        if (string == "savingsTransactionId") {
            this.savingsTransactionId = (Long)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_shareAccountId() {
        this._persistence_checkFetched("shareAccountId");
        return this.shareAccountId;
    }

    public void _persistence_set_shareAccountId(Long l) {
        this._persistence_checkFetchedForSet("shareAccountId");
        this._persistence_propertyChange("shareAccountId", (Object)this.shareAccountId, (Object)l);
        this.shareAccountId = l;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public ShareProductDividendPayOutDetails _persistence_get_productDividentPayOutDetails() {
        this._persistence_checkFetched("productDividentPayOutDetails");
        return this.productDividentPayOutDetails;
    }

    public void _persistence_set_productDividentPayOutDetails(ShareProductDividendPayOutDetails shareProductDividendPayOutDetails) {
        this._persistence_checkFetchedForSet("productDividentPayOutDetails");
        this._persistence_propertyChange("productDividentPayOutDetails", (Object)this.productDividentPayOutDetails, (Object)shareProductDividendPayOutDetails);
        this.productDividentPayOutDetails = shareProductDividendPayOutDetails;
    }

    public Long _persistence_get_savingsTransactionId() {
        this._persistence_checkFetched("savingsTransactionId");
        return this.savingsTransactionId;
    }

    public void _persistence_set_savingsTransactionId(Long l) {
        this._persistence_checkFetchedForSet("savingsTransactionId");
        this._persistence_propertyChange("savingsTransactionId", (Object)this.savingsTransactionId, (Object)l);
        this.savingsTransactionId = l;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)this.status, (Object)n);
        this.status = n;
    }
}

