/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.spm.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.spm.api.ScorecardApiResource;
import org.apache.fineract.spm.data.ScorecardData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/v1/self/surveys/scorecards")
@Component
@Tag(name="Self Score Card", description="")
public class SelfScorecardApiResource {
    private final PlatformSecurityContext context;
    private final ScorecardApiResource scorecardApiResource;
    private final AppuserClientMapperReadService appuserClientMapperReadService;

    @GET
    @Path(value="clients/{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public List<ScorecardData> findByClient(@PathParam(value="clientId") Long clientId) {
        this.validateAppuserClientsMapping(clientId);
        return this.scorecardApiResource.findByClient(clientId);
    }

    @POST
    @Path(value="{surveyId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public void createScorecard(@PathParam(value="surveyId") Long surveyId, ScorecardData scorecardData) {
        if (scorecardData.getClientId() != null) {
            this.validateAppuserClientsMapping(scorecardData.getClientId());
            this.scorecardApiResource.createScorecard(surveyId, scorecardData);
        }
    }

    private void validateAppuserClientsMapping(Long clientId) {
        AppUser user = this.context.authenticatedUser();
        boolean mappedClientId = this.appuserClientMapperReadService.isClientMappedToUser(clientId, (Long)user.getId());
        if (!mappedClientId) {
            throw new ClientNotFoundException(clientId);
        }
    }

    @Generated
    public SelfScorecardApiResource(PlatformSecurityContext context, ScorecardApiResource scorecardApiResource, AppuserClientMapperReadService appuserClientMapperReadService) {
        this.context = context;
        this.scorecardApiResource = scorecardApiResource;
        this.appuserClientMapperReadService = appuserClientMapperReadService;
    }
}

