/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.service;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.pockets.data.PocketAccountMappingData;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMapping;
import org.apache.fineract.portfolio.self.pockets.domain.PocketAccountMappingRepositoryWrapper;
import org.apache.fineract.portfolio.self.pockets.domain.PocketRepositoryWrapper;
import org.apache.fineract.portfolio.self.pockets.service.PocketAccountMappingReadPlatformService;
import org.springframework.jdbc.core.JdbcTemplate;

public class PocketAccountMappingReadPlatformServiceImpl
implements PocketAccountMappingReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final PocketRepositoryWrapper pocketRepositoryWrapper;
    private final PocketAccountMappingRepositoryWrapper pocketAccountMappingRepositoryWrapper;

    public PocketAccountMappingData retrieveAll() {
        Collection pocketAccountMappingList;
        Long pocketId = this.pocketRepositoryWrapper.findByAppUserId((Long)this.context.authenticatedUser().getId());
        if (pocketId != null && (pocketAccountMappingList = this.pocketAccountMappingRepositoryWrapper.findByPocketId(pocketId)) != null && !pocketAccountMappingList.isEmpty()) {
            ArrayList<PocketAccountMapping> loanAccounts = new ArrayList<PocketAccountMapping>();
            ArrayList<PocketAccountMapping> savingsAccounts = new ArrayList<PocketAccountMapping>();
            ArrayList<PocketAccountMapping> shareAccounts = new ArrayList<PocketAccountMapping>();
            for (PocketAccountMapping pocketMapping : pocketAccountMappingList) {
                if (pocketMapping.getAccountType().equals(EntityAccountType.LOAN.getValue())) {
                    loanAccounts.add(pocketMapping);
                    continue;
                }
                if (pocketMapping.getAccountType().equals(EntityAccountType.SAVINGS.getValue())) {
                    savingsAccounts.add(pocketMapping);
                    continue;
                }
                shareAccounts.add(pocketMapping);
            }
            return PocketAccountMappingData.instance(loanAccounts, savingsAccounts, shareAccounts);
        }
        return null;
    }

    public boolean validatePocketAndAccountMapping(Long pocketId, Long accountId, Integer accountType) {
        String sql = "select count(id) from m_pocket_accounts_mapping mapping where pocket_id = ? and account_id = ? and account_type = ?";
        int count = (Integer)this.jdbcTemplate.queryForObject("select count(id) from m_pocket_accounts_mapping mapping where pocket_id = ? and account_id = ? and account_type = ?", Integer.class, new Object[]{pocketId, accountId, accountType});
        return count > 0;
    }

    @Generated
    public PocketAccountMappingReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, PocketRepositoryWrapper pocketRepositoryWrapper, PocketAccountMappingRepositoryWrapper pocketAccountMappingRepositoryWrapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.pocketRepositoryWrapper = pocketRepositoryWrapper;
        this.pocketAccountMappingRepositoryWrapper = pocketAccountMappingRepositoryWrapper;
    }
}

