/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.documentmanagement.api.ImagesApiResource;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.api.ClientChargesApiResource;
import org.apache.fineract.portfolio.client.api.ClientTransactionsApiResource;
import org.apache.fineract.portfolio.client.api.ClientsApiResource;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.self.client.api.SelfClientsApiResourceSwagger;
import org.apache.fineract.portfolio.self.client.data.SelfClientDataValidator;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/clients")
@Component
@Tag(name="Self Client", description="")
public class SelfClientsApiResource {
    private final PlatformSecurityContext context;
    private final ClientsApiResource clientApiResource;
    private final ImagesApiResource imagesApiResource;
    private final ClientChargesApiResource clientChargesApiResource;
    private final ClientTransactionsApiResource clientTransactionsApiResource;
    private final AppuserClientMapperReadService appUserClientMapperReadService;
    private final SelfClientDataValidator dataValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Clients associated to the user", description="The list capability of clients can support pagination and sorting.\n\nExample Requests:\n\nself/clients\n\nself/clients?fields=displayName,officeName\n\nself/clients?offset=10&limit=50\n\nself/clients?orderBy=displayName&sortOrder=DESC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="displayName") @Parameter(description="displayName") String displayName, @QueryParam(value="firstName") @Parameter(description="firstName") String firstname, @QueryParam(value="lastName") @Parameter(description="lastName") String lastname, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="status") @Parameter(description="status") String status, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        Long officeId = null;
        String externalId = null;
        String hierarchy = null;
        Boolean orphansOnly = null;
        return this.clientApiResource.retrieveAll(uriInfo, officeId, externalId, displayName, firstname, lastname, status, hierarchy, offset, limit, orderBy, sortOrder, orphansOnly, true);
    }

    @GET
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client", description="Retrieves a Client\n\nExample Requests:\n\nself/clients/1\n\nself/clients/1?fields=id,displayName,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdResponse.class))})})
    public String retrieveOne(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.dataValidator.validateRetrieveOne(uriInfo);
        this.validateAppuserClientsMapping(clientId);
        boolean staffInSelectedOfficeOnly = false;
        return this.clientApiResource.retrieveOne(clientId, uriInfo, false);
    }

    @GET
    @Path(value="{clientId}/accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client accounts overview", description="An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application.\nIt is quite reasonable to add resources like this to simplify User Interface development.\n\nExample Requests:\n\nself/clients/1/accounts\n\n\nself/clients/1/accounts?fields=loanAccounts,savingsAccounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdAccountsResponse.class))})})
    public String retrieveAssociatedAccounts(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.validateAppuserClientsMapping(clientId);
        return this.clientApiResource.retrieveAssociatedAccounts(clientId, uriInfo);
    }

    @GET
    @Path(value="{clientId}/images")
    @Consumes(value={"text/plain", "text/html", "application/json"})
    @Produces(value={"text/plain"})
    @Operation(summary="Retrieve Client Image", description="Optional arguments are identical to those of Get Image associated with an Entity (Binary file)\n\nExample Requests:\n\nself/clients/1/images")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response retrieveImage(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="maxWidth") @Parameter(example="maxWidth") Integer maxWidth, @QueryParam(value="maxHeight") @Parameter(example="maxHeight") Integer maxHeight, @QueryParam(value="output") @Parameter(example="output") String output) {
        this.validateAppuserClientsMapping(clientId);
        return this.imagesApiResource.retrieveImage("clients", clientId, maxWidth, maxHeight, output, "text/plain");
    }

    @GET
    @Path(value="{clientId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Client Charges", description="The list capability of client charges supports pagination.\n\nExample Requests:\n\nself/clients/1/charges\n\nself/clients/1/charges?offset=0&limit=5")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdChargesResponse.class))})})
    public String retrieveAllClientCharges(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @QueryParam(value="pendingPayment") @Parameter(description="pendingPayment") Boolean pendingPayment, @Context UriInfo uriInfo, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="offset") @Parameter(description="offset") Integer offset) {
        this.validateAppuserClientsMapping(clientId);
        return this.clientChargesApiResource.retrieveAllClientCharges(clientId, chargeStatus, pendingPayment, uriInfo, limit, offset);
    }

    @GET
    @Path(value="{clientId}/charges/{chargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Charge", description="Retrieves a Client Charge\n\nExample Requests:\n\nself/clients/1/charges/1\n\n\nself/clients/1/charges/1?fields=name,id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdChargesChargeIdResponse.class))})})
    public String retrieveClientCharge(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="chargeId") @Parameter(description="chargeId") Long chargeId, @Context UriInfo uriInfo) {
        this.dataValidator.validateClientCharges(uriInfo);
        this.validateAppuserClientsMapping(clientId);
        return this.clientChargesApiResource.retrieveClientCharge(clientId, chargeId, uriInfo);
    }

    @GET
    @Path(value="{clientId}/transactions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Client Transactions", description="The list capability of client transaction can support pagination.\n\nExample Requests:\n\nself/clients/189/transactions\n\nself/clients/189/transactions?offset=10&limit=50")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdTransactionsResponse.class))})})
    public String retrieveAllClientTransactions(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit) {
        this.validateAppuserClientsMapping(clientId);
        return this.clientTransactionsApiResource.retrieveAllClientTransactions(clientId, uriInfo, offset, limit);
    }

    @GET
    @Path(value="{clientId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Transaction", description="Retrieves a Client TransactionExample Requests:\n\nself/clients/1/transactions/1\n\n\nself/clients/1/transactions/1?fields=id,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfClientsApiResourceSwagger.GetSelfClientsClientIdTransactionsTransactionIdResponse.class))})})
    public String retrieveClientTransaction(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.validateAppuserClientsMapping(clientId);
        return this.clientTransactionsApiResource.retrieveClientTransaction(clientId, transactionId, uriInfo);
    }

    private void validateAppuserClientsMapping(Long clientId) {
        AppUser user = this.context.authenticatedUser();
        boolean mappedClientId = this.appUserClientMapperReadService.isClientMappedToUser(clientId, (Long)user.getId());
        if (!mappedClientId) {
            throw new ClientNotFoundException(clientId);
        }
    }

    @POST
    @Path(value="{clientId}/images")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @RequestBody(description="Add new client image", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String addNewClientImage(@PathParam(value="clientId") Long clientId, @HeaderParam(value="Content-Length") Long fileSize, @FormDataParam(value="file") InputStream inputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetails, @FormDataParam(value="file") FormDataBodyPart bodyPart) {
        this.validateAppuserClientsMapping(clientId);
        return this.imagesApiResource.addNewClientImage("clients", clientId, fileSize, inputStream, fileDetails, bodyPart);
    }

    @POST
    @Path(value="{clientId}/images")
    @Consumes(value={"text/plain", "text/html", "application/json"})
    @Produces(value={"application/json"})
    public String addNewClientImage(@PathParam(value="entity") String entityName, @PathParam(value="clientId") Long clientId, String jsonRequestBody) {
        this.validateAppuserClientsMapping(clientId);
        return this.imagesApiResource.addNewClientImage("clients", clientId, jsonRequestBody);
    }

    @DELETE
    @Path(value="{clientId}/images")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteClientImage(@PathParam(value="clientId") Long clientId) {
        this.validateAppuserClientsMapping(clientId);
        return this.imagesApiResource.deleteClientImage("clients", clientId);
    }

    @GET
    @Path(value="{clientId}/obligeedetails")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveObligeeDetails(@PathParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.validateAppuserClientsMapping(clientId);
        return this.clientApiResource.retrieveObligeeDetails(clientId, uriInfo);
    }

    @Generated
    public SelfClientsApiResource(PlatformSecurityContext context, ClientsApiResource clientApiResource, ImagesApiResource imagesApiResource, ClientChargesApiResource clientChargesApiResource, ClientTransactionsApiResource clientTransactionsApiResource, AppuserClientMapperReadService appUserClientMapperReadService, SelfClientDataValidator dataValidator) {
        this.context = context;
        this.clientApiResource = clientApiResource;
        this.imagesApiResource = imagesApiResource;
        this.clientChargesApiResource = clientChargesApiResource;
        this.clientTransactionsApiResource = clientTransactionsApiResource;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
        this.dataValidator = dataValidator;
    }
}

