/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.search.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.portfolio.search.SearchConstants;
import org.apache.fineract.portfolio.search.api.SearchApiResourceSwagger;
import org.apache.fineract.portfolio.search.data.AdHocQueryDataValidator;
import org.apache.fineract.portfolio.search.data.AdHocQuerySearchConditions;
import org.apache.fineract.portfolio.search.data.AdHocSearchQueryData;
import org.apache.fineract.portfolio.search.data.SearchConditions;
import org.apache.fineract.portfolio.search.service.SearchReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/search")
@Component
@Tag(name="Search API", description="Search API allows to search scoped resources clients, loans and groups on specified fields.")
public class SearchApiResource {
    private static final Set<String> SEARCH_RESPONSE_PARAMETERS = SearchConstants.SearchResponseParameters.getAllValues();
    private final SearchReadPlatformService searchReadPlatformService;
    private final ToApiJsonSerializer<Object> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AdHocQueryDataValidator fromApiJsonDeserializer;

    @GET
    @Path(value="/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrive Adhoc Search query template", description="Mandatory Fields\n\nsearch?query=000000001\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SearchApiResourceSwagger.GetSearchResponse.class))})})
    public String retrieveAdHocSearchQueryTemplate(@Context UriInfo uriInfo) {
        AdHocSearchQueryData templateData = this.searchReadPlatformService.retrieveAdHocQueryTemplate();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)templateData);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Search Resources", description="Example Requests:\n\nsearch?query=000000001\n\n\nsearch?query=Petra&resource=clients,groups\n\n\nsearch?query=Petra&resource=clients,groups&exactMatch=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SearchApiResourceSwagger.GetSearchResponse.class)))})})
    public String searchData(@Context UriInfo uriInfo, @QueryParam(value="query") @Parameter(description="query") String query, @QueryParam(value="resource") @Parameter(description="resource") String resource, @DefaultValue(value="false") @QueryParam(value="exactMatch") @Parameter(description="exactMatch") Boolean exactMatch) {
        SearchConditions searchConditions = new SearchConditions(query, resource, exactMatch);
        Collection searchResults = this.searchReadPlatformService.retriveMatchingData(searchConditions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)searchResults, SEARCH_RESPONSE_PARAMETERS);
    }

    @POST
    @Path(value="/advance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adhoc query search", description="AdHocQuery search has more search options, it is a POST request, it uses request body to send search parameters\n\n\nMandatory fields:entities\n\nOptional fields:loanStatus, loanProducts, offices, loanDateOption, loanFromDate, loanToDate, \nincludeOutStandingAmountPercentage, outStandingAmountPercentageCondition, \nminOutStandingAmountPercentage and maxOutStandingAmountPercentage OR outStandingAmountPercentage, \nincludeOutstandingAmount, outstandingAmountCondition, \nminOutstandingAmount and maxOutstandingAmount OR outstandingAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SearchApiResourceSwagger.PostAdhocQuerySearchRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SearchApiResourceSwagger.PostAdhocQuerySearchResponse.class)))})})
    public String advancedSearch(@Context UriInfo uriInfo, String json) {
        AdHocQuerySearchConditions searchConditions = this.fromApiJsonDeserializer.retrieveSearchConditions(json);
        Collection searchResults = this.searchReadPlatformService.retrieveAdHocQueryMatchingData(searchConditions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)searchResults);
    }

    @Generated
    public SearchApiResource(SearchReadPlatformService searchReadPlatformService, ToApiJsonSerializer<Object> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, AdHocQueryDataValidator fromApiJsonDeserializer) {
        this.searchReadPlatformService = searchReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }
}

