/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.charge.util.ConvertChargeDataToSpecificChargeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformServiceImpl;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class SavingsAccountReadPlatformServiceImpl
implements SavingsAccountReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final ClientReadPlatformService clientReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final SavingsDropdownReadPlatformService dropdownReadPlatformService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final SavingsAccountTransactionTemplateMapper transactionTemplateMapper;
    private final SavingsAccountTransactionsMapper transactionsMapper;
    private final SavingsAccountTransactionsForBatchMapper savingsAccountTransactionsForBatchMapper;
    private final SavingAccountMapper savingAccountMapper;
    private final SavingAccountMapperForInterestPosting savingAccountMapperForInterestPosting;
    private final PaginationHelper paginationHelper;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final ColumnValidator columnValidator;
    private final SavingsAccountAssembler savingAccountAssembler;
    private final SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper;

    public SavingsAccountReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, GroupReadPlatformService groupReadPlatformService, SavingsProductReadPlatformService savingProductReadPlatformService, StaffReadPlatformService staffReadPlatformService, SavingsDropdownReadPlatformService dropdownReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, ColumnValidator columnValidator, SavingsAccountAssembler savingAccountAssembler, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator, SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.savingsProductReadPlatformService = savingProductReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.sqlGenerator = sqlGenerator;
        this.savingsAccountRepositoryWrapper = savingsAccountRepositoryWrapper;
        this.transactionTemplateMapper = new SavingsAccountTransactionTemplateMapper();
        this.transactionsMapper = new SavingsAccountTransactionsMapper();
        this.savingsAccountTransactionsForBatchMapper = new SavingsAccountTransactionsForBatchMapper();
        this.savingAccountMapper = new SavingAccountMapper();
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
        this.savingAccountMapperForInterestPosting = new SavingAccountMapperForInterestPosting();
        this.savingAccountAssembler = savingAccountAssembler;
    }

    public Collection<SavingsAccountData> retrieveAllForLookup(Long clientId) {
        StringBuilder sqlBuilder = new StringBuilder("select " + this.savingAccountMapper.schema());
        sqlBuilder.append(" where sa.client_id = ? and sa.status_enum = 300 ");
        Object[] queryParameters = new Object[]{clientId};
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)this.savingAccountMapper, queryParameters);
    }

    public Collection<SavingsAccountData> retrieveActiveForLookup(Long clientId, DepositAccountType depositAccountType) {
        StringBuilder sqlBuilder = new StringBuilder("select " + this.savingAccountMapper.schema());
        sqlBuilder.append(" where sa.client_id = ? and sa.status_enum = 300 and sa.deposit_type_enum = ? ");
        Object[] queryParameters = new Object[]{clientId, depositAccountType.getValue()};
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)this.savingAccountMapper, queryParameters);
    }

    public Collection<SavingsAccountData> retrieveActiveForLookup(Long clientId, DepositAccountType depositAccountType, String currencyCode) {
        StringBuilder sqlBuilder = new StringBuilder("select " + this.savingAccountMapper.schema());
        sqlBuilder.append(" where sa.client_id = ? and sa.status_enum = 300 and sa.deposit_type_enum = ? and sa.currency_code = ? ");
        Object[] queryParameters = new Object[]{clientId, depositAccountType.getValue(), currencyCode};
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)this.savingAccountMapper, queryParameters);
    }

    public Page<SavingsAccountData> retrieveAll(SearchParameters searchParameters) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.savingAccountMapper.schema());
        sqlBuilder.append(" join m_office o on o.id = c.office_id");
        sqlBuilder.append(" where o.hierarchy like ?");
        Object[] objectArray = new Object[2];
        objectArray[0] = hierarchySearchString;
        int arrayPos = 1;
        if (searchParameters != null) {
            if (StringUtils.isNotBlank((CharSequence)searchParameters.getStatus())) {
                sqlBuilder.append(" and sa.status_enum = ?");
                objectArray[arrayPos] = Integer.parseInt(searchParameters.getStatus());
                ++arrayPos;
            }
            if (StringUtils.isNotBlank((CharSequence)searchParameters.getExternalId())) {
                sqlBuilder.append(" and sa.external_id = ?");
                objectArray[arrayPos] = searchParameters.getExternalId();
                ++arrayPos;
            }
            if (searchParameters.getOfficeId() != null) {
                sqlBuilder.append("and c.office_id =?");
                objectArray[arrayPos] = searchParameters.getOfficeId();
                ++arrayPos;
            }
            if (searchParameters.hasOrderBy()) {
                sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
                if (searchParameters.hasSortOrder()) {
                    sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                    this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
                }
            }
            if (searchParameters.hasLimit()) {
                sqlBuilder.append(" ");
                if (searchParameters.hasOffset()) {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
                } else {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
                }
            }
        }
        Object[] finalObjectArray = Arrays.copyOf(objectArray, arrayPos);
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.savingAccountMapper);
    }

    public SavingsAccountData retrieveOne(Long accountId) {
        try {
            String sql = "select " + this.savingAccountMapper.schema() + " where sa.id = ?";
            return (SavingsAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.savingAccountMapper, new Object[]{accountId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsAccountNotFoundException(accountId, e);
        }
    }

    public List<SavingsAccountTransactionData> retrieveAllTransactionData(List<String> refNo) throws DataAccessException {
        String inSql = String.join((CharSequence)",", Collections.nCopies(refNo.size(), "?"));
        String sql = "select " + this.savingsAccountTransactionsForBatchMapper.schema() + " where tr.ref_no in (%s)";
        Object[] params = new Object[refNo.size()];
        int i = 0;
        for (String element : refNo) {
            params[i] = element;
            ++i;
        }
        return this.jdbcTemplate.query(String.format(sql, inSql), (RowMapper)this.savingsAccountTransactionsForBatchMapper, params);
    }

    public List<SavingsAccountData> retrieveAllSavingsDataForInterestPosting(boolean backdatedTxnsAllowedTill, int pageSize, Integer status, Long maxSavingsId) {
        LocalDate yesterday = DateUtils.getBusinessLocalDate().minusDays(1L);
        String sql = "select " + this.savingAccountMapperForInterestPosting.schema() + "join (select a.id from m_savings_account a where a.id > ? and a.status_enum = ? limit ?) b on b.id = sa.id ";
        if (backdatedTxnsAllowedTill) {
            sql = sql + "where (CASE WHEN sa.interest_posted_till_date is not null THEN tr.transaction_date >= sa.interest_posted_till_date ELSE tr.transaction_date >= sa.activatedon_date END) ";
        }
        sql = sql + " and (sa.interest_posted_till_date is null or sa.interest_posted_till_date <= ? ) ";
        sql = sql + " order by sa.id, tr.transaction_date, tr.created_on_utc, tr.created_date, tr.id";
        List savingsAccountDataList = (List)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.savingAccountMapperForInterestPosting, new Object[]{maxSavingsId, status, pageSize, yesterday});
        for (SavingsAccountData savingsAccountData : savingsAccountDataList) {
            this.savingAccountAssembler.assembleSavings(savingsAccountData);
        }
        return savingsAccountDataList;
    }

    public SavingsAccountData retrieveTemplate(Long clientId, Long groupId, Long productId, boolean staffInSelectedOfficeOnly) {
        AppUser loggedInUser = this.context.authenticatedUser();
        Long officeId = (Long)loggedInUser.getOffice().getId();
        ClientData client = null;
        if (clientId != null) {
            client = this.clientReadPlatformService.retrieveOne(clientId);
            officeId = client.getOfficeId();
        }
        GroupGeneralData group = null;
        if (groupId != null) {
            group = this.groupReadPlatformService.retrieveOne(groupId);
            officeId = group.getOfficeId();
        }
        Collection productOptions = this.savingsProductReadPlatformService.retrieveAllForLookup();
        SavingsAccountData template = null;
        if (productId != null) {
            SavingAccountTemplateMapper mapper = new SavingAccountTemplateMapper(client, group);
            String sql = "select " + mapper.schema() + " where sp.id = ?";
            template = (SavingsAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{productId});
            Collection interestCompoundingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
            Collection interestPostingPeriodTypeOptions = this.dropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
            Collection interestCalculationTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
            Collection interestCalculationDaysInYearTypeOptions = this.dropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
            Collection lockinPeriodFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
            Collection withdrawalFeeTypeOptions = this.dropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
            Collection transactions = null;
            Collection productCharges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
            Collection charges = this.fromChargesToSavingsCharges(productCharges);
            boolean feeChargesOnly = false;
            Collection chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
            ArrayList fieldOfficerOptions = null;
            if (officeId != null) {
                if (staffInSelectedOfficeOnly) {
                    Collection fieldOfficersInBranch = this.staffReadPlatformService.retrieveAllLoanOfficersInOfficeById(officeId);
                    if (!CollectionUtils.isEmpty((Collection)fieldOfficersInBranch)) {
                        fieldOfficerOptions = new ArrayList(fieldOfficersInBranch);
                    }
                } else {
                    boolean restrictToLoanOfficersOnly = true;
                    Collection loanOfficersInHierarchy = this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(officeId, true);
                    if (!CollectionUtils.isEmpty((Collection)loanOfficersInHierarchy)) {
                        fieldOfficerOptions = new ArrayList(loanOfficersInHierarchy);
                    }
                }
            }
            template = SavingsAccountData.withTemplateOptions((SavingsAccountData)template, (Collection)productOptions, fieldOfficerOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, transactions, (Collection)charges, (Collection)chargeOptions);
        } else {
            String clientName = null;
            if (client != null) {
                clientName = client.getDisplayName();
            }
            String groupName = null;
            if (group != null) {
                groupName = group.getName();
            }
            template = SavingsAccountData.withClientTemplate((Long)clientId, (String)clientName, (Long)groupId, (String)groupName);
            Collection fieldOfficerOptions = null;
            Collection interestCompoundingPeriodTypeOptions = null;
            Collection interestPostingPeriodTypeOptions = null;
            Collection interestCalculationTypeOptions = null;
            Collection interestCalculationDaysInYearTypeOptions = null;
            Collection lockinPeriodFrequencyTypeOptions = null;
            Collection withdrawalFeeTypeOptions = null;
            Collection transactions = null;
            Collection charges = null;
            boolean feeChargesOnly = false;
            Collection chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(false);
            template = SavingsAccountData.withTemplateOptions((SavingsAccountData)template, (Collection)productOptions, fieldOfficerOptions, interestCompoundingPeriodTypeOptions, interestPostingPeriodTypeOptions, interestCalculationTypeOptions, interestCalculationDaysInYearTypeOptions, lockinPeriodFrequencyTypeOptions, withdrawalFeeTypeOptions, transactions, charges, (Collection)chargeOptions);
        }
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.SAVINGS.getName(), productId);
        template.setDatatables(datatableTemplates);
        return template;
    }

    private Collection<SavingsAccountChargeData> fromChargesToSavingsCharges(Collection<ChargeData> productCharges) {
        ArrayList<SavingsAccountChargeData> savingsCharges = new ArrayList<SavingsAccountChargeData>();
        for (ChargeData chargeData : productCharges) {
            SavingsAccountChargeData savingsCharge = ConvertChargeDataToSpecificChargeData.toSavingsAccountChargeData((ChargeData)chargeData);
            savingsCharges.add(savingsCharge);
        }
        return savingsCharges;
    }

    public SavingsAccountTransactionData retrieveDepositTransactionTemplate(Long savingsId, DepositAccountType depositAccountType) {
        try {
            String sql = "select " + this.transactionTemplateMapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ?";
            return (SavingsAccountTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.transactionTemplateMapper, new Object[]{savingsId, depositAccountType.getValue()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsAccountNotFoundException(savingsId, e);
        }
    }

    public Collection<SavingsAccountTransactionData> retrieveAllTransactions(Long savingsId, DepositAccountType depositAccountType) {
        String sql = "select " + this.transactionsMapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ? order by tr.transaction_date DESC, tr.created_on_utc DESC, tr.created_date DESC, tr.id DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)this.transactionsMapper, new Object[]{savingsId, depositAccountType.getValue()});
    }

    public SavingsAccountTransactionData retrieveSavingsTransaction(Long savingsId, Long transactionId, DepositAccountType depositAccountType) {
        String sql = "select " + this.transactionsMapper.schema() + " where sa.id = ? and sa.deposit_type_enum = ? and tr.id= ?";
        return (SavingsAccountTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.transactionsMapper, new Object[]{savingsId, depositAccountType.getValue(), transactionId});
    }

    public Collection<SavingsAccountData> retrieveForLookup(Long clientId, Boolean overdraft) {
        SavingAccountMapperForLookup accountMapperForLookup = new SavingAccountMapperForLookup();
        StringBuilder sqlBuilder = new StringBuilder("select " + accountMapperForLookup.schema());
        sqlBuilder.append(" where sa.client_id = ? and sa.status_enum = 300");
        Object[] queryParameters = null;
        if (overdraft == null) {
            queryParameters = new Object[]{clientId};
        } else {
            sqlBuilder.append(" and sa.allow_overdraft = ?");
            queryParameters = new Object[]{clientId, overdraft};
        }
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)accountMapperForLookup, queryParameters);
    }

    public List<Long> retrieveSavingsIdsPendingInactive(LocalDate tenantLocalDate) {
        List ret = null;
        StringBuilder sql = new StringBuilder("select sa.id ");
        sql.append(" from m_savings_account as sa ");
        sql.append(" inner join m_savings_product as sp on (sa.product_id = sp.id and sp.is_dormancy_tracking_active = true) ");
        sql.append(" where sa.status_enum = 300 ");
        sql.append(" and sa.sub_status_enum = 0 ");
        String compareDate = "(select COALESCE(max(sat.transaction_date), sa.activatedon_date) from m_savings_account_transaction as sat where sat.is_reversed = false and sat.is_reversal = false and sat.transaction_type_enum in (1,2) and sat.savings_account_id = sa.id)";
        sql.append(" and ").append(this.sqlGenerator.dateDiff("?", compareDate)).append(" >= sp.days_to_inactive ");
        try {
            ret = this.jdbcTemplate.queryForList(sql.toString(), new Object[]{tenantLocalDate}, Long.class);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
        }
        catch (DataAccessException e) {
            throw e;
        }
        return ret;
    }

    public List<Long> retrieveSavingsIdsPendingDormant(LocalDate tenantLocalDate) {
        List ret = null;
        StringBuilder sql = new StringBuilder("select sa.id ");
        sql.append(" from m_savings_account as sa ");
        sql.append(" inner join m_savings_product as sp on (sa.product_id = sp.id and sp.is_dormancy_tracking_active = true) ");
        sql.append(" where sa.status_enum = 300 ");
        sql.append(" and sa.sub_status_enum = 100 ");
        sql.append(" and " + this.sqlGenerator.dateDiff("?", "(select COALESCE(max(sat.transaction_date),sa.activatedon_date) from m_savings_account_transaction as sat where sat.is_reversed = false and sat.is_reversal = false and sat.transaction_type_enum in (1,2) and sat.savings_account_id = sa.id)") + " ");
        sql.append(" >= sp.days_to_dormancy ");
        try {
            ret = this.jdbcTemplate.queryForList(sql.toString(), new Object[]{tenantLocalDate}, Long.class);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
        }
        catch (DataAccessException e) {
            throw e;
        }
        return ret;
    }

    public List<Long> retrieveSavingsIdsPendingEscheat(LocalDate tenantLocalDate) {
        List ret = null;
        StringBuilder sql = new StringBuilder("select sa.id ");
        sql.append(" from m_savings_account as sa ");
        sql.append(" inner join m_savings_product as sp on (sa.product_id = sp.id and sp.is_dormancy_tracking_active = true) ");
        sql.append(" where sa.status_enum = 300 ");
        sql.append(" and sa.sub_status_enum = 200 ");
        sql.append(" and " + this.sqlGenerator.dateDiff("?", "(select COALESCE(max(sat.transaction_date),sa.activatedon_date) from m_savings_account_transaction as sat where sat.is_reversed = false and sat.is_reversal = false and sat.transaction_type_enum in (1,2) and sat.savings_account_id = sa.id)") + " ");
        sql.append(" >= sp.days_to_escheat ");
        try {
            ret = this.jdbcTemplate.queryForList(sql.toString(), Long.class, new Object[]{tenantLocalDate});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
        }
        catch (DataAccessException e) {
            throw e;
        }
        return ret;
    }

    public boolean isAccountBelongsToClient(Long clientId, Long accountId, DepositAccountType depositAccountType, String currencyCode) {
        try {
            StringBuilder buff = new StringBuilder("select count(*) from m_savings_account sa ");
            buff.append(" where sa.id = ? and sa.client_id = ? and sa.deposit_type_enum = ? and sa.currency_code = ? and sa.status_enum = 300");
            return (Integer)this.jdbcTemplate.queryForObject(buff.toString(), Integer.class, new Object[]{accountId, clientId, depositAccountType.getValue(), currencyCode}) > 0;
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsAccountNotFoundException(accountId, e);
        }
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        try {
            String sql = "select s.account_no from m_savings_account s where s.id = ?";
            return (String)this.jdbcTemplate.queryForObject("select s.account_no from m_savings_account s where s.id = ?", String.class, new Object[]{accountId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsAccountNotFoundException(accountId, e);
        }
    }

    public List<Long> getAccountsIdsByStatusPaged(Integer status, int pageSize, Long maxSavingsIdInList) {
        String sql = " SELECT sa.id FROM m_savings_account sa " + " where sa.id > ? and sa.status_enum  = ? " + " order by sa.id limit ?";
        try {
            return this.jdbcTemplate.queryForList(sql, Long.class, new Object[]{maxSavingsIdInList, status, pageSize});
        }
        catch (EmptyResultDataAccessException e) {
            return new ArrayList<Long>();
        }
    }

    public Long retrieveAccountIdByExternalId(ExternalId externalId) {
        return this.savingsAccountRepositoryWrapper.findIdByExternalId(externalId);
    }
}

