/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositAccountData;
import org.apache.fineract.portfolio.savings.data.DepositAccountTransactionDataValidator;
import org.apache.fineract.portfolio.savings.data.FixedDepositAccountData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositAccountData;
import org.apache.fineract.portfolio.savings.domain.DepositAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.service.DepositAccountPreMatureCalculationPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.springframework.transaction.annotation.Transactional;

public class DepositAccountPreMatureCalculationPlatformServiceImpl
implements DepositAccountPreMatureCalculationPlatformService {
    private final FromJsonHelper fromJsonHelper;
    private final DepositAccountTransactionDataValidator depositAccountTransactionDataValidator;
    private final DepositAccountAssembler depositAccountAssembler;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;

    @Transactional
    public DepositAccountData calculatePreMatureAmount(Long accountId, JsonQuery query, DepositAccountType depositAccountType) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        this.depositAccountTransactionDataValidator.validatePreMatureAmountCalculation(query.json(), depositAccountType);
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(accountId, depositAccountType);
        FixedDepositAccountData accountData = null;
        List onAccountClosureOptions = SavingsEnumerations.depositAccountOnClosureType((DepositAccountOnClosureType[])new DepositAccountOnClosureType[]{DepositAccountOnClosureType.WITHDRAW_DEPOSIT, DepositAccountOnClosureType.TRANSFER_TO_SAVINGS});
        Collection paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        Collection savingsAccountDatas = this.savingsAccountReadPlatformService.retrieveActiveForLookup(account.clientId(), DepositAccountType.SAVINGS_DEPOSIT);
        JsonElement element = this.fromJsonHelper.parse(query.json());
        LocalDate preMaturityDate = this.fromJsonHelper.extractLocalDateNamed("closedOnDate", element);
        LocalDate interestCalculatedToDate = preMaturityDate.minusDays(1L);
        boolean isPreMatureClosure = true;
        if (depositAccountType.isFixedDeposit()) {
            FixedDepositAccount fd = (FixedDepositAccount)account;
            accountData = FixedDepositAccountData.preClosureDetails((Long)((Long)account.getId()), (BigDecimal)fd.calculatePreMatureAmount(interestCalculatedToDate, true, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth), (Collection)onAccountClosureOptions, (Collection)paymentTypeOptions, (Collection)savingsAccountDatas);
        } else if (depositAccountType.isRecurringDeposit()) {
            RecurringDepositAccount rd = (RecurringDepositAccount)account;
            accountData = RecurringDepositAccountData.preClosureDetails((Long)((Long)account.getId()), (BigDecimal)rd.calculatePreMatureAmount(interestCalculatedToDate, true, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth), (Collection)onAccountClosureOptions, (Collection)paymentTypeOptions, (Collection)savingsAccountDatas);
        }
        return accountData;
    }

    @Generated
    public DepositAccountPreMatureCalculationPlatformServiceImpl(FromJsonHelper fromJsonHelper, DepositAccountTransactionDataValidator depositAccountTransactionDataValidator, DepositAccountAssembler depositAccountAssembler, SavingsAccountReadPlatformService savingsAccountReadPlatformService, ConfigurationDomainService configurationDomainService, PaymentTypeReadPlatformService paymentTypeReadPlatformService) {
        this.fromJsonHelper = fromJsonHelper;
        this.depositAccountTransactionDataValidator = depositAccountTransactionDataValidator;
        this.depositAccountAssembler = depositAccountAssembler;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.configurationDomainService = configurationDomainService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
    }
}

