/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.postinterestforsavings;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsSchedularInterestPosterTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class PostInterestForSavingTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostInterestForSavingTasklet.class);
    private static final int QUEUE_SIZE = 1;
    private final SavingsAccountReadPlatformService savingAccountReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final Queue<List<SavingsAccountData>> queue = new ArrayDeque();
    private final ApplicationContext applicationContext;
    @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor")
    private final ThreadPoolTaskExecutor taskExecutor;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        int threadPoolSize = Integer.parseInt((String)chunkContext.getStepContext().getJobParameters().get("thread-pool-size"));
        this.taskExecutor.setCorePoolSize(threadPoolSize);
        this.taskExecutor.setMaxPoolSize(threadPoolSize);
        int batchSize = Integer.parseInt((String)chunkContext.getStepContext().getJobParameters().get("batch-size"));
        int pageSize = batchSize * threadPoolSize;
        Long maxSavingsIdInList = 0L;
        boolean backdatedTxnsAllowedTill = this.configurationDomainService.retrievePivotDateConfig();
        long start = System.currentTimeMillis();
        log.debug("Reading Savings Account Data!");
        List savingsAccounts = this.savingAccountReadPlatformService.retrieveAllSavingsDataForInterestPosting(backdatedTxnsAllowedTill, pageSize, SavingsAccountStatusType.ACTIVE.getValue(), maxSavingsIdInList);
        if (savingsAccounts != null && savingsAccounts.size() > 0) {
            savingsAccounts = Collections.synchronizedList(savingsAccounts);
            long finish = System.currentTimeMillis();
            log.debug("Done fetching Data within {} milliseconds", (Object)(finish - start));
            this.queue.add(savingsAccounts);
            if (!CollectionUtils.isEmpty((Collection)this.queue)) {
                do {
                    int totalFilteredRecords = savingsAccounts.size();
                    log.debug("Starting Interest posting - total records - {}", (Object)totalFilteredRecords);
                    List queueElement = (List)this.queue.element();
                    maxSavingsIdInList = ((SavingsAccountData)queueElement.get(queueElement.size() - 1)).getId();
                    this.postInterest((List)this.queue.remove(), threadPoolSize, backdatedTxnsAllowedTill, pageSize, maxSavingsIdInList);
                } while (!CollectionUtils.isEmpty((Collection)this.queue));
            }
        }
        return RepeatStatus.FINISHED;
    }

    private void postInterest(List<SavingsAccountData> savingsAccounts, int threadPoolSize, boolean backdatedTxnsAllowedTill, int pageSize, Long maxSavingsIdInList) {
        int toIndex;
        ArrayList<Callable<Void>> posters = new ArrayList<Callable<Void>>();
        int fromIndex = 0;
        int size = savingsAccounts.size();
        int batchSize = (int)Math.ceil((double)size / (double)threadPoolSize);
        if (batchSize == 0) {
            return;
        }
        int n = toIndex = batchSize > size - 1 ? size : batchSize;
        while (toIndex < size && savingsAccounts.get(toIndex - 1).getId().equals(savingsAccounts.get(toIndex).getId())) {
            ++toIndex;
        }
        boolean lastBatch = false;
        int loopCount = size / batchSize + 1;
        FineractContext context = ThreadLocalContextUtil.getContext();
        Callable<Void> fetchData = () -> {
            ThreadLocalContextUtil.init((FineractContext)context);
            Long maxId = maxSavingsIdInList;
            if (!this.queue.isEmpty()) {
                maxId = Math.max(maxSavingsIdInList, ((SavingsAccountData)((List)this.queue.element()).get(((List)this.queue.element()).size() - 1)).getId());
            }
            while (this.queue.size() <= 1) {
                log.debug("Fetching while threads are running!");
                List savingsAccountDataList = Collections.synchronizedList(this.savingAccountReadPlatformService.retrieveAllSavingsDataForInterestPosting(backdatedTxnsAllowedTill, pageSize, SavingsAccountStatusType.ACTIVE.getValue(), maxId));
                if (savingsAccountDataList.isEmpty()) break;
                maxId = ((SavingsAccountData)savingsAccountDataList.get(savingsAccountDataList.size() - 1)).getId();
                this.queue.add(savingsAccountDataList);
            }
            return null;
        };
        posters.add(fetchData);
        for (long i = 0L; i < (long)loopCount; ++i) {
            List subList = this.safeSubList(savingsAccounts, fromIndex, toIndex);
            SavingsSchedularInterestPosterTask savingsSchedularInterestPosterTask = (SavingsSchedularInterestPosterTask)this.applicationContext.getBean(SavingsSchedularInterestPosterTask.class);
            savingsSchedularInterestPosterTask.setSavingAccounts((Collection)subList);
            savingsSchedularInterestPosterTask.setBackdatedTxnsAllowedTill(backdatedTxnsAllowedTill);
            savingsSchedularInterestPosterTask.setContext(ThreadLocalContextUtil.getContext());
            posters.add((Callable<Void>)savingsSchedularInterestPosterTask);
            if (lastBatch) break;
            if (toIndex + batchSize > size - 1) {
                lastBatch = true;
            }
            fromIndex += toIndex - fromIndex;
            int n2 = toIndex = toIndex + batchSize > size - 1 ? size : toIndex + batchSize;
            while (toIndex < size && ((SavingsAccountData)savingsAccounts.get(toIndex - 1)).getId().equals(((SavingsAccountData)savingsAccounts.get(toIndex)).getId())) {
                ++toIndex;
            }
        }
        ArrayList responses = new ArrayList();
        posters.forEach(poster -> responses.add(this.taskExecutor.submit(poster)));
        Long maxId = maxSavingsIdInList;
        if (!this.queue.isEmpty()) {
            maxId = Math.max(maxSavingsIdInList, ((SavingsAccountData)((List)this.queue.element()).get(((List)this.queue.element()).size() - 1)).getId());
        }
        while (this.queue.size() <= 1) {
            log.debug("Fetching while threads are running!..:: this is not supposed to run........");
            savingsAccounts = Collections.synchronizedList(this.savingAccountReadPlatformService.retrieveAllSavingsDataForInterestPosting(backdatedTxnsAllowedTill, pageSize, SavingsAccountStatusType.ACTIVE.getValue(), maxId));
            if (savingsAccounts.isEmpty()) break;
            maxId = ((SavingsAccountData)savingsAccounts.get(savingsAccounts.size() - 1)).getId();
            log.debug("Add to the Queue");
            this.queue.add(savingsAccounts);
        }
        this.checkCompletion(responses);
        log.debug("Queue size {}", (Object)this.queue.size());
    }

    private <T> List<T> safeSubList(List<T> list, int fromIndex, int toIndex) {
        int size = list.size();
        if (fromIndex >= size || toIndex <= 0 || fromIndex >= toIndex) {
            return Collections.emptyList();
        }
        fromIndex = Math.max(0, fromIndex);
        toIndex = Math.min(size, toIndex);
        return list.subList(fromIndex, toIndex);
    }

    private void checkCompletion(List<Future<Void>> responses) {
        try {
            boolean allThreadsExecuted;
            for (Future<Void> f : responses) {
                f.get();
            }
            int noOfThreadsExecuted = 0;
            for (Future<Void> future : responses) {
                if (!future.isDone()) continue;
                ++noOfThreadsExecuted;
            }
            boolean bl = allThreadsExecuted = noOfThreadsExecuted == responses.size();
            if (!allThreadsExecuted) {
                log.error("All threads could not execute.");
            }
        }
        catch (InterruptedException e1) {
            log.error("Interrupted while interest posting entries", (Throwable)e1);
        }
        catch (ExecutionException e2) {
            log.error("Execution exception while interest posting entries", (Throwable)e2);
        }
    }

    @Generated
    public PostInterestForSavingTasklet(SavingsAccountReadPlatformService savingAccountReadPlatformService, ConfigurationDomainService configurationDomainService, ApplicationContext applicationContext, @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        this.savingAccountReadPlatformService = savingAccountReadPlatformService;
        this.configurationDomainService = configurationDomainService;
        this.applicationContext = applicationContext;
        this.taskExecutor = taskExecutor;
    }
}

