/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.generateadhocclientschhedule;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import lombok.Generated;
import org.apache.fineract.adhocquery.domain.ReportRunFrequency;
import org.apache.fineract.adhocquery.service.AdHocReadPlatformService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.savings.jobs.generateadhocclientschhedule.GenerateAdhocClientScheduleTasklet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class GenerateAdhocClientScheduleTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateAdhocClientScheduleTasklet.class);
    private final AdHocReadPlatformService adHocReadPlatformService;
    private final JdbcTemplate jdbcTemplate;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection adhocs = this.adHocReadPlatformService.retrieveAllActiveAdHocQuery();
        if (adhocs.size() > 0) {
            adhocs.forEach(adhoc -> {
                boolean run = true;
                LocalDate next = null;
                if (adhoc.getReportRunFrequency() != null && adhoc.getLastRun() != null) {
                    LocalDate start = adhoc.getLastRun().toLocalDate();
                    LocalDate end = ZonedDateTime.now(DateUtils.getDateTimeZoneOfTenant()).toLocalDate();
                    switch (1.$SwitchMap$org$apache$fineract$adhocquery$domain$ReportRunFrequency[ReportRunFrequency.fromId((long)adhoc.getReportRunFrequency()).ordinal()]) {
                        case 1: {
                            next = start.plusDays(1L);
                            run = DateUtils.getExactDifferenceInDays((LocalDate)start, (LocalDate)end) >= 1;
                            break;
                        }
                        case 2: {
                            next = start.plusDays(7L);
                            run = DateUtils.getExactDifferenceInDays((LocalDate)start, (LocalDate)end) >= 7;
                            break;
                        }
                        case 3: {
                            next = start.plusMonths(1L);
                            run = DateUtils.getExactDifference((LocalDate)start, (LocalDate)end, (ChronoUnit)ChronoUnit.MONTHS) >= 1;
                            break;
                        }
                        case 4: {
                            next = start.plusYears(1L);
                            run = DateUtils.getExactDifference((LocalDate)start, (LocalDate)end, (ChronoUnit)ChronoUnit.YEARS) >= 1;
                            break;
                        }
                        case 5: {
                            next = start.plusDays(adhoc.getReportRunEvery());
                            boolean bl = run = (long)DateUtils.getExactDifferenceInDays((LocalDate)start, (LocalDate)end) >= adhoc.getReportRunEvery();
                        }
                    }
                }
                if (run) {
                    StringBuilder insertSqlBuilder = new StringBuilder(900);
                    insertSqlBuilder.append("INSERT INTO ").append(adhoc.getTableName()).append("(").append(adhoc.getTableFields()).append(") ").append(adhoc.getQuery());
                    if (insertSqlBuilder.length() > 0) {
                        int result = this.jdbcTemplate.update(insertSqlBuilder.toString());
                        log.debug("{}: Records affected by generateClientSchedule: {}", (Object)ThreadLocalContextUtil.getTenant().getName(), (Object)result);
                        this.jdbcTemplate.update("UPDATE m_adhoc SET last_run=? WHERE id=?", new Object[]{new Date(), adhoc.getId()});
                    }
                } else {
                    log.debug("{}: Skipping execution of {}, scheduled for execution on {}", new Object[]{ThreadLocalContextUtil.getTenant().getName(), adhoc.getName(), next});
                }
            });
        } else {
            log.debug("{}: Nothing to update by generateClientSchedule", (Object)ThreadLocalContextUtil.getTenant().getName());
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public GenerateAdhocClientScheduleTasklet(AdHocReadPlatformService adHocReadPlatformService, JdbcTemplate jdbcTemplate) {
        this.adHocReadPlatformService = adHocReadPlatformService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

