/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DepositAccountTransactionDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> DEPOSIT_ACCOUNT_TRANSACTION_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "transactionDate", "transactionAmount", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
    private static final Set<String> DEPOSIT_ACCOUNT_RECOMMENDED_DEPOSIT_AMOUNT_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "mandatoryRecommendedDepositAmount", "effectiveDate"));
    private static final Set<String> DEPOSIT_ACCOUNT_CLOSE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closedOnDate", "note", "onAccountClosureId", "paymentTypeId", "accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber", "transferDescription", "toSavingsAccountId"));
    private static final Set<String> DEPOSIT_ACCOUNT_PRE_MATURE_CALCULATION_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closedOnDate"));

    @Autowired
    public DepositAccountTransactionDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validate(JsonCommand command, DepositAccountType depositAccountType) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DEPOSIT_ACCOUNT_TRANSACTION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(depositAccountType.resourceName());
        JsonElement element = command.parsedJson();
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transactionAmount", element);
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).notNull().positiveAmount();
        Integer paymentTypeId = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("paymentTypeId", element);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).ignoreIfNull().integerGreaterThanZero();
        HashSet<String> paymentDetailParameters = new HashSet<String>(Arrays.asList("accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
        for (String paymentDetailParameterName : paymentDetailParameters) {
            String paymentDetailParameterValue = this.fromApiJsonHelper.extractStringNamed(paymentDetailParameterName, element);
            baseDataValidator.reset().parameter(paymentDetailParameterName).value((Object)paymentDetailParameterValue).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateDepositAmountUpdate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DEPOSIT_ACCOUNT_RECOMMENDED_DEPOSIT_AMOUNT_UPDATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        JsonElement element = command.parsedJson();
        LocalDate effectiveDate = this.fromApiJsonHelper.extractLocalDateNamed("effectiveDate", element);
        baseDataValidator.reset().parameter("effectiveDate").value((Object)effectiveDate).notNull();
        BigDecimal mandatoryRecommendedDepositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("mandatoryRecommendedDepositAmount", element);
        baseDataValidator.reset().parameter("mandatoryRecommendedDepositAmount").value((Object)mandatoryRecommendedDepositAmount).notNull().positiveAmount();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateActivation(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SavingsAccountConstant.SAVINGS_ACCOUNT_ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        JsonElement element = command.parsedJson();
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed("activatedOnDate", element);
        baseDataValidator.reset().parameter("activatedOnDate").value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validatePreMatureAmountCalculation(String json, DepositAccountType depositAccountType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DEPOSIT_ACCOUNT_PRE_MATURE_CALCULATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(depositAccountType.resourceName());
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate closeDate = this.fromApiJsonHelper.extractLocalDateNamed("closedOnDate", element);
        baseDataValidator.reset().parameter("closedOnDate").value((Object)closeDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateClosing(JsonCommand command, DepositAccountType depositAccountType, boolean isPreMatureClose) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DEPOSIT_ACCOUNT_CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(depositAccountType.resourceName());
        JsonElement element = command.parsedJson();
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed("closedOnDate", element);
        baseDataValidator.reset().parameter("closedOnDate").value((Object)activationDate).notNull();
        Integer onAccountClosureId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("onAccountClosureId", element);
        baseDataValidator.reset().parameter("onAccountClosureId").value((Object)onAccountClosureId).notBlank().isOneOfTheseValues(DepositAccountOnClosureType.integerValues());
        if (onAccountClosureId != null) {
            DepositAccountOnClosureType accountOnClosureType = DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId);
            if (accountOnClosureType.isTransferToSavings()) {
                Long toSavingsAccountId = this.fromApiJsonHelper.extractLongNamed("toSavingsAccountId", element);
                baseDataValidator.reset().parameter("toSavingsAccountId").value((Object)toSavingsAccountId).cantBeBlankWhenParameterProvidedIs("onAccountClosureId", (Object)DepositAccountOnClosureType.fromInt((Integer)onAccountClosureId).getCode());
            } else if (accountOnClosureType.isReinvest() && isPreMatureClose) {
                baseDataValidator.reset().parameter("onAccountClosureId").value((Object)onAccountClosureId).failWithCode("reinvest.not.allowed", new Object[]{"Re-Invest is not supported for account pre mature close"});
            }
        }
        Integer paymentTypeId = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("paymentTypeId", element);
        baseDataValidator.reset().parameter("paymentTypeId").value((Object)paymentTypeId).ignoreIfNull().integerGreaterThanZero();
        HashSet<String> paymentDetailParameters = new HashSet<String>(Arrays.asList("accountNumber", "checkNumber", "routingCode", "receiptNumber", "bankNumber"));
        for (String paymentDetailParameterName : paymentDetailParameters) {
            String paymentDetailParameterValue = this.fromApiJsonHelper.extractStringNamed(paymentDetailParameterName, element);
            baseDataValidator.reset().parameter(paymentDetailParameterName).value((Object)paymentDetailParameterValue).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

