/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.api.SavingsAccountsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/savingsaccounts")
@Component
@Tag(name="Savings Account", description="Savings accounts are instances of a particular savings product created for an individual or group. An application process around the creation of accounts is also supported.")
public class SavingsAccountsApiResource {
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SavingsAccountData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Savings Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\nsavingsaccounts/template?clientId=1\n\n\nsavingsaccounts/template?clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.GetSavingsAccountsTemplateResponse.class))})})
    public String template(@QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="groupId") @Parameter(description="groupId") Long groupId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        SavingsAccountData savingsAccount = this.savingsAccountReadPlatformService.retrieveTemplate(clientId, groupId, productId, staffInSelectedOfficeOnly);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccount, SavingsApiSetConstants.SAVINGS_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List savings applications/accounts", description="Lists savings applications/accounts\n\nExample Requests:\n\nsavingsaccounts\n\n\nsavingsaccounts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.GetSavingsAccountsResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).externalId(externalId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page products = this.savingsAccountReadPlatformService.retrieveAll(searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, products, SavingsApiSetConstants.SAVINGS_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new savings application", description="Submits new savings application\n\nMandatory Fields: clientId or groupId, productId, submittedOnDate\n\nOptional Fields: accountNo, externalId, fieldOfficerId\n\nInherited from Product (if not provided): nominalAnnualInterestRate, interestCompoundingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minRequiredOpeningBalance, lockinPeriodFrequency, lockinPeriodFrequencyType, withdrawalFeeForTransfers, allowOverdraft, overdraftLimit, withHoldTax\n\nAdditional Mandatory Field if Entity-Datatable Check is enabled for the entity of type Savings: datatables")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsResponse.class))})})
    public String submitApplication(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createSavingsAccount().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="/gsim")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String submitGSIMApplication(String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createGSIMAccount().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a savings application/account", description="Retrieves a savings application/account\n\nExample Requests :\n\nsavingsaccounts/1\n\n\nsavingsaccounts/1?associations=all")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.GetSavingsAccountsAccountIdResponse.class))})})
    public String retrieveOne(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        return this.retrieveSavingAccount(accountId, null, staffInSelectedOfficeOnly, chargeStatus, uriInfo);
    }

    @GET
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a savings application/account by external id", description="Retrieves a savings application/account by external id\n\nExample Requests :\n\nsavingsaccounts/external-id/ExternalId1\n\n\nsavingsaccounts/external-id/ExternalId1?associations=all")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.GetSavingsAccountsAccountIdResponse.class))})})
    public String retrieveOne(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        return this.retrieveSavingAccount(null, externalId, staffInSelectedOfficeOnly, chargeStatus, uriInfo);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a savings application | Modify savings account withhold tax applicability", description="Modify a savings application:\n\nSavings application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc\n\nModify savings account withhold tax applicability:\n\nSavings application's withhold tax can be modified when in 'Active' state. Once the application is activated, can modify the account withhold tax to post tax or vice-versaShowing request/response for 'Modify a savings application'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PutSavingsAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PutSavingsAccountsAccountIdResponse.class))})})
    public String update(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.updateSavingAccount(accountId, null, apiRequestBodyAsJson, commandParam);
    }

    @PUT
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a savings application | Modify savings account withhold tax applicability", description="Modify a savings application:\n\nSavings application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc\n\nModify savings account withhold tax applicability:\n\nSavings application's withhold tax can be modified when in 'Active' state. Once the application is activated, can modify the account withhold tax to post tax or vice-versaShowing request/response for 'Modify a savings application'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PutSavingsAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PutSavingsAccountsAccountIdResponse.class))})})
    public String update(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.updateSavingAccount(null, externalId, apiRequestBodyAsJson, commandParam);
    }

    @PUT
    @Path(value="/gsim/{parentAccountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateGsim(@PathParam(value="parentAccountId") Long parentAccountId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateGSIMAccount(parentAccountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="/gsimcommands/{parentAccountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String handleGSIMCommands(@PathParam(value="parentAccountId") Long parentAccountId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "reject")) {
            CommandWrapper commandRequest = builder.rejectGSIMAccountApplication(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawnByApplicant")) {
            CommandWrapper commandRequest = builder.withdrawSavingsAccountApplication(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "approve")) {
            CommandWrapper commandRequest = builder.approveGSIMAccountApplication(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "undoapproval")) {
            CommandWrapper commandRequest = builder.undoGSIMApplicationApproval(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.gsimAccountActivation(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculateInterest")) {
            CommandWrapper commandRequest = builder.withNoJsonBody().savingsAccountInterestCalculation(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "postInterest")) {
            CommandWrapper commandRequest = builder.savingsAccountInterestPosting(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "applyAnnualFees")) {
            CommandWrapper commandRequest = builder.savingsAccountApplyAnnualFees(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeGSIMApplication(parentAccountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"reject", "withdrawnByApplicant", "approve", "undoapproval", "activate", "calculateInterest", "postInterest", "close", "assignSavingsOfficer", "unassignSavingsOfficer", "blockDebit", "unblockDebit", "blockCredit", "unblockCredit", "block", "unblock"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve savings application | Undo approval savings application | Assign Savings Officer | Unassign Savings Officer | Reject savings application | Withdraw savings application | Activate a savings account | Close a savings account | Calculate Interest on Savings Account | Post Interest on Savings Account | Block Savings Account | Unblock Savings Account | Block Savings Account Credit transactions | Unblock Savings Account Credit transactions | Block Savings Account Debit transactions | Unblock Savings Account debit transactions", description="Approve savings application:\n\nApproves savings application so long as its in 'Submitted and pending approval' state.\n\nUndo approval savings application:\n\nWill move 'approved' savings application back to 'Submitted and pending approval' state.\n\nAssign Savings Officer:\n\nAllows you to assign Savings Officer for existing Savings Account.\n\nUnassign Savings Officer:\n\nAllows you to unassign the Savings Officer.\n\nReject savings application:\n\nRejects savings application so long as its in 'Submitted and pending approval' state.\n\nWithdraw savings application:\n\nUsed when an applicant withdraws from the savings application. It must be in 'Submitted and pending approval' state.\n\nActivate a savings account:\n\nResults in an approved savings application being converted into an 'active' savings account.\n\nClose a savings account:\n\nResults in an Activated savings application being converted into an 'closed' savings account.\n\nclosedOnDate is closure date of savings account\n\nwithdrawBalance is a boolean description, true value of this field performs a withdrawal transaction with account's running balance.\n\nMandatory Fields: dateFormat,locale,closedOnDate\n\nOptional Fields: note, withdrawBalance, paymentTypeId, accountNumber, checkNumber, routingCode, receiptNumber, bankNumber\n\nCalculate Interest on Savings Account:\n\nCalculates interest earned on a savings account based on todays date. It does not attempt to post or credit the interest on the account. That is responsibility of the Post Interest API that will likely be called by overnight process.\n\nPost Interest on Savings Account:\n\nCalculates and Posts interest earned on a savings account based on today's date and whether an interest posting or crediting event is due.\n\nBlock Savings Account:\n\nBlocks Savings account from all types of credit and debit transactions\n\nUnblock Savings Account:\n\nUnblock a blocked account. On unblocking account, user can perform debit and credit transactions\n\nBlock Savings Account Credit transactions:\n\nSavings account will be blocked from all types of credit transactions.\n\nUnblock Savings Account Credit transactions:\n\nIt unblocks the Saving account's credit operations. Now all types of credits can be transacted to Savings account\n\nBlock Savings Account Debit transactions:\n\nAll types of debit operations from Savings account wil be blocked\n\nUnblock Savings Account debit transactions:\n\nIt unblocks the Saving account's debit operations. Now all types of debits can be transacted from Savings account\n\nShowing request/response for 'Unassign Savings Officer'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsAccountIdResponse.class))})})
    public String handleCommands(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleCommands(accountId, null, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve savings application | Undo approval savings application | Assign Savings Officer | Unassign Savings Officer | Reject savings application | Withdraw savings application | Activate a savings account | Close a savings account | Calculate Interest on Savings Account | Post Interest on Savings Account | Block Savings Account | Unblock Savings Account | Block Savings Account Credit transactions | Unblock Savings Account Credit transactions | Block Savings Account Debit transactions | Unblock Savings Account debit transactions", description="Approve savings application:\n\nApproves savings application so long as its in 'Submitted and pending approval' state.\n\nUndo approval savings application:\n\nWill move 'approved' savings application back to 'Submitted and pending approval' state.\n\nAssign Savings Officer:\n\nAllows you to assign Savings Officer for existing Savings Account.\n\nUnassign Savings Officer:\n\nAllows you to unassign the Savings Officer.\n\nReject savings application:\n\nRejects savings application so long as its in 'Submitted and pending approval' state.\n\nWithdraw savings application:\n\nUsed when an applicant withdraws from the savings application. It must be in 'Submitted and pending approval' state.\n\nActivate a savings account:\n\nResults in an approved savings application being converted into an 'active' savings account.\n\nClose a savings account:\n\nResults in an Activated savings application being converted into an 'closed' savings account.\n\nclosedOnDate is closure date of savings account\n\nwithdrawBalance is a boolean description, true value of this field performs a withdrawal transaction with account's running balance.\n\nMandatory Fields: dateFormat,locale,closedOnDate\n\nOptional Fields: note, withdrawBalance, paymentTypeId, accountNumber, checkNumber, routingCode, receiptNumber, bankNumber\n\nCalculate Interest on Savings Account:\n\nCalculates interest earned on a savings account based on todays date. It does not attempt to post or credit the interest on the account. That is responsibility of the Post Interest API that will likely be called by overnight process.\n\nPost Interest on Savings Account:\n\nCalculates and Posts interest earned on a savings account based on today's date and whether an interest posting or crediting event is due.\n\nBlock Savings Account:\n\nBlocks Savings account from all types of credit and debit transactions\n\nUnblock Savings Account:\n\nUnblock a blocked account. On unblocking account, user can perform debit and credit transactions\n\nBlock Savings Account Credit transactions:\n\nSavings account will be blocked from all types of credit transactions.\n\nUnblock Savings Account Credit transactions:\n\nIt unblocks the Saving account's credit operations. Now all types of credits can be transacted to Savings account\n\nBlock Savings Account Debit transactions:\n\nAll types of debit operations from Savings account wil be blocked\n\nUnblock Savings Account debit transactions:\n\nIt unblocks the Saving account's debit operations. Now all types of debits can be transacted from Savings account\n\nShowing request/response for 'Unassign Savings Officer'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.PostSavingsAccountsAccountIdResponse.class))})})
    public String handleCommands(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.handleCommands(null, externalId, commandParam, apiRequestBodyAsJson);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @DELETE
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a savings application", description="At present we support hard delete of savings application so long as its in 'Submitted and pending approval' state. One the application is moves past this state, it is not possible to do a 'hard' delete of the application or the account. An API endpoint will be added to close/de-activate the savings account.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.DeleteSavingsAccountsAccountIdResponse.class))})})
    public String delete(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId) {
        return this.deleteSavingAccount(accountId, null);
    }

    @DELETE
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a savings application", description="At present we support hard delete of savings application so long as its in 'Submitted and pending approval' state. One the application is moves past this state, it is not possible to do a 'hard' delete of the application or the account. An API endpoint will be added to close/de-activate the savings account.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SavingsAccountsApiResourceSwagger.DeleteSavingsAccountsAccountIdResponse.class))})})
    public String delete(@PathParam(value="externalId") @Parameter(description="externalId") String externalId) {
        return this.deleteSavingAccount(null, externalId);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getSavingsTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.SAVINGS_ACCOUNT.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload savings template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postSavingsTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.SAVINGS_ACCOUNT.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="transactions/downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getSavingsTransactionTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.SAVINGS_TRANSACTIONS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="transactions/uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload savings transaction template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postSavingsTransactionTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.SAVINGS_TRANSACTIONS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    private String retrieveSavingAccount(Long accountId, String externalId, boolean staffInSelectedOfficeOnly, String chargeStatus, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        if (!(this.is(chargeStatus, "all") || this.is(chargeStatus, "active") || this.is(chargeStatus, "inactive"))) {
            throw new UnrecognizedQueryParamException("status", chargeStatus, new Object[]{"all", "active", "inactive"});
        }
        ExternalId accountExternalId = ExternalIdFactory.produce((String)externalId);
        accountId = this.getResolvedAccountId(accountId, accountExternalId);
        SavingsAccountData savingsAccount = this.savingsAccountReadPlatformService.retrieveOne(accountId);
        HashSet mandatoryResponseParameters = new HashSet();
        SavingsAccountData savingsAccountTemplate = this.populateTemplateAndAssociations(accountId, savingsAccount, staffInSelectedOfficeOnly, chargeStatus, uriInfo, mandatoryResponseParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters(), mandatoryResponseParameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)savingsAccountTemplate, SavingsApiSetConstants.SAVINGS_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    private String updateSavingAccount(Long accountId, String externalId, String apiRequestBodyAsJson, String commandParam) {
        ExternalId accountExternalId = ExternalIdFactory.produce((String)externalId);
        accountId = this.getResolvedAccountId(accountId, accountExternalId);
        if (this.is(commandParam, "updateWithHoldTax")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson).updateWithHoldTax(accountId).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSavingsAccount(accountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String handleCommands(Long accountId, String externalId, String commandParam, String apiRequestBodyAsJson) {
        ExternalId accountExternalId = ExternalIdFactory.produce((String)externalId);
        accountId = this.getResolvedAccountId(accountId, accountExternalId);
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "reject")) {
            CommandWrapper commandRequest = builder.rejectSavingsAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawnByApplicant")) {
            CommandWrapper commandRequest = builder.withdrawSavingsAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "approve")) {
            CommandWrapper commandRequest = builder.approveSavingsAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "undoapproval")) {
            CommandWrapper commandRequest = builder.undoSavingsAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.savingsAccountActivation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculateInterest")) {
            CommandWrapper commandRequest = builder.withNoJsonBody().savingsAccountInterestCalculation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "postInterest")) {
            CommandWrapper commandRequest = builder.savingsAccountInterestPosting(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "applyAnnualFees")) {
            CommandWrapper commandRequest = builder.savingsAccountApplyAnnualFees(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeSavingsAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else {
            if (this.is(commandParam, "assignSavingsOfficer")) {
                CommandWrapper commandRequest = builder.assignSavingsOfficer(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                return this.toApiJsonSerializer.serialize((Object)result);
            }
            if (this.is(commandParam, "unassignSavingsOfficer")) {
                CommandWrapper commandRequest = builder.unassignSavingsOfficer(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                return this.toApiJsonSerializer.serialize((Object)result);
            }
            if (this.is(commandParam, "blockDebit")) {
                CommandWrapper commandRequest = builder.blockDebitsFromSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else if (this.is(commandParam, "unblockDebit")) {
                CommandWrapper commandRequest = builder.unblockDebitsFromSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else if (this.is(commandParam, "blockCredit")) {
                CommandWrapper commandRequest = builder.blockCreditsToSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else if (this.is(commandParam, "unblockCredit")) {
                CommandWrapper commandRequest = builder.unblockCreditsToSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else if (this.is(commandParam, "block")) {
                CommandWrapper commandRequest = builder.blockSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            } else if (this.is(commandParam, "unblock")) {
                CommandWrapper commandRequest = builder.unblockSavingsAccount(accountId).build();
                result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            }
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"reject", "withdrawnByApplicant", "approve", "undoapproval", "activate", "calculateInterest", "postInterest", "close", "assignSavingsOfficer", "unassignSavingsOfficer", "blockDebit", "unblockDebit", "blockCredit", "unblockCredit", "block", "unblock"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String deleteSavingAccount(Long accountId, String externalId) {
        ExternalId accountExternalId = ExternalIdFactory.produce((String)externalId);
        accountId = this.getResolvedAccountId(accountId, accountExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSavingsAccount(accountId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private Long getResolvedAccountId(Long accountId, ExternalId accountExternalId) {
        Long resolvedAccountId = accountId;
        if (resolvedAccountId == null) {
            accountExternalId.throwExceptionIfEmpty();
            resolvedAccountId = this.savingsAccountReadPlatformService.retrieveAccountIdByExternalId(accountExternalId);
            if (resolvedAccountId == null) {
                throw new SavingsAccountNotFoundException(resolvedAccountId);
            }
        }
        return resolvedAccountId;
    }

    private SavingsAccountData populateTemplateAndAssociations(Long accountId, SavingsAccountData savingsAccount, boolean staffInSelectedOfficeOnly, String chargeStatus, UriInfo uriInfo, Set<String> mandatoryResponseParameters) {
        Collection transactions = null;
        Collection charges = null;
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("transactions", "charges"));
            }
            if (associationParameters.contains("transactions")) {
                mandatoryResponseParameters.add("transactions");
                Collection currentTransactions = this.savingsAccountReadPlatformService.retrieveAllTransactions(accountId, DepositAccountType.SAVINGS_DEPOSIT);
                if (!CollectionUtils.isEmpty((Collection)currentTransactions)) {
                    transactions = currentTransactions;
                }
            }
            if (associationParameters.contains("charges")) {
                mandatoryResponseParameters.add("charges");
                Collection currentCharges = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountCharges(accountId, chargeStatus);
                if (!CollectionUtils.isEmpty((Collection)currentCharges)) {
                    charges = currentCharges;
                }
            }
        }
        SavingsAccountData templateData = null;
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            templateData = this.savingsAccountReadPlatformService.retrieveTemplate(savingsAccount.getClientId(), savingsAccount.getGroupId(), savingsAccount.getSavingsProductId(), staffInSelectedOfficeOnly);
        }
        return SavingsAccountData.withTemplateOptions((SavingsAccountData)savingsAccount, templateData, transactions, charges);
    }

    @Generated
    public SavingsAccountsApiResource(SavingsAccountReadPlatformService savingsAccountReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<SavingsAccountData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, SqlValidator sqlValidator) {
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.sqlValidator = sqlValidator;
    }
}

