/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.repaymentwithpostdatedchecks.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.api.PostDatedChecksApiResourceSwagger;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.data.PostDatedChecksData;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service.RepaymentWithPostDatedChecksReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans/{loanId}/postdatedchecks")
@Component
@Tag(name="repayment with post dated checks", description="Repay with post dated checks")
public class RepaymentWithPostDatedChecksApiResource {
    private final PlatformSecurityContext context;
    private final FromJsonHelper fromJsonHelper;
    private final DefaultToApiJsonSerializer<PostDatedChecksData> apiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final RepaymentWithPostDatedChecksReadPlatformService repaymentWithPostDatedChecksReadPlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get All Post Dated Checks", description="Get All Post dated Checks")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PostDatedChecksApiResourceSwagger.GetPostDatedChecks.class)))})})
    public String getPostDatedChecks(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser();
        List postDatedChecksDataList = this.repaymentWithPostDatedChecksReadPlatformService.getPostDatedChecks(loanId);
        return this.apiJsonSerializer.serialize((Object)postDatedChecksDataList);
    }

    @GET
    @Path(value="{installmentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Post Dated Check", description="Get Post Dated Check")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PostDatedChecksApiResourceSwagger.GetPostDatedChecks.class)))})})
    public String getPostDatedCheck(@PathParam(value="installmentId") @Parameter(description="installmentId") Integer installmentId, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser();
        PostDatedChecksData postDatedChecksData = this.repaymentWithPostDatedChecksReadPlatformService.getPostDatedCheckByInstallmentId(installmentId, loanId);
        return this.apiJsonSerializer.serialize((Object)postDatedChecksData);
    }

    @PUT
    @Path(value="{postDatedCheckId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Post Dated Check, Bounced Check", description="Update Post Dated Check, Bounced Check")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=PostDatedChecksApiResourceSwagger.UpdatePostDatedCheckRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PostDatedChecksApiResourceSwagger.UpdatePostDatedCheckResponse.class)))})})
    public String updatePostDatedChecks(@PathParam(value="postDatedCheckId") @Parameter(description="postDatedCheckId") Long id, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="editType") @Parameter(description="editType") String type) {
        CommandWrapper commandRequest = null;
        if ("update".equals(type)) {
            commandRequest = new CommandWrapperBuilder().updatePostDatedCheck(id, loanId).withJson(apiRequestBodyAsJson).build();
        } else if ("bounced".equals(type)) {
            commandRequest = new CommandWrapperBuilder().bouncedCheck(id, loanId).withJson(apiRequestBodyAsJson).build();
        }
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @DELETE
    @Path(value="{postDatedCheckId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Post Dated Check", description="Delete Post Dated Check")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PostDatedChecksApiResourceSwagger.DeletePostDatedCheck.class)))})})
    public String deletePostDatedCheck(@PathParam(value="postDatedCheckId") @Parameter(description="postDatedCheckId") Long id, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deletePostDatedCheck(id, loanId).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @Generated
    public RepaymentWithPostDatedChecksApiResource(PlatformSecurityContext context, FromJsonHelper fromJsonHelper, DefaultToApiJsonSerializer<PostDatedChecksData> apiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, RepaymentWithPostDatedChecksReadPlatformService repaymentWithPostDatedChecksReadPlatformService) {
        this.context = context;
        this.fromJsonHelper = fromJsonHelper;
        this.apiJsonSerializer = apiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.repaymentWithPostDatedChecksReadPlatformService = repaymentWithPostDatedChecksReadPlatformService;
    }
}

