/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.rate.data.RateData;
import org.apache.fineract.portfolio.rate.domain.RateAppliesTo;
import org.apache.fineract.portfolio.rate.exception.RateNotFoundException;
import org.apache.fineract.portfolio.rate.service.RateReadService;
import org.apache.fineract.portfolio.rate.service.RateReadServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class RateReadServiceImpl
implements RateReadService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    public Collection<RateData> retrieveAllRates() {
        this.context.authenticatedUser();
        RateMapper rm = new RateMapper();
        String sql = "select " + rm.rateSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public RateData retrieveOne(Long rateId) {
        try {
            this.context.authenticatedUser();
            RateMapper rm = new RateMapper();
            String sql = "select " + rm.rateSchema() + " where r.id = ?";
            RateData selectedRate = (RateData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{rateId});
            return selectedRate;
        }
        catch (EmptyResultDataAccessException e) {
            throw new RateNotFoundException(rateId, e);
        }
    }

    public RateData retrieveByName(String name) {
        try {
            this.context.authenticatedUser();
            RateMapper rm = new RateMapper();
            String sql = "select " + rm.rateSchema() + " where r.name = ?";
            RateData selectedRate = (RateData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{name});
            return selectedRate;
        }
        catch (EmptyResultDataAccessException e) {
            throw new RateNotFoundException(name, e);
        }
    }

    public Collection<RateData> retrieveLoanApplicableRates() {
        this.context.authenticatedUser();
        RateMapper rm = new RateMapper();
        String sql = "select " + rm.rateSchema() + " where r.active = ? and product_apply=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{true, RateAppliesTo.LOAN.getValue()});
    }

    public List<RateData> retrieveLoanRates(Long loanId) {
        RateMapper rm = new RateMapper();
        String sql = "select " + rm.loanRateSchema() + " where lr.loan_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId});
    }

    public List<RateData> retrieveProductLoanRates(Long loanId) {
        RateMapper rm = new RateMapper();
        String sql = "select " + rm.productLoanRateSchema() + " where lr.product_loan_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId});
    }

    @Generated
    public RateReadServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

