/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.note.service;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.note.domain.NoteType;
import org.apache.fineract.portfolio.note.exception.NoteNotFoundException;
import org.apache.fineract.portfolio.note.exception.NoteResourceNotSupportedException;
import org.apache.fineract.portfolio.note.serialization.NoteCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.note.service.NoteWritePlatformService;
import org.apache.fineract.portfolio.note.service.NoteWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoteWritePlatformServiceJpaRepositoryImpl
implements NoteWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoteWritePlatformServiceJpaRepositoryImpl.class);
    private final NoteRepository noteRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepository groupRepository;
    private final LoanRepositoryWrapper loanRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final NoteCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final SavingsAccountRepository savingsAccountRepository;

    public NoteWritePlatformServiceJpaRepositoryImpl(NoteRepository noteRepository, ClientRepositoryWrapper clientRepository, GroupRepository groupRepository, LoanRepositoryWrapper loanRepository, LoanTransactionRepository loanTransactionRepository, NoteCommandFromApiJsonDeserializer fromApiJsonDeserializer, SavingsAccountRepository savingsAccountRepository) {
        this.noteRepository = noteRepository;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.loanRepository = loanRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.savingsAccountRepository = savingsAccountRepository;
    }

    private CommandProcessingResult createClientNote(JsonCommand command) {
        Long resourceId = command.getClientId();
        Client client = this.clientRepository.findOneWithNotFoundDetection(resourceId);
        if (client == null) {
            throw new ClientNotFoundException(resourceId);
        }
        Note newNote = Note.clientNoteFromJson((Client)client, (JsonCommand)command);
        this.noteRepository.saveAndFlush((Object)newNote);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newNote.getId()).withClientId((Long)client.getId()).withOfficeId(client.officeId()).build();
    }

    public void createAndPersistClientNote(Client client, JsonCommand command) {
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note newNote = new Note(client, noteText);
            this.noteRepository.save((Object)newNote);
        }
    }

    private CommandProcessingResult createGroupNote(JsonCommand command) {
        Long resourceId = command.getGroupId();
        Group group = (Group)this.groupRepository.findById((Object)resourceId).orElseThrow(() -> new GroupNotFoundException(resourceId));
        Note newNote = Note.groupNoteFromJson((Group)group, (JsonCommand)command);
        this.noteRepository.saveAndFlush((Object)newNote);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newNote.getId()).withGroupId((Long)group.getId()).withOfficeId(group.officeId()).build();
    }

    private CommandProcessingResult createLoanNote(JsonCommand command) {
        Long resourceId = command.getLoanId();
        Loan loan = this.loanRepository.findOneWithNotFoundDetection(resourceId);
        String note = command.stringValueOfParameterNamed("note");
        Note newNote = Note.loanNote((Loan)loan, (String)note);
        this.noteRepository.saveAndFlush((Object)newNote);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newNote.getId()).withOfficeId(loan.getOfficeId()).withLoanId((Long)loan.getId()).build();
    }

    private CommandProcessingResult createLoanTransactionNote(JsonCommand command) {
        Long resourceId = command.subentityId();
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)resourceId).orElseThrow(() -> new LoanTransactionNotFoundException(resourceId));
        Loan loan = loanTransaction.getLoan();
        String note = command.stringValueOfParameterNamed("note");
        Note newNote = Note.loanTransactionNote((Loan)loan, (LoanTransaction)loanTransaction, (String)note);
        this.noteRepository.saveAndFlush((Object)newNote);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newNote.getId()).withOfficeId(loan.getOfficeId()).withLoanId((Long)loan.getId()).build();
    }

    private CommandProcessingResult createSavingAccountNote(JsonCommand command) {
        Long resourceId = command.getSavingsId();
        SavingsAccount savingAccount = (SavingsAccount)this.savingsAccountRepository.findById((Object)resourceId).orElseThrow(() -> new SavingsAccountNotFoundException(resourceId));
        String note = command.stringValueOfParameterNamed("note");
        Note newNote = Note.savingNote((SavingsAccount)savingAccount, (String)note);
        this.noteRepository.saveAndFlush((Object)newNote);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newNote.getId()).withOfficeId((Long)savingAccount.getClient().getOffice().getId()).withSavingsId((Long)savingAccount.getId()).build();
    }

    public CommandProcessingResult createNote(JsonCommand command) {
        this.fromApiJsonDeserializer.validateNote(command.json());
        String resourceUrl = this.getResourceUrlFromCommand(command);
        NoteType type = NoteType.fromApiUrl((String)resourceUrl);
        switch (1.$SwitchMap$org$apache$fineract$portfolio$note$domain$NoteType[type.ordinal()]) {
            case 1: {
                return this.createClientNote(command);
            }
            case 2: {
                return this.createGroupNote(command);
            }
            case 3: {
                return this.createLoanNote(command);
            }
            case 4: {
                return this.createLoanTransactionNote(command);
            }
            case 5: {
                return this.createSavingAccountNote(command);
            }
        }
        throw new NoteResourceNotSupportedException(resourceUrl);
    }

    private String getResourceUrlFromCommand(JsonCommand command) {
        String resourceUrl = command.getClientId() != null ? NoteType.CLIENT.getApiUrl() : (command.getGroupId() != null ? NoteType.GROUP.getApiUrl() : (command.getLoanId() != null ? (command.subentityId() != null ? NoteType.LOAN_TRANSACTION.getApiUrl() : NoteType.LOAN.getApiUrl()) : (command.getSavingsId() != null ? NoteType.SAVING_ACCOUNT.getApiUrl() : "")));
        return resourceUrl;
    }

    private CommandProcessingResult updateClientNote(JsonCommand command) {
        Long resourceId = command.getClientId();
        Long noteId = command.entityId();
        NoteType type = NoteType.CLIENT;
        Client client = this.clientRepository.findOneWithNotFoundDetection(resourceId);
        Note noteForUpdate = this.noteRepository.findByClientAndId(client, noteId);
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        Map changes = noteForUpdate.update(command);
        if (!changes.isEmpty()) {
            this.noteRepository.saveAndFlush((Object)noteForUpdate);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)noteForUpdate.getId()).withClientId((Long)client.getId()).withOfficeId(client.officeId()).with(changes).build();
    }

    private CommandProcessingResult updateGroupNote(JsonCommand command) {
        Long resourceId = command.getGroupId();
        Long noteId = command.entityId();
        NoteType type = NoteType.GROUP;
        Group group = (Group)this.groupRepository.findById((Object)resourceId).orElseThrow(() -> new GroupNotFoundException(resourceId));
        Note noteForUpdate = this.noteRepository.findByGroupAndId(group, noteId);
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        Map changes = noteForUpdate.update(command);
        if (!changes.isEmpty()) {
            this.noteRepository.saveAndFlush((Object)noteForUpdate);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)noteForUpdate.getId()).withGroupId((Long)group.getId()).withOfficeId(group.officeId()).with(changes).build();
    }

    private CommandProcessingResult updateLoanNote(JsonCommand command) {
        Long resourceId = command.getLoanId();
        Long noteId = command.entityId();
        NoteType type = NoteType.LOAN;
        Loan loan = this.loanRepository.findOneWithNotFoundDetection(resourceId);
        Note noteForUpdate = this.noteRepository.findByLoanAndId(loan, noteId);
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        Map changes = noteForUpdate.update(command);
        if (!changes.isEmpty()) {
            this.noteRepository.saveAndFlush((Object)noteForUpdate);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)noteForUpdate.getId()).withLoanId((Long)loan.getId()).withOfficeId(loan.getOfficeId()).with(changes).build();
    }

    private CommandProcessingResult updateLoanTransactionNote(JsonCommand command) {
        Long resourceId = command.subentityId();
        Long noteId = command.entityId();
        NoteType type = NoteType.LOAN_TRANSACTION;
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)resourceId).orElseThrow(() -> new LoanTransactionNotFoundException(resourceId));
        Loan loan = loanTransaction.getLoan();
        Note noteForUpdate = this.noteRepository.findByLoanTransactionAndId(loanTransaction, noteId);
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        Map changes = noteForUpdate.update(command);
        if (!changes.isEmpty()) {
            this.noteRepository.saveAndFlush((Object)noteForUpdate);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)noteForUpdate.getId()).withLoanId((Long)loan.getId()).withOfficeId(loan.getOfficeId()).with(changes).build();
    }

    private CommandProcessingResult updateSavingAccountNote(JsonCommand command) {
        Long resourceId = command.getSavingsId();
        Long noteId = command.entityId();
        NoteType type = NoteType.SAVING_ACCOUNT;
        SavingsAccount savingAccount = (SavingsAccount)this.savingsAccountRepository.findById((Object)resourceId).orElseThrow(() -> new SavingsAccountNotFoundException(resourceId));
        Note noteForUpdate = this.noteRepository.findBySavingsAccountAndId(savingAccount, noteId);
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        Map changes = noteForUpdate.update(command);
        if (!changes.isEmpty()) {
            this.noteRepository.saveAndFlush((Object)noteForUpdate);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)noteForUpdate.getId()).withOfficeId((Long)savingAccount.getClient().getOffice().getId()).withSavingsId((Long)savingAccount.getId()).with(changes).build();
    }

    public CommandProcessingResult updateNote(JsonCommand command) {
        this.fromApiJsonDeserializer.validateNote(command.json());
        String resourceUrl = this.getResourceUrlFromCommand(command);
        NoteType type = NoteType.fromApiUrl((String)resourceUrl);
        switch (1.$SwitchMap$org$apache$fineract$portfolio$note$domain$NoteType[type.ordinal()]) {
            case 1: {
                return this.updateClientNote(command);
            }
            case 2: {
                return this.updateGroupNote(command);
            }
            case 3: {
                return this.updateLoanNote(command);
            }
            case 4: {
                return this.updateLoanTransactionNote(command);
            }
            case 5: {
                return this.updateSavingAccountNote(command);
            }
        }
        throw new NoteResourceNotSupportedException(resourceUrl);
    }

    public CommandProcessingResult deleteNote(JsonCommand command) {
        Note noteForDelete = this.getNoteForDelete(command);
        this.noteRepository.delete((Object)noteForDelete);
        return new CommandProcessingResultBuilder().withCommandId(null).withEntityId(command.entityId()).build();
    }

    private Note getNoteForDelete(JsonCommand command) {
        String resourceUrl = this.getResourceUrlFromCommand(command);
        Long noteId = command.entityId();
        NoteType type = NoteType.fromApiUrl((String)resourceUrl);
        Long resourceId = null;
        Note noteForUpdate = null;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$note$domain$NoteType[type.ordinal()]) {
            case 1: {
                resourceId = command.getClientId();
                Client client = this.clientRepository.findOneWithNotFoundDetection(resourceId);
                noteForUpdate = this.noteRepository.findByClientAndId(client, noteId);
                break;
            }
            case 2: {
                Long groupId;
                resourceId = groupId = command.getGroupId();
                Group group = (Group)this.groupRepository.findById((Object)groupId).orElseThrow(() -> new GroupNotFoundException(groupId));
                noteForUpdate = this.noteRepository.findByGroupAndId(group, noteId);
                break;
            }
            case 3: {
                resourceId = command.getLoanId();
                Loan loan = this.loanRepository.findOneWithNotFoundDetection(resourceId);
                noteForUpdate = this.noteRepository.findByLoanAndId(loan, noteId);
                break;
            }
            case 4: {
                Long loanTransactionId = resourceId = command.subentityId();
                LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)loanTransactionId).orElseThrow(() -> new LoanTransactionNotFoundException(loanTransactionId));
                noteForUpdate = this.noteRepository.findByLoanTransactionAndId(loanTransaction, noteId);
                break;
            }
            case 5: {
                Long savinsAccountId = command.getSavingsId();
                SavingsAccount savingAccount = (SavingsAccount)this.savingsAccountRepository.findById((Object)savinsAccountId).orElseThrow(() -> new SavingsAccountNotFoundException(savinsAccountId));
                noteForUpdate = this.noteRepository.findBySavingsAccountAndId(savingAccount, noteId);
                break;
            }
            case 6: {
                log.error("TODO Implement getNoteForDelete for SHARE_ACCOUNT");
                break;
            }
            case 7: {
                log.error("TODO Implement getNoteForDelete for SAVINGS_TRANSACTION");
            }
        }
        if (noteForUpdate == null) {
            throw new NoteNotFoundException(noteId, resourceId, type.name().toLowerCase());
        }
        return noteForUpdate;
    }
}

