/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.note.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.note.api.NotesApiResource;
import org.apache.fineract.portfolio.note.api.NotesApiResourceSwagger;
import org.apache.fineract.portfolio.note.data.NoteData;
import org.apache.fineract.portfolio.note.domain.NoteType;
import org.apache.fineract.portfolio.note.exception.NoteResourceNotSupportedException;
import org.apache.fineract.portfolio.note.service.NoteReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/{resourceType}/{resourceId}/notes")
@Component
@Tag(name="Notes", description="Notes API allows to enter notes for supported resources.")
public class NotesApiResource {
    public static final String CLIENTNOTE = "CLIENTNOTE";
    public static final String LOANNOTE = "LOANNOTE";
    public static final String LOANTRANSACTIONNOTE = "LOANTRANSACTIONNOTE";
    public static final String SAVINGNOTE = "SAVINGNOTE";
    public static final String GROUPNOTE = "GROUPNOTE";
    public static final String INVALIDNOTE = "INVALIDNOTE";
    private static final Set<String> NOTE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "resourceId", "clientId", "groupId", "loanId", "loanTransactionId", "depositAccountId", "savingAccountId", "noteType", "note", "createdById", "createdByUsername", "createdOn", "updatedById", "updatedByUsername", "updatedOn"));
    private final PlatformSecurityContext context;
    private final NoteReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<NoteData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Resource's description", description="Retrieves a Resource's Notes\n\nNote: Notes are returned in descending createOn order.\n\nExample Requests:\n\nclients/2/notes\n\n\ngroups/2/notes?fields=note,createdOn,createdByUsername")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NotesApiResourceSwagger.GetResourceTypeResourceIdNotesResponse.class)))})})
    public String retrieveNotesByResource(@PathParam(value="resourceType") @Parameter(description="resourceType") String resourceType, @PathParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @Context UriInfo uriInfo) {
        NoteType noteType = NoteType.fromApiUrl((String)resourceType);
        if (noteType == null) {
            throw new NoteResourceNotSupportedException(resourceType);
        }
        this.context.authenticatedUser().validateHasReadPermission(this.getResourceDetails(noteType, resourceId).entityName());
        Integer noteTypeId = noteType.getValue();
        Collection notes = this.readPlatformService.retrieveNotesByResource(resourceId, noteTypeId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, notes, NOTE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{noteId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Resource Note", description="Retrieves a Resource Note\n\nExample Requests:\n\nclients/1/notes/76\n\n\ngroups/1/notes/20\n\n\nclients/1/notes/76?fields=note,createdOn,createdByUsername\n\n\ngroups/1/notes/20?fields=note,createdOn,createdByUsername")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.GetResourceTypeResourceIdNotesNoteIdResponse.class))})})
    public String retrieveNote(@PathParam(value="resourceType") @Parameter(description="resourceType") String resourceType, @PathParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @PathParam(value="noteId") @Parameter(description="noteId") Long noteId, @Context UriInfo uriInfo) {
        NoteType noteType = NoteType.fromApiUrl((String)resourceType);
        if (noteType == null) {
            throw new NoteResourceNotSupportedException(resourceType);
        }
        this.context.authenticatedUser().validateHasReadPermission(this.getResourceDetails(noteType, resourceId).entityName());
        Integer noteTypeId = noteType.getValue();
        NoteData note = this.readPlatformService.retrieveNote(noteId, resourceId, noteTypeId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)note, NOTE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add a Resource Note", description="Adds a new note to a supported resource.\n\nExample Requests:\n\nclients/1/notes\n\n\ngroups/1/notes")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.PostResourceTypeResourceIdNotesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.PostResourceTypeResourceIdNotesResponse.class))})})
    public String addNewNote(@PathParam(value="resourceType") @Parameter(description="resourceType") String resourceType, @PathParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        NoteType noteType = NoteType.fromApiUrl((String)resourceType);
        if (noteType == null) {
            throw new NoteResourceNotSupportedException(resourceType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(noteType, resourceId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createNote(resourceDetails, resourceType, resourceId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{noteId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Resource Note", description="Updates a Resource Note")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.PutResourceTypeResourceIdNotesNoteIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.PutResourceTypeResourceIdNotesNoteIdResponse.class))})})
    public String updateNote(@PathParam(value="resourceType") @Parameter(description="resourceType") String resourceType, @PathParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @PathParam(value="noteId") @Parameter(description="noteId") Long noteId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        NoteType noteType = NoteType.fromApiUrl((String)resourceType);
        if (noteType == null) {
            throw new NoteResourceNotSupportedException(resourceType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(noteType, resourceId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateNote(resourceDetails, resourceType, resourceId, noteId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{noteId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Resource Note", description="Deletes a Resource Note")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=NotesApiResourceSwagger.DeleteResourceTypeResourceIdNotesNoteIdResponse.class))})})
    public String deleteNote(@PathParam(value="resourceType") @Parameter(description="resourceType") String resourceType, @PathParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @PathParam(value="noteId") @Parameter(description="noteId") Long noteId) {
        NoteType noteType = NoteType.fromApiUrl((String)resourceType);
        if (noteType == null) {
            throw new NoteResourceNotSupportedException(resourceType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(noteType, resourceId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteNote(resourceDetails, resourceType, resourceId, noteId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private CommandWrapper getResourceDetails(NoteType type, Long resourceId) {
        String resourceNameForPermissions;
        CommandWrapperBuilder resourceDetails = new CommandWrapperBuilder();
        switch (1.$SwitchMap$org$apache$fineract$portfolio$note$domain$NoteType[type.ordinal()]) {
            case 1: {
                resourceNameForPermissions = CLIENTNOTE;
                resourceDetails.withClientId(resourceId);
                break;
            }
            case 2: {
                resourceNameForPermissions = LOANNOTE;
                resourceDetails.withLoanId(resourceId);
                break;
            }
            case 3: {
                resourceNameForPermissions = LOANTRANSACTIONNOTE;
                resourceDetails.withLoanId(resourceId);
                resourceDetails.withSubEntityId(resourceId);
                break;
            }
            case 4: {
                resourceNameForPermissions = SAVINGNOTE;
                resourceDetails.withSavingsId(resourceId);
                break;
            }
            case 5: {
                resourceNameForPermissions = GROUPNOTE;
                resourceDetails.withGroupId(resourceId);
                break;
            }
            default: {
                resourceNameForPermissions = INVALIDNOTE;
            }
        }
        return resourceDetails.withEntityName(resourceNameForPermissions).build();
    }

    @Generated
    public NotesApiResource(PlatformSecurityContext context, NoteReadPlatformService readPlatformService, DefaultToApiJsonSerializer<NoteData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

