/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.attendance.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.meeting.domain.Meeting;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_client_attendance", uniqueConstraints={@UniqueConstraint(columnNames={"client_id", "meeting_id"}, name="unique_client_meeting_attendance")})
public class ClientAttendance
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="client_id", nullable=false)
    private Client client;
    @ManyToOne
    @JoinColumn(name="meeting_id", nullable=false)
    private Meeting meeting;
    @Column(name="attendance_type_enum", nullable=false)
    private Integer attendanceTypeId;
    static final long serialVersionUID = 1898493969297744091L;

    protected ClientAttendance() {
    }

    public static ClientAttendance createClientAttendance(Client client, Meeting meeting, Integer attendanceTypeId) {
        return new ClientAttendance(client, meeting, attendanceTypeId);
    }

    private ClientAttendance(Client client, Meeting meeting, Integer attendanceTypeId) {
        this.client = client;
        this.meeting = meeting;
        this.attendanceTypeId = attendanceTypeId;
    }

    public Long clientId() {
        return (Long)this._persistence_get_client().getId();
    }

    public void updateAttendanceTypeId(Integer attendanceTypeId) {
        this._persistence_set_attendanceTypeId(attendanceTypeId);
    }

    public Integer getAttendanceTypeId() {
        return this._persistence_get_attendanceTypeId();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ClientAttendance();
    }

    public Object _persistence_get(String string) {
        if (string == "attendanceTypeId") {
            return this.attendanceTypeId;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "meeting") {
            return this.meeting;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "attendanceTypeId") {
            this.attendanceTypeId = (Integer)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "meeting") {
            this.meeting = (Meeting)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_attendanceTypeId() {
        this._persistence_checkFetched("attendanceTypeId");
        return this.attendanceTypeId;
    }

    public void _persistence_set_attendanceTypeId(Integer n) {
        this._persistence_checkFetchedForSet("attendanceTypeId");
        this._persistence_propertyChange("attendanceTypeId", (Object)this.attendanceTypeId, (Object)n);
        this.attendanceTypeId = n;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public Meeting _persistence_get_meeting() {
        this._persistence_checkFetched("meeting");
        return this.meeting;
    }

    public void _persistence_set_meeting(Meeting meeting) {
        this._persistence_checkFetchedForSet("meeting");
        this._persistence_propertyChange("meeting", (Object)this.meeting, (Object)meeting);
        this.meeting = meeting;
    }
}

