/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.AdvancedPaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.service.InterestRefundService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.starter.AdvancedPaymentScheduleTransactionProcessorCondition;
import org.apache.fineract.portfolio.loanproduct.calc.EMICalculator;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Conditional(value={AdvancedPaymentScheduleTransactionProcessorCondition.class})
@Service
public class ProgressiveLoanInterestRefundServiceImpl
implements InterestRefundService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressiveLoanInterestRefundServiceImpl.class);
    private final EMICalculator emiCalculator;
    private final LoanAssembler loanAssembler;
    private final LoanScheduleService loanScheduleService;
    private final LoanUtilService loanUtilService;

    private static void simulateRepaymentForDisbursements(LoanTransaction lt, AtomicReference<BigDecimal> refundFinal, List<LoanTransaction> collect) {
        collect.add(new LoanTransaction(lt.getLoan(), lt.getLoan().getOffice(), lt.getTypeOf().getValue(), lt.getDateOf(), lt.getAmount(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, null, null));
        if (lt.getTypeOf().isDisbursement() && MathUtil.isGreaterThanZero((BigDecimal)refundFinal.get())) {
            if (lt.getAmount().compareTo(refundFinal.get()) <= 0) {
                collect.add(new LoanTransaction(lt.getLoan(), lt.getLoan().getOffice(), LoanTransactionType.REPAYMENT.getValue(), lt.getDateOf(), lt.getAmount(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, null, null));
                refundFinal.set(refundFinal.get().subtract(lt.getAmount()));
            } else {
                collect.add(new LoanTransaction(lt.getLoan(), lt.getLoan().getOffice(), LoanTransactionType.REPAYMENT.getValue(), lt.getDateOf(), refundFinal.get(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, null, null));
                refundFinal.set(BigDecimal.ZERO);
            }
        }
    }

    private Money recalculateTotalInterest(AdvancedPaymentScheduleTransactionProcessor processor, Loan loan, LocalDate relatedRefundTransactionDate, List<LoanTransaction> transactionsToReprocess) {
        ArrayList<LoanRepaymentScheduleInstallment> installmentsToReprocess = new ArrayList<LoanRepaymentScheduleInstallment>(loan.getRepaymentScheduleInstallments().stream().filter(i -> !i.isReAged() && !i.isAdditional()).toList());
        if (loan.isProgressiveSchedule() && loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy()) {
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        Pair reprocessResult = processor.reprocessProgressiveLoanTransactions(loan.getDisbursementDate(), relatedRefundTransactionDate, transactionsToReprocess, loan.getCurrency(), installmentsToReprocess, loan.getActiveCharges());
        loan.getLoanTransactions().addAll(((ChangedTransactionDetail)reprocessResult.getLeft()).getCurrentTransactionToOldId().keySet());
        ProgressiveLoanInterestScheduleModel modelAfter = (ProgressiveLoanInterestScheduleModel)reprocessResult.getRight();
        return this.emiCalculator.getSumOfDueInterestsOnDate(modelAfter, relatedRefundTransactionDate);
    }

    public boolean canHandle(Loan loan) {
        String s = loan.getTransactionProcessingStrategyCode();
        return "Advanced payment allocation strategy".equalsIgnoreCase(s) || "advanced-payment-allocation-strategy".equalsIgnoreCase(s);
    }

    private boolean isTransactionNeededForInterestRefundCalculations(LoanTransaction lt) {
        return lt.isNotReversed() && !lt.isAccrualRelated() && !lt.isInterestRefund();
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public Money totalInterestByTransactions(LoanRepaymentScheduleTransactionProcessor processor, Long loanId, LocalDate relatedRefundTransactionDate, List<LoanTransaction> newTransactions, List<Long> oldTransactionIds) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (processor == null) {
            processor = loan.getTransactionProcessor();
        }
        if (!(processor instanceof AdvancedPaymentScheduleTransactionProcessor)) {
            throw new IllegalArgumentException("Wrong processor implementation. ProgressiveLoanInterestRefundServiceImpl requires AdvancedPaymentScheduleTransactionProcessor");
        }
        ArrayList transactionsToReprocess = new ArrayList();
        List interestRefundTypes = loan.getSupportedInterestRefundTransactionTypes();
        List<LoanTransaction> transactions = Stream.concat(loan.getLoanTransactions().stream().filter(lt -> this.isTransactionNeededForInterestRefundCalculations(lt) && oldTransactionIds.contains(lt.getId())), newTransactions.stream().filter(arg_0 -> this.isTransactionNeededForInterestRefundCalculations(arg_0)).map(LoanTransaction::copyTransactionProperties)).toList();
        AtomicReference<BigDecimal> refundFinal = new AtomicReference<BigDecimal>(transactions.stream().filter(lt -> interestRefundTypes.contains(lt.getTypeOf())).map(LoanTransaction::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        transactions.stream().filter(loanTransaction -> !interestRefundTypes.contains(loanTransaction.getTypeOf())).forEach(lt -> ProgressiveLoanInterestRefundServiceImpl.simulateRepaymentForDisbursements((LoanTransaction)lt, (AtomicReference)refundFinal, (List)transactionsToReprocess));
        return this.recalculateTotalInterest((AdvancedPaymentScheduleTransactionProcessor)processor, loan, relatedRefundTransactionDate, transactionsToReprocess);
    }

    public Money getTotalInterestRefunded(List<LoanTransaction> loanTransactions, MonetaryCurrency currency, MathContext mc) {
        BigDecimal totalInterestRefunded = loanTransactions.stream().filter(LoanTransaction::isNotReversed).filter(LoanTransaction::isInterestRefund).map(LoanTransaction::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return Money.of((MonetaryCurrency)currency, (BigDecimal)totalInterestRefunded, (MathContext)mc);
    }

    @Generated
    public ProgressiveLoanInterestRefundServiceImpl(EMICalculator emiCalculator, LoanAssembler loanAssembler, LoanScheduleService loanScheduleService, LoanUtilService loanUtilService) {
        this.emiCalculator = emiCalculator;
        this.loanAssembler = loanAssembler;
        this.loanScheduleService = loanScheduleService;
        this.loanUtilService = loanUtilService;
    }
}

