/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.calendar.data.CalendarHistoryDataWrapper;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarHistory;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.floatingrates.data.FloatingRateDTO;
import org.apache.fineract.portfolio.floatingrates.exception.FloatingRateNotFoundException;
import org.apache.fineract.portfolio.floatingrates.service.FloatingRatesReadPlatformService;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGeneratorFactory;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRelatedDetail;

public class LoanUtilService {
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final HolidayRepository holidayRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final LoanScheduleGeneratorFactory loanScheduleFactory;
    private final FloatingRatesReadPlatformService floatingRatesReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;

    public ScheduleGeneratorDTO buildScheduleGeneratorDTO(Loan loan, LocalDate recalculateFrom) {
        HolidayDetailDTO holidayDetailDTO = null;
        return this.buildScheduleGeneratorDTO(loan, recalculateFrom, holidayDetailDTO);
    }

    public ScheduleGeneratorDTO buildScheduleGeneratorDTO(Loan loan, LocalDate recalculateFrom, HolidayDetailDTO holidayDetailDTO) {
        HolidayDetailDTO holidayDetails = holidayDetailDTO;
        if (holidayDetailDTO == null) {
            holidayDetails = this.constructHolidayDTO(loan);
        }
        MonetaryCurrency currency = loan.getCurrency();
        ApplicationCurrency applicationCurrency = this.applicationCurrencyRepository.findOneWithNotFoundDetection(currency);
        CalendarInstance calendarInstance = this.calendarInstanceRepository.findCalendarInstaneByEntityId((Long)loan.getId(), CalendarEntityType.LOANS.getValue());
        Calendar calendar = null;
        CalendarHistoryDataWrapper calendarHistoryDataWrapper = null;
        if (calendarInstance != null) {
            calendar = calendarInstance.getCalendar();
            Set calendarHistory = calendar.getCalendarHistory();
            calendarHistoryDataWrapper = new CalendarHistoryDataWrapper(calendarHistory);
        }
        LocalDate calculatedRepaymentsStartingFromDate = this.getCalculatedRepaymentsStartingFromDate(loan.getDisbursementDate(), loan, calendarInstance, calendarHistoryDataWrapper);
        CalendarInstance restCalendarInstance = null;
        CalendarInstance compoundingCalendarInstance = null;
        Long overdurPenaltyWaitPeriod = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            restCalendarInstance = this.calendarInstanceRepository.findCalendarInstaneByEntityId(loan.loanInterestRecalculationDetailId(), CalendarEntityType.LOAN_RECALCULATION_REST_DETAIL.getValue());
            compoundingCalendarInstance = this.calendarInstanceRepository.findCalendarInstaneByEntityId(loan.loanInterestRecalculationDetailId(), CalendarEntityType.LOAN_RECALCULATION_COMPOUNDING_DETAIL.getValue());
            overdurPenaltyWaitPeriod = this.configurationDomainService.retrievePenaltyWaitPeriod();
        }
        Boolean isInterestChargedFromDateAsDisbursementDateEnabled = this.configurationDomainService.isInterestChargedFromDateSameAsDisbursementDate();
        FloatingRateDTO floatingRateDTO = this.constructFloatingRateDTO(loan);
        Boolean isSkipRepaymentOnFirstMonth = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled && (isSkipRepaymentOnFirstMonth = this.isLoanRepaymentsSyncWithMeeting(loan.group(), calendar)).booleanValue()) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        Boolean isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled = this.configurationDomainService.isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled();
        boolean isFirstRepaymentDateAllowedOnHoliday = this.configurationDomainService.isFirstRepaymentDateAfterRescheduleAllowedOnHoliday();
        boolean isInterestToBeRecoveredFirstWhenGreaterThanEMI = this.configurationDomainService.isInterestToBeRecoveredFirstWhenGreaterThanEMI();
        boolean isPrincipalCompoundingDisabledForOverdueLoans = this.configurationDomainService.isPrincipalCompoundingDisabledForOverdueLoans();
        ScheduleGeneratorDTO scheduleGeneratorDTO = new ScheduleGeneratorDTO(this.loanScheduleFactory, applicationCurrency.toData(), calculatedRepaymentsStartingFromDate, holidayDetails, restCalendarInstance, compoundingCalendarInstance, recalculateFrom, overdurPenaltyWaitPeriod, floatingRateDTO, calendar, calendarHistoryDataWrapper, isInterestChargedFromDateAsDisbursementDateEnabled, numberOfDays, isSkipRepaymentOnFirstMonth.booleanValue(), isChangeEmiIfRepaymentDateSameAsDisbursementDateEnabled, isFirstRepaymentDateAllowedOnHoliday, isInterestToBeRecoveredFirstWhenGreaterThanEMI, isPrincipalCompoundingDisabledForOverdueLoans);
        return scheduleGeneratorDTO;
    }

    public Boolean isLoanRepaymentsSyncWithMeeting(Group group, Calendar calendar) {
        Boolean isSkipRepaymentOnFirstMonth = false;
        Long entityId = null;
        Long entityTypeId = null;
        if (group != null) {
            if (group.getParent() != null) {
                entityId = (Long)group.getParent().getId();
                entityTypeId = CalendarEntityType.CENTERS.getValue().longValue();
            } else {
                entityId = (Long)group.getId();
                entityTypeId = CalendarEntityType.GROUPS.getValue().longValue();
            }
        }
        if (entityId == null || calendar == null) {
            return isSkipRepaymentOnFirstMonth;
        }
        isSkipRepaymentOnFirstMonth = this.calendarReadPlatformService.isCalendarAssociatedWithEntity(entityId, (Long)calendar.getId(), entityTypeId);
        return isSkipRepaymentOnFirstMonth;
    }

    public LocalDate getCalculatedRepaymentsStartingFromDate(Loan loan) {
        CalendarInstance calendarInstance = this.calendarInstanceRepository.findCalendarInstaneByEntityId((Long)loan.getId(), CalendarEntityType.LOANS.getValue());
        CalendarHistoryDataWrapper calendarHistoryDataWrapper = null;
        return this.getCalculatedRepaymentsStartingFromDate(loan.getDisbursementDate(), loan, calendarInstance, calendarHistoryDataWrapper);
    }

    private HolidayDetailDTO constructHolidayDTO(Loan loan) {
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), loan.getDisbursementDate(), HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
        HolidayDetailDTO holidayDetailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays, allowTransactionsOnHoliday, allowTransactionsOnNonWorkingDay);
        return holidayDetailDTO;
    }

    public HolidayDetailDTO constructHolidayDTO(Long officeId, LocalDate localDate) {
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, localDate, HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
        return new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays, allowTransactionsOnHoliday, allowTransactionsOnNonWorkingDay);
    }

    private FloatingRateDTO constructFloatingRateDTO(Loan loan) {
        FloatingRateDTO floatingRateDTO = null;
        if (loan.loanProduct().isLinkedToFloatingInterestRate()) {
            boolean isFloatingInterestRate = loan.getIsFloatingInterestRate();
            BigDecimal interestRateDiff = loan.getInterestRateDifferential();
            List baseLendingRatePeriods = null;
            try {
                baseLendingRatePeriods = this.floatingRatesReadPlatformService.retrieveBaseLendingRate().getRatePeriods();
            }
            catch (FloatingRateNotFoundException floatingRateNotFoundException) {
                // empty catch block
            }
            floatingRateDTO = new FloatingRateDTO(isFloatingInterestRate, loan.getDisbursementDate(), interestRateDiff, (Collection)baseLendingRatePeriods);
        }
        return floatingRateDTO;
    }

    private LocalDate getCalculatedRepaymentsStartingFromDate(LocalDate actualDisbursementDate, Loan loan, CalendarInstance calendarInstance, CalendarHistoryDataWrapper calendarHistoryDataWrapper) {
        Calendar calendar = calendarInstance == null ? null : calendarInstance.getCalendar();
        return this.calculateRepaymentStartingFromDate(actualDisbursementDate, loan, calendar, calendarHistoryDataWrapper);
    }

    public LocalDate getCalculatedRepaymentsStartingFromDate(LocalDate actualDisbursementDate, Loan loan, Calendar calendar) {
        CalendarHistoryDataWrapper calendarHistoryDataWrapper = null;
        if (calendar == null) {
            return this.getCalculatedRepaymentsStartingFromDate(loan);
        }
        return this.calculateRepaymentStartingFromDate(actualDisbursementDate, loan, calendar, calendarHistoryDataWrapper);
    }

    private LocalDate calculateRepaymentStartingFromDate(LocalDate actualDisbursementDate, Loan loan, Calendar calendar, CalendarHistoryDataWrapper calendarHistoryDataWrapper) {
        LocalDate calculatedRepaymentsStartingFromDate = loan.getExpectedFirstRepaymentOnDate();
        if (calendar != null) {
            LoanProductRelatedDetail repaymentScheduleDetails;
            if (calculatedRepaymentsStartingFromDate == null && !calendar.getCalendarHistory().isEmpty() && calendarHistoryDataWrapper != null) {
                calculatedRepaymentsStartingFromDate = this.generateCalculatedRepaymentStartDate(calendarHistoryDataWrapper, actualDisbursementDate, loan);
                return calculatedRepaymentsStartingFromDate;
            }
            if (calculatedRepaymentsStartingFromDate == null && (repaymentScheduleDetails = loan.repaymentScheduleDetail()) != null) {
                Integer repayEvery = repaymentScheduleDetails.getRepayEvery();
                String frequency = CalendarUtils.getMeetingFrequencyFromPeriodFrequencyType((PeriodFrequencyType)repaymentScheduleDetails.getRepaymentPeriodFrequencyType());
                Boolean isSkipRepaymentOnFirstMonth = false;
                Integer numberOfDays = 0;
                boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
                if (isSkipRepaymentOnFirstMonthEnabled) {
                    numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
                    isSkipRepaymentOnFirstMonth = this.isLoanRepaymentsSyncWithMeeting(loan.group(), calendar);
                }
                calculatedRepaymentsStartingFromDate = CalendarUtils.getFirstRepaymentMeetingDate((Calendar)calendar, (LocalDate)actualDisbursementDate, (Integer)repayEvery, (String)frequency, (boolean)isSkipRepaymentOnFirstMonth, (Integer)numberOfDays);
            }
        }
        return calculatedRepaymentsStartingFromDate;
    }

    private LocalDate generateCalculatedRepaymentStartDate(CalendarHistoryDataWrapper calendarHistoryDataWrapper, LocalDate actualDisbursementDate, Loan loan) {
        LoanProductRelatedDetail repaymentScheduleDetails = loan.repaymentScheduleDetail();
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        LocalDate calculatedRepaymentsStartingFromDate = null;
        List historyList = calendarHistoryDataWrapper.getCalendarHistoryList();
        if (historyList != null && historyList.size() > 0 && repaymentScheduleDetails != null) {
            Integer repayEvery = repaymentScheduleDetails.getRepayEvery();
            String frequency = CalendarUtils.getMeetingFrequencyFromPeriodFrequencyType((PeriodFrequencyType)repaymentScheduleDetails.getRepaymentPeriodFrequencyType());
            Boolean isSkipRepaymentOnFirstMonth = false;
            Integer numberOfDays = 0;
            boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
            if (isSkipRepaymentOnFirstMonthEnabled) {
                numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
                isSkipRepaymentOnFirstMonth = this.isLoanRepaymentsSyncWithMeeting(loan.group(), ((CalendarHistory)historyList.get(0)).getCalendar());
            }
            calculatedRepaymentsStartingFromDate = CalendarUtils.getNextRepaymentMeetingDate((String)((CalendarHistory)historyList.get(0)).getRecurrence(), (LocalDate)((CalendarHistory)historyList.get(0)).getStartDate(), (LocalDate)actualDisbursementDate, (Integer)repayEvery, (String)frequency, (WorkingDays)workingDays, (boolean)isSkipRepaymentOnFirstMonth, (Integer)numberOfDays);
        }
        return calculatedRepaymentsStartingFromDate;
    }

    public void validateRepaymentTransactionType(LoanTransactionType repaymentTransactionType) {
        if (!repaymentTransactionType.isRepaymentType()) {
            throw new PlatformServiceUnavailableException("error.msg.repaymentTransactionType.provided.not.a.repayment.type", "Loan :" + repaymentTransactionType.getCode() + " Repayment Transaction Type provided is not a Repayment Type", new Object[]{repaymentTransactionType.getCode()});
        }
    }

    @Generated
    public LoanUtilService(ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, CalendarInstanceRepository calendarInstanceRepository, ConfigurationDomainService configurationDomainService, HolidayRepository holidayRepository, WorkingDaysRepositoryWrapper workingDaysRepository, LoanScheduleGeneratorFactory loanScheduleFactory, FloatingRatesReadPlatformService floatingRatesReadPlatformService, CalendarReadPlatformService calendarReadPlatformService) {
        this.applicationCurrencyRepository = applicationCurrencyRepository;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.configurationDomainService = configurationDomainService;
        this.holidayRepository = holidayRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.loanScheduleFactory = loanScheduleFactory;
        this.floatingRatesReadPlatformService = floatingRatesReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
    }
}

