/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionBalance;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.service.CommonLoanSummaryDataProvider;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CumulativeLoanSummaryDataProvider
extends CommonLoanSummaryDataProvider {
    public boolean accept(String loanProcessingStrategyCode) {
        return !loanProcessingStrategyCode.equalsIgnoreCase("advanced-payment-allocation-strategy");
    }

    public BigDecimal computeTotalUnpaidPayableNotDueInterestAmountOnActualPeriod(Loan loan, Collection<LoanSchedulePeriodData> periods, LocalDate businessDate, CurrencyData currency) {
        Optional<LoanSchedulePeriodData> optCurrentPeriod = periods.stream().filter(period -> !period.isDownPaymentPeriod() && period.getPeriod() != null && !businessDate.isBefore(period.getFromDate()) && businessDate.isBefore(period.getDueDate())).findFirst();
        if (optCurrentPeriod.isPresent()) {
            LoanSchedulePeriodData currentPeriod = optCurrentPeriod.get();
            long remainingDays = (long)currentPeriod.getDaysInPeriod().intValue() - DateUtils.getDifferenceInDays((LocalDate)currentPeriod.getFromDate(), (LocalDate)businessDate);
            return CumulativeLoanSummaryDataProvider.computeAccruedInterestTillDay((LoanSchedulePeriodData)currentPeriod, (long)remainingDays, (CurrencyData)currency);
        }
        return BigDecimal.ZERO;
    }

    public LoanSummaryData withTransactionAmountsSummary(Long loanId, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<LoanTransactionBalance> loanTransactionBalances) {
        Loan loan = null;
        return super.withTransactionAmountsSummary(loan, defaultSummaryData, repaymentSchedule, loanTransactionBalances);
    }

    private static BigDecimal computeAccruedInterestTillDay(LoanSchedulePeriodData period, long untilDay, CurrencyData currency) {
        Integer remainingDays = period.getDaysInPeriod();
        BigDecimal totalAccruedInterest = BigDecimal.ZERO;
        while ((long)remainingDays.intValue() > untilDay) {
            BigDecimal accruedInterest = period.getInterestDue().subtract(totalAccruedInterest).divide(BigDecimal.valueOf(remainingDays.intValue()), MoneyHelper.getMathContext());
            totalAccruedInterest = totalAccruedInterest.add(accruedInterest);
            Integer n = remainingDays;
            remainingDays = remainingDays - 1;
        }
        if (MathUtil.isLessThanZero((BigDecimal)(totalAccruedInterest = totalAccruedInterest.subtract(period.getInterestPaid()).subtract(period.getInterestWaived())))) {
            totalAccruedInterest = BigDecimal.ZERO;
        }
        return Money.of((CurrencyData)currency, (BigDecimal)totalAccruedInterest).getAmount();
    }
}

