/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionBalance;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.service.LoanSummaryDataProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CommonLoanSummaryDataProvider
implements LoanSummaryDataProvider {
    public LoanSummaryData withTransactionAmountsSummary(Loan loan, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<LoanTransactionBalance> loanTransactionBalances) {
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        BigDecimal totalMerchantRefund = BigDecimal.ZERO;
        BigDecimal totalMerchantRefundReversed = BigDecimal.ZERO;
        BigDecimal totalPayoutRefund = BigDecimal.ZERO;
        BigDecimal totalPayoutRefundReversed = BigDecimal.ZERO;
        BigDecimal totalGoodwillCredit = BigDecimal.ZERO;
        BigDecimal totalGoodwillCreditReversed = BigDecimal.ZERO;
        BigDecimal totalChargeAdjustment = BigDecimal.ZERO;
        BigDecimal totalChargeAdjustmentReversed = BigDecimal.ZERO;
        BigDecimal totalChargeback = BigDecimal.ZERO;
        BigDecimal totalCreditBalanceRefund = BigDecimal.ZERO;
        BigDecimal totalCreditBalanceRefundReversed = BigDecimal.ZERO;
        BigDecimal totalRepaymentTransaction = BigDecimal.ZERO;
        BigDecimal totalRepaymentTransactionReversed = BigDecimal.ZERO;
        BigDecimal totalInterestPaymentWaiver = BigDecimal.ZERO;
        BigDecimal totalInterestRefund = BigDecimal.ZERO;
        BigDecimal totalUnpaidPayableDueInterest = BigDecimal.ZERO;
        BigDecimal totalUnpaidPayableNotDueInterest = BigDecimal.ZERO;
        totalChargeAdjustment = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.CHARGE_ADJUSTMENT.getValue());
        totalChargeAdjustmentReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.CHARGE_ADJUSTMENT.getValue());
        totalChargeback = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.CHARGEBACK.getValue());
        totalCreditBalanceRefund = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.CREDIT_BALANCE_REFUND.getValue());
        totalCreditBalanceRefundReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.CREDIT_BALANCE_REFUND.getValue());
        totalGoodwillCredit = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.GOODWILL_CREDIT.getValue());
        totalGoodwillCreditReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.GOODWILL_CREDIT.getValue());
        totalInterestRefund = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.INTEREST_REFUND.getValue());
        totalInterestPaymentWaiver = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.INTEREST_PAYMENT_WAIVER.getValue());
        totalMerchantRefund = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.MERCHANT_ISSUED_REFUND.getValue());
        totalMerchantRefundReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.MERCHANT_ISSUED_REFUND.getValue());
        totalPayoutRefund = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.PAYOUT_REFUND.getValue());
        totalPayoutRefundReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.PAYOUT_REFUND.getValue());
        totalRepaymentTransaction = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.REPAYMENT.getValue()).add(CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceByType(loanTransactionBalances, (Integer)LoanTransactionType.DOWN_PAYMENT.getValue()));
        totalRepaymentTransactionReversed = CommonLoanSummaryDataProvider.fetchLoanTransactionBalanceReversedByType(loanTransactionBalances, (Integer)LoanTransactionType.REPAYMENT.getValue());
        if (repaymentSchedule != null) {
            totalUnpaidPayableDueInterest = this.computeTotalUnpaidPayableDueInterestAmount(repaymentSchedule.getPeriods(), businessDate);
            totalUnpaidPayableNotDueInterest = this.computeTotalUnpaidPayableNotDueInterestAmountOnActualPeriod(loan, repaymentSchedule.getPeriods(), businessDate, defaultSummaryData.getCurrency());
        }
        return LoanSummaryData.builder().currency(defaultSummaryData.getCurrency()).principalDisbursed(defaultSummaryData.getPrincipalDisbursed()).principalAdjustments(defaultSummaryData.getPrincipalAdjustments()).principalPaid(defaultSummaryData.getPrincipalPaid()).principalWrittenOff(defaultSummaryData.getPrincipalWrittenOff()).principalOutstanding(defaultSummaryData.getPrincipalOutstanding()).principalOverdue(defaultSummaryData.getPrincipalOverdue()).interestCharged(defaultSummaryData.getInterestCharged()).interestPaid(defaultSummaryData.getInterestPaid()).interestWaived(defaultSummaryData.getInterestWaived()).interestWrittenOff(defaultSummaryData.getInterestWrittenOff()).interestOutstanding(defaultSummaryData.getInterestOutstanding()).interestOverdue(defaultSummaryData.getInterestOverdue()).feeChargesCharged(defaultSummaryData.getFeeChargesCharged()).feeAdjustments(defaultSummaryData.getFeeAdjustments()).feeChargesDueAtDisbursementCharged(defaultSummaryData.getFeeChargesDueAtDisbursementCharged()).feeChargesPaid(defaultSummaryData.getFeeChargesPaid()).feeChargesWaived(defaultSummaryData.getFeeChargesWaived()).feeChargesWrittenOff(defaultSummaryData.getFeeChargesWrittenOff()).feeChargesOutstanding(defaultSummaryData.getFeeChargesOutstanding()).feeChargesOverdue(defaultSummaryData.getFeeChargesOverdue()).penaltyChargesCharged(defaultSummaryData.getPenaltyChargesCharged()).penaltyAdjustments(defaultSummaryData.getPenaltyAdjustments()).penaltyChargesPaid(defaultSummaryData.getPenaltyChargesPaid()).penaltyChargesWaived(defaultSummaryData.getPenaltyChargesWaived()).penaltyChargesWrittenOff(defaultSummaryData.getPenaltyChargesWrittenOff()).penaltyChargesOutstanding(defaultSummaryData.getPenaltyChargesOutstanding()).penaltyChargesOverdue(defaultSummaryData.getPenaltyChargesOverdue()).totalExpectedRepayment(defaultSummaryData.getTotalExpectedRepayment()).totalRepayment(defaultSummaryData.getTotalRepayment()).totalExpectedCostOfLoan(defaultSummaryData.getTotalExpectedCostOfLoan()).totalCostOfLoan(defaultSummaryData.getTotalCostOfLoan()).totalWaived(defaultSummaryData.getTotalWaived()).totalWrittenOff(defaultSummaryData.getTotalWrittenOff()).totalOutstanding(defaultSummaryData.getTotalOutstanding()).totalOverdue(defaultSummaryData.getTotalOverdue()).overdueSinceDate(defaultSummaryData.getOverdueSinceDate()).writeoffReasonId(defaultSummaryData.getWriteoffReasonId()).writeoffReason(defaultSummaryData.getWriteoffReason()).totalRecovered(defaultSummaryData.getTotalRecovered()).chargeOffReasonId(defaultSummaryData.getChargeOffReasonId()).chargeOffReason(defaultSummaryData.getChargeOffReason()).totalMerchantRefund(totalMerchantRefund).totalMerchantRefundReversed(totalMerchantRefundReversed).totalPayoutRefund(totalPayoutRefund).totalPayoutRefundReversed(totalPayoutRefundReversed).totalGoodwillCredit(totalGoodwillCredit).totalGoodwillCreditReversed(totalGoodwillCreditReversed).totalChargeAdjustment(totalChargeAdjustment).totalChargeAdjustmentReversed(totalChargeAdjustmentReversed).totalChargeback(totalChargeback).totalCreditBalanceRefund(totalCreditBalanceRefund).totalCreditBalanceRefundReversed(totalCreditBalanceRefundReversed).totalRepaymentTransaction(totalRepaymentTransaction).totalRepaymentTransactionReversed(totalRepaymentTransactionReversed).totalInterestPaymentWaiver(totalInterestPaymentWaiver).totalUnpaidPayableDueInterest(totalUnpaidPayableDueInterest).totalUnpaidPayableNotDueInterest(totalUnpaidPayableNotDueInterest).totalInterestRefund(totalInterestRefund).build();
    }

    private static BigDecimal fetchLoanTransactionBalanceByType(Collection<LoanTransactionBalance> loanTransactionBalances, Integer transactionType) {
        Optional<LoanTransactionBalance> optLoanTransactionBalance = loanTransactionBalances.stream().filter(balance -> balance.getTransactionType().equals(transactionType) && !balance.isReversed()).findFirst();
        return optLoanTransactionBalance.isPresent() ? optLoanTransactionBalance.get().getAmount() : BigDecimal.ZERO;
    }

    private static BigDecimal fetchLoanTransactionBalanceReversedByType(Collection<LoanTransactionBalance> loanTransactionBalances, Integer transactionType) {
        Optional<LoanTransactionBalance> optLoanTransactionBalance = loanTransactionBalances.stream().filter(balance -> balance.getTransactionType().equals(transactionType) && balance.isReversed() && balance.isManuallyAdjustedOrReversed()).findFirst();
        return optLoanTransactionBalance.isPresent() ? optLoanTransactionBalance.get().getAmount() : BigDecimal.ZERO;
    }

    public BigDecimal computeTotalUnpaidPayableDueInterestAmount(Collection<LoanSchedulePeriodData> periods, LocalDate businessDate) {
        return periods.stream().filter(period -> !period.isDownPaymentPeriod() && !businessDate.isBefore(period.getDueDate())).map(LoanSchedulePeriodData::getInterestOutstanding).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public LoanSummaryData withOnlyCurrencyData(CurrencyData currencyData) {
        return LoanSummaryData.builder().currency(currencyData).build();
    }
}

