/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class LoanScheduleValidator {
    static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("id", "clientId", "groupId", "loanType", "calendarId", "productId", "accountNo", "externalId", "fundId", "loanOfficerId", "loanPurposeId", "transactionProcessingStrategyCode", "principal", "inArrearsTolerance", "interestRatePerPeriod", "repaymentEvery", "numberOfRepayments", "loanTermFrequency", "loanTermFrequencyType", "repaymentFrequencyType", "amortizationType", "interestType", "interestCalculationPeriodType", "allowPartialPeriodInterestCalcualtion", "interestRateFrequencyType", "expectedDisbursementDate", "repaymentsStartingFromDate", "graceOnPrincipalPayment", "graceOnInterestPayment", "graceOnInterestCharged", "interestChargedFromDate", "submittedOnDate", "submittedOnNote", "locale", "dateFormat", "charges", "collateral", "syncDisbursementWithMeeting", "linkAccountId", "disbursementData", "fixedEmiAmount", "maxOutstandingLoanBalance", "graceOnArrearsAgeing", "createStandingInstructionAtDisbursement", "isFloatingInterestRate", "interestRateDifferential", "repaymentFrequencyNthDayType", "repaymentFrequencyDayOfWeekType", "isTopup", "loanIdToClose", "datatables", "isEqualAmortization", "rates", "daysInYearType", "fixedPrincipalPercentagePerInstallment", "fixedLength", "enableInstallmentLevelDelinquency", "enableDownPayment", "disbursedAmountPercentageForDownPayment", "enableAutoRepaymentForDownPayment", "interestRecognitionOnDisbursementDate"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public LoanScheduleValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String loanTermFrequencyParameterName = "loanTermFrequency";
        Integer loanTermFrequency = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequency", element);
        String loanTermFrequencyTypeParameterName = "loanTermFrequencyType";
        Integer loanTermFrequencyType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("loanTermFrequencyType", element);
        String numberOfRepaymentsParameterName = "numberOfRepayments";
        Integer numberOfRepayments = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("numberOfRepayments", element);
        String repaymentEveryParameterName = "repaymentEvery";
        Integer repaymentEvery = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentEvery", element);
        String repaymentEveryFrequencyTypeParameterName = "repaymentFrequencyType";
        Integer repaymentEveryType = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("repaymentFrequencyType", element);
        this.validateSelectedPeriodFrequencyTypeIsTheSame(dataValidationErrors, loanTermFrequency, loanTermFrequencyType, numberOfRepayments, repaymentEvery, repaymentEveryType);
        String expectedDisbursementDateParameterName = "expectedDisbursementDate";
        LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", element);
        LocalDate repaymentsStartingFromDate = null;
        String repaymentsStartingFromDateParameterName = "repaymentsStartingFromDate";
        if (this.fromApiJsonHelper.parameterExists("repaymentsStartingFromDate", element)) {
            repaymentsStartingFromDate = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsStartingFromDate", element);
        }
        this.validateRepaymentsStartingFromDateIsAfterDisbursementDate(dataValidationErrors, expectedDisbursementDate, repaymentsStartingFromDate);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateSelectedPeriodFrequencyTypeIsTheSame(List<ApiParameterError> dataValidationErrors, Integer loanTermFrequency, Integer loanTermFrequencyType, Integer numberOfRepayments, Integer repaymentEvery, Integer repaymentEveryType) {
        if (loanTermFrequencyType != null && !loanTermFrequencyType.equals(repaymentEveryType)) {
            ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.loanTermFrequencyType.not.the.same.as.repaymentFrequencyType", (String)"The parameters loanTermFrequencyType and repaymentFrequencyType must be the same.", (String)"loanTermFrequencyType", (Object[])new Object[]{loanTermFrequencyType, repaymentEveryType});
            dataValidationErrors.add(error);
        } else if (loanTermFrequency != null && repaymentEvery != null && numberOfRepayments != null) {
            int suggestsedLoanTerm = repaymentEvery * numberOfRepayments;
            if (loanTermFrequency < suggestsedLoanTerm) {
                ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.loanTermFrequency.less.than.repayment.structure.suggests", (String)"The parameter loanTermFrequency is less than the suggest loan term as indicated by numberOfRepayments and repaymentEvery.", (String)"loanTermFrequency", (Object[])new Object[]{loanTermFrequency, numberOfRepayments, repaymentEvery});
                dataValidationErrors.add(error);
            } else if (loanTermFrequency > suggestsedLoanTerm) {
                ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.loanTermFrequency.greater.than.repayment.structure.suggests", (String)"The parameter loanTermFrequency is greater than the suggested loan term as indicated by numberOfRepayments and repaymentEvery.", (String)"loanTermFrequency", (Object[])new Object[]{loanTermFrequency, numberOfRepayments, repaymentEvery});
                dataValidationErrors.add(error);
            }
        }
    }

    private void validateRepaymentsStartingFromDateIsAfterDisbursementDate(List<ApiParameterError> dataValidationErrors, LocalDate expectedDisbursementDate, LocalDate repaymentsStartingFromDate) {
        if (repaymentsStartingFromDate != null && DateUtils.isAfter((LocalDate)expectedDisbursementDate, (LocalDate)repaymentsStartingFromDate)) {
            ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.loan.expectedDisbursementDate.cannot.be.after.first.repayment.date", (String)"The parameter expectedDisbursementDate has a date which falls after the date for repaymentsStartingFromDate.", (String)"expectedDisbursementDate", (Object[])new Object[]{expectedDisbursementDate, repaymentsStartingFromDate});
            dataValidationErrors.add(error);
        }
    }

    public void validateDownPaymentAttribute(boolean isDownPaymentEnabledInLoanProduct, JsonElement element) {
        Boolean inputIsDownPaymentEnabled = this.fromApiJsonHelper.extractBooleanNamed("enableDownPayment", element);
        Boolean inputIsAutoDownPaymentEnabled = this.fromApiJsonHelper.extractBooleanNamed("enableAutoRepaymentForDownPayment", element);
        BigDecimal disbursedAmountPercentageDownPayment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("disbursedAmountPercentageForDownPayment", element);
        if (!isDownPaymentEnabledInLoanProduct && (Boolean.TRUE.equals(inputIsDownPaymentEnabled) || Boolean.TRUE.equals(inputIsAutoDownPaymentEnabled) || disbursedAmountPercentageDownPayment != null)) {
            throw new GeneralPlatformDomainRuleException("error.msg.downpayment.is.not.enabled.in.loan.product", "The Loan can not override the downpayment properties because in the Loan Product the downpayment is disabled", new Object[]{inputIsDownPaymentEnabled, inputIsAutoDownPaymentEnabled});
        }
    }
}

