/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.generateloanlossprovisioning;

import java.time.LocalDate;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.accounting.provisioning.exception.ProvisioningEntryAlreadyCreatedException;
import org.apache.fineract.accounting.provisioning.service.ProvisioningEntriesWritePlatformService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class GenerateLoanlossProvisioningTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateLoanlossProvisioningTasklet.class);
    private final ProvisioningCriteriaReadPlatformService provisioningCriteriaReadPlatformService;
    private final ProvisioningEntriesWritePlatformService provisioningEntriesWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        LocalDate currentDate = DateUtils.getBusinessLocalDate();
        boolean addJournalEntries = true;
        try {
            Collection criteriaCollection = this.provisioningCriteriaReadPlatformService.retrieveAllProvisioningCriterias();
            if (CollectionUtils.isNotEmpty((Collection)criteriaCollection)) {
                this.provisioningEntriesWritePlatformService.createProvisioningEntry(currentDate, addJournalEntries);
            }
        }
        catch (ProvisioningEntryAlreadyCreatedException e) {
            log.error("Provisioning entry already created", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Problem occurred when generating provisioning entries", (Throwable)e);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public GenerateLoanlossProvisioningTasklet(ProvisioningCriteriaReadPlatformService provisioningCriteriaReadPlatformService, ProvisioningEntriesWritePlatformService provisioningEntriesWritePlatformService) {
        this.provisioningCriteriaReadPlatformService = provisioningCriteriaReadPlatformService;
        this.provisioningEntriesWritePlatformService = provisioningEntriesWritePlatformService;
    }
}

