/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.addaccrualentries;

import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.MultiException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class AddAccrualEntriesTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddAccrualEntriesTasklet.class);
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try {
            this.addAccruals(DateUtils.getBusinessLocalDate());
        }
        catch (MultiException e) {
            throw new JobExecutionException(e);
        }
        return RepeatStatus.FINISHED;
    }

    private void addAccruals(LocalDate tilldate) throws MultiException {
        this.loanAccrualsProcessingService.addAccruals(tilldate);
    }

    @Generated
    public AddAccrualEntriesTasklet(LoanReadPlatformService loanReadPlatformService, LoanAccrualsProcessingService loanAccrualsProcessingService) {
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
    }
}

