/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.accrualactivityposting;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccrualActivityRepository;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualActivityProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class AccrualActivityPostingTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccrualActivityPostingTasklet.class);
    private final LoanAccrualActivityProcessingService loanAccrualActivityProcessingService;
    private final LoanAccrualActivityRepository loanAccrualActivityRepository;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        LocalDate yesterday = DateUtils.getBusinessLocalDate().minusDays(1L);
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Set loanAccounts = this.loanAccrualActivityRepository.fetchLoanIdsForAccrualActivityPosting(yesterday);
        for (Long accountId : loanAccounts) {
            try {
                this.loanAccrualActivityProcessingService.makeAccrualActivityTransaction(accountId, yesterday);
            }
            catch (Exception e) {
                log.error("Failed to add accrual activity transaction for loan {}", (Object)accountId, (Object)e);
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public AccrualActivityPostingTasklet(LoanAccrualActivityProcessingService loanAccrualActivityProcessingService, LoanAccrualActivityRepository loanAccrualActivityRepository) {
        this.loanAccrualActivityProcessingService = loanAccrualActivityProcessingService;
        this.loanAccrualActivityRepository = loanAccrualActivityRepository;
    }
}

