/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.service;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.GuarantorData;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.ObligeeData;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GuarantorReadPlatformServiceImpl
implements GuarantorReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ClientReadPlatformService clientReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final LoanRepositoryWrapper loanRepositoryWrapper;

    @Autowired
    public GuarantorReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, StaffReadPlatformService staffReadPlatformService, LoanRepositoryWrapper loanRepositoryWrapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
    }

    public List<GuarantorData> retrieveGuarantorsForValidLoan(Long loanId) {
        this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        return this.retrieveGuarantorsForLoan(loanId);
    }

    public List<GuarantorData> retrieveGuarantorsForLoan(Long loanId) {
        GuarantorMapper rm = new GuarantorMapper();
        String sql = "select " + rm.schema();
        String finalSql = sql = sql + " where loan_id = ?  group by g.id,gfd.id, gt.id, sa.id, oht.id, cv.id order by g.id";
        List guarantorDatas = this.jdbcTemplate.query(con -> {
            PreparedStatement preparedStatement = con.prepareStatement(finalSql, 1005, 1008);
            preparedStatement.setInt(1, AccountAssociationType.GUARANTOR_ACCOUNT_ASSOCIATION.getValue());
            preparedStatement.setLong(2, loanId);
            return preparedStatement;
        }, (RowMapper)rm);
        ArrayList<GuarantorData> mergedGuarantorDatas = new ArrayList<GuarantorData>();
        for (GuarantorData guarantorData : guarantorDatas) {
            mergedGuarantorDatas.add(this.mergeDetailsForClientOrStaffGuarantor(guarantorData));
        }
        return mergedGuarantorDatas;
    }

    public GuarantorData retrieveGuarantor(Long loanId, Long guarantorId) {
        GuarantorMapper rm = new GuarantorMapper();
        String sql = "select " + rm.schema();
        String finalSql = sql = sql + " where g.loan_id = ? and g.id = ? group by g.id, gfd.id, gt.id, sa.id, oht.id, cv.id order by g.id";
        GuarantorData guarantorData = (GuarantorData)this.jdbcTemplate.query(con -> {
            PreparedStatement preparedStatement = con.prepareStatement(finalSql, 1005, 1008);
            preparedStatement.setInt(1, AccountAssociationType.GUARANTOR_ACCOUNT_ASSOCIATION.getValue());
            preparedStatement.setLong(2, loanId);
            preparedStatement.setLong(3, guarantorId);
            return preparedStatement;
        }, (RowMapper)rm).get(0);
        return this.mergeDetailsForClientOrStaffGuarantor(guarantorData);
    }

    private GuarantorData mergeDetailsForClientOrStaffGuarantor(GuarantorData guarantorData) {
        if (guarantorData.isExistingClient()) {
            ClientData clientData = this.clientReadPlatformService.retrieveOne(guarantorData.getEntityId());
            return GuarantorData.mergeClientData((ClientData)clientData, (GuarantorData)guarantorData);
        }
        if (guarantorData.isStaffMember()) {
            StaffData staffData = this.staffReadPlatformService.retrieveStaff(guarantorData.getEntityId());
            return GuarantorData.mergeStaffData((StaffData)staffData, (GuarantorData)guarantorData);
        }
        return guarantorData;
    }

    public List<ObligeeData> retrieveObligeeDetails(Long clientId) {
        ObligeeMapper rm = new ObligeeMapper();
        String sql = rm.schema();
        try {
            return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

