/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingDetails;
import org.apache.fineract.portfolio.savings.domain.DepositAccountOnHoldTransaction;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_guarantor_transaction")
public class GuarantorFundingTransaction
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="guarantor_fund_detail_id", nullable=false)
    private GuarantorFundingDetails guarantorFundingDetails;
    @ManyToOne
    @JoinColumn(name="loan_transaction_id", nullable=true)
    private LoanTransaction loanTransaction;
    @OneToOne
    @JoinColumn(name="deposit_on_hold_transaction_id", nullable=false)
    private DepositAccountOnHoldTransaction depositAccountOnHoldTransaction;
    @Column(name="is_reversed", nullable=false)
    private boolean reversed;
    static final long serialVersionUID = 8586217348169522684L;

    protected GuarantorFundingTransaction() {
    }

    public GuarantorFundingTransaction(GuarantorFundingDetails guarantorFundingDetails, LoanTransaction loanTransaction, DepositAccountOnHoldTransaction depositAccountOnHoldTransaction) {
        this.depositAccountOnHoldTransaction = depositAccountOnHoldTransaction;
        this.guarantorFundingDetails = guarantorFundingDetails;
        this.loanTransaction = loanTransaction;
        this.reversed = false;
    }

    public void reverseTransaction() {
        if (!this._persistence_get_reversed()) {
            this._persistence_set_reversed(true);
            BigDecimal amountForReverse = this._persistence_get_depositAccountOnHoldTransaction().getAmount();
            this._persistence_get_depositAccountOnHoldTransaction().reverseTransaction();
            if (this._persistence_get_depositAccountOnHoldTransaction().getTransactionType().isRelease()) {
                this._persistence_get_guarantorFundingDetails().undoReleaseFunds(amountForReverse);
            }
        }
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new GuarantorFundingTransaction();
    }

    public Object _persistence_get(String string) {
        if (string == "guarantorFundingDetails") {
            return this.guarantorFundingDetails;
        }
        if (string == "depositAccountOnHoldTransaction") {
            return this.depositAccountOnHoldTransaction;
        }
        if (string == "reversed") {
            return this.reversed;
        }
        if (string == "loanTransaction") {
            return this.loanTransaction;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "guarantorFundingDetails") {
            this.guarantorFundingDetails = (GuarantorFundingDetails)object;
            return;
        }
        if (string == "depositAccountOnHoldTransaction") {
            this.depositAccountOnHoldTransaction = (DepositAccountOnHoldTransaction)object;
            return;
        }
        if (string == "reversed") {
            this.reversed = (Boolean)object;
            return;
        }
        if (string == "loanTransaction") {
            this.loanTransaction = (LoanTransaction)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public GuarantorFundingDetails _persistence_get_guarantorFundingDetails() {
        this._persistence_checkFetched("guarantorFundingDetails");
        return this.guarantorFundingDetails;
    }

    public void _persistence_set_guarantorFundingDetails(GuarantorFundingDetails guarantorFundingDetails) {
        this._persistence_checkFetchedForSet("guarantorFundingDetails");
        this._persistence_propertyChange("guarantorFundingDetails", (Object)this.guarantorFundingDetails, (Object)guarantorFundingDetails);
        this.guarantorFundingDetails = guarantorFundingDetails;
    }

    public DepositAccountOnHoldTransaction _persistence_get_depositAccountOnHoldTransaction() {
        this._persistence_checkFetched("depositAccountOnHoldTransaction");
        return this.depositAccountOnHoldTransaction;
    }

    public void _persistence_set_depositAccountOnHoldTransaction(DepositAccountOnHoldTransaction depositAccountOnHoldTransaction) {
        this._persistence_checkFetchedForSet("depositAccountOnHoldTransaction");
        this._persistence_propertyChange("depositAccountOnHoldTransaction", (Object)this.depositAccountOnHoldTransaction, (Object)depositAccountOnHoldTransaction);
        this.depositAccountOnHoldTransaction = depositAccountOnHoldTransaction;
    }

    public boolean _persistence_get_reversed() {
        this._persistence_checkFetched("reversed");
        return this.reversed;
    }

    public void _persistence_set_reversed(boolean bl) {
        this._persistence_checkFetchedForSet("reversed");
        this._persistence_propertyChange("reversed", (Object)new Boolean(this.reversed), (Object)new Boolean(bl));
        this.reversed = bl;
    }

    public LoanTransaction _persistence_get_loanTransaction() {
        this._persistence_checkFetched("loanTransaction");
        return this.loanTransaction;
    }

    public void _persistence_set_loanTransaction(LoanTransaction loanTransaction) {
        this._persistence_checkFetchedForSet("loanTransaction");
        this._persistence_propertyChange("loanTransaction", (Object)this.loanTransaction, (Object)loanTransaction);
        this.loanTransaction = loanTransaction;
    }
}

