/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.guarantor.GuarantorConstants;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundStatusType;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingDetails;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_guarantor")
public class Guarantor
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne
    @JoinColumn(name="loan_id", nullable=false)
    private Loan loan;
    @ManyToOne
    @JoinColumn(name="client_reln_cv_id", nullable=false)
    private CodeValue clientRelationshipType;
    @Column(name="type_enum", nullable=false)
    private Integer gurantorType;
    @Column(name="entity_id")
    private Long entityId;
    @Column(name="firstname", length=50)
    private String firstname;
    @Column(name="lastname", length=50)
    private String lastname;
    @Column(name="dob")
    private LocalDate dateOfBirth;
    @Column(name="address_line_1", length=500)
    private String addressLine1;
    @Column(name="address_line_2", length=500)
    private String addressLine2;
    @Column(name="city", length=50)
    private String city;
    @Column(name="state", length=50)
    private String state;
    @Column(name="country", length=50)
    private String country;
    @Column(name="zip", length=20)
    private String zip;
    @Column(name="house_phone_number", length=20)
    private String housePhoneNumber;
    @Column(name="mobile_number", length=20)
    private String mobilePhoneNumber;
    @Column(name="comment", length=500)
    private String comment;
    @Column(name="is_active", nullable=false)
    private boolean active;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="guarantor", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<GuarantorFundingDetails> guarantorFundDetails = new ArrayList();
    static final long serialVersionUID = -5546991177272283981L;

    protected Guarantor() {
    }

    private Guarantor(Loan loan, CodeValue clientRelationshipType, Integer gurantorType, Long entityId, String firstname, String lastname, LocalDate dateOfBirth, String addressLine1, String addressLine2, String city, String state, String country, String zip, String housePhoneNumber, String mobilePhoneNumber, String comment, boolean active, List<GuarantorFundingDetails> guarantorFundDetails) {
        this.loan = loan;
        this.clientRelationshipType = clientRelationshipType;
        this.gurantorType = gurantorType;
        this.entityId = entityId;
        this.firstname = (String)StringUtils.defaultIfEmpty((CharSequence)firstname, null);
        this.lastname = (String)StringUtils.defaultIfEmpty((CharSequence)lastname, null);
        this.dateOfBirth = dateOfBirth;
        this.addressLine1 = (String)StringUtils.defaultIfEmpty((CharSequence)addressLine1, null);
        this.addressLine2 = (String)StringUtils.defaultIfEmpty((CharSequence)addressLine2, null);
        this.city = (String)StringUtils.defaultIfEmpty((CharSequence)city, null);
        this.state = (String)StringUtils.defaultIfEmpty((CharSequence)state, null);
        this.country = (String)StringUtils.defaultIfEmpty((CharSequence)country, null);
        this.zip = (String)StringUtils.defaultIfEmpty((CharSequence)zip, null);
        this.housePhoneNumber = (String)StringUtils.defaultIfEmpty((CharSequence)housePhoneNumber, null);
        this.mobilePhoneNumber = (String)StringUtils.defaultIfEmpty((CharSequence)mobilePhoneNumber, null);
        this.comment = (String)StringUtils.defaultIfEmpty((CharSequence)comment, null);
        this.active = active;
        this.guarantorFundDetails.addAll(guarantorFundDetails);
    }

    public static Guarantor fromJson(Loan loan, CodeValue clientRelationshipType, JsonCommand command, List<GuarantorFundingDetails> fundingDetails) {
        Integer gurantorType = command.integerValueSansLocaleOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.GUARANTOR_TYPE_ID.getValue());
        Long entityId = command.longValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.ENTITY_ID.getValue());
        boolean active = true;
        if (GuarantorType.EXTERNAL.getValue().equals(gurantorType)) {
            String firstname = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.FIRSTNAME.getValue());
            String lastname = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.LASTNAME.getValue());
            LocalDate dateOfBirth = command.localDateValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.DATE_OF_BIRTH.getValue());
            String addressLine1 = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_1.getValue());
            String addressLine2 = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_2.getValue());
            String city = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.CITY.getValue());
            String state = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.STATE.getValue());
            String country = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.COUNTRY.getValue());
            String zip = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.ZIP.getValue());
            String housePhoneNumber = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.PHONE_NUMBER.getValue());
            String mobilePhoneNumber = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.MOBILE_NUMBER.getValue());
            String comment = command.stringValueOfParameterNamed(GuarantorConstants.GuarantorJSONinputParams.COMMENT.getValue());
            return new Guarantor(loan, clientRelationshipType, gurantorType, entityId, firstname, lastname, dateOfBirth, addressLine1, addressLine2, city, state, country, zip, housePhoneNumber, mobilePhoneNumber, comment, true, fundingDetails);
        }
        return new Guarantor(loan, clientRelationshipType, gurantorType, entityId, null, null, null, null, null, null, null, null, null, null, null, null, true, fundingDetails);
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.CLIENT_RELATIONSHIP_TYPE_ID.getValue(), Integer.valueOf(0), true);
        if (this.isExternalGuarantor()) {
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.FIRSTNAME.getValue(), this._persistence_get_firstname());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.LASTNAME.getValue(), this._persistence_get_lastname());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.DATE_OF_BIRTH.getValue(), this._persistence_get_dateOfBirth());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_1.getValue(), this._persistence_get_addressLine1());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_2.getValue(), this._persistence_get_addressLine2());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.CITY.getValue(), this._persistence_get_city());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.STATE.getValue(), this._persistence_get_state());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.COUNTRY.getValue(), this._persistence_get_country());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.ZIP.getValue(), this._persistence_get_zip());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.PHONE_NUMBER.getValue(), this._persistence_get_housePhoneNumber());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.MOBILE_NUMBER.getValue(), this._persistence_get_mobilePhoneNumber());
            this.handlePropertyUpdate(command, actualChanges, GuarantorConstants.GuarantorJSONinputParams.COMMENT.getValue(), this._persistence_get_comment());
            this.updateExistingEntityToNull();
        }
        return actualChanges;
    }

    public boolean isExistingCustomer() {
        return GuarantorType.CUSTOMER.getValue().equals(this._persistence_get_gurantorType());
    }

    public boolean isExistingEmployee() {
        return GuarantorType.STAFF.getValue().equals(this._persistence_get_gurantorType());
    }

    public boolean isExternalGuarantor() {
        return GuarantorType.EXTERNAL.getValue().equals(this._persistence_get_gurantorType());
    }

    private void handlePropertyUpdate(JsonCommand command, Map<String, Object> actualChanges, String paramName, Integer propertyToBeUpdated, boolean sansLocale) {
        if (command.isChangeInIntegerParameterNamed(paramName, propertyToBeUpdated)) {
            Integer newValue = null;
            newValue = sansLocale ? command.integerValueSansLocaleOfParameterNamed(paramName) : command.integerValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.GUARANTOR_TYPE_ID.getValue())) {
                this._persistence_set_gurantorType(newValue);
            }
        }
    }

    private void handlePropertyUpdate(JsonCommand command, Map<String, Object> actualChanges, String paramName, String propertyToBeUpdated) {
        if (command.isChangeInStringParameterNamed(paramName, propertyToBeUpdated)) {
            String newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.FIRSTNAME.getValue())) {
                this._persistence_set_firstname(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.LASTNAME.getValue())) {
                this._persistence_set_lastname(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_1.getValue())) {
                this._persistence_set_addressLine1(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.ADDRESS_LINE_2.getValue())) {
                this._persistence_set_addressLine2(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.CITY.getValue())) {
                this._persistence_set_city(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.STATE.getValue())) {
                this._persistence_set_state(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.COUNTRY.getValue())) {
                this._persistence_set_country(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.ZIP.getValue())) {
                this._persistence_set_zip(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.PHONE_NUMBER.getValue())) {
                this._persistence_set_housePhoneNumber(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.MOBILE_NUMBER.getValue())) {
                this._persistence_set_mobilePhoneNumber(newValue);
            } else if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.COMMENT.getValue())) {
                this._persistence_set_comment(newValue);
            }
        }
    }

    private void handlePropertyUpdate(JsonCommand command, Map<String, Object> actualChanges, String paramName, LocalDate propertyToBeUpdated) {
        if (command.isChangeInDateParameterNamed(paramName, propertyToBeUpdated)) {
            LocalDate newValue = command.localDateValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            if (paramName.equals(GuarantorConstants.GuarantorJSONinputParams.DATE_OF_BIRTH.getValue())) {
                this._persistence_set_dateOfBirth(newValue);
            }
        }
    }

    public Long getEntityId() {
        return this._persistence_get_entityId();
    }

    public Long getLoanId() {
        return (Long)this._persistence_get_loan().getId();
    }

    public Long getClientId() {
        return this._persistence_get_loan().getClientId();
    }

    public Long getOfficeId() {
        return this._persistence_get_loan().getOfficeId();
    }

    public CodeValue getClientRelationshipType() {
        return this._persistence_get_clientRelationshipType();
    }

    public void updateClientRelationshipType(CodeValue clientRelationshipType) {
        this._persistence_set_clientRelationshipType(clientRelationshipType);
    }

    private void updateExistingEntityToNull() {
        this._persistence_set_entityId(null);
    }

    public Integer getGurantorType() {
        return this._persistence_get_gurantorType();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void updateStatus(boolean status) {
        this._persistence_set_active(status);
    }

    public void addFundingDetails(List<GuarantorFundingDetails> fundingDetails) {
        this._persistence_get_guarantorFundDetails().addAll(fundingDetails);
    }

    public void updateStatus(GuarantorFundingDetails guarantorFundingDetails, GuarantorFundStatusType fundStatusType) {
        guarantorFundingDetails.updateStatus(fundStatusType);
        this.updateStatus();
    }

    public GuarantorFundingDetails getGuarantorFundingDetail(Long fundingDetailId) {
        GuarantorFundingDetails guarantorFundingDetails = null;
        for (GuarantorFundingDetails fundingDetails : this._persistence_get_guarantorFundDetails()) {
            if (!((Long)fundingDetails.getId()).equals(fundingDetailId)) continue;
            guarantorFundingDetails = fundingDetails;
            break;
        }
        return guarantorFundingDetails;
    }

    private void updateStatus() {
        boolean isActive = false;
        for (GuarantorFundingDetails guarantorFundingDetails : this._persistence_get_guarantorFundDetails()) {
            if (!guarantorFundingDetails.getStatus().isActive()) continue;
            isActive = true;
            break;
        }
        this._persistence_set_active(isActive);
    }

    public Loan getLoan() {
        return this._persistence_get_loan();
    }

    public List<GuarantorFundingDetails> getGuarantorFundDetails() {
        return this._persistence_get_guarantorFundDetails();
    }

    public boolean hasGuarantor(Long savingsId) {
        if (savingsId == null) {
            return false;
        }
        boolean hasGuarantee = false;
        for (GuarantorFundingDetails guarantorFundingDetails : this._persistence_get_guarantorFundDetails()) {
            if (!guarantorFundingDetails.getStatus().isActive() || !savingsId.equals(guarantorFundingDetails.getLinkedSavingsAccount().getId())) continue;
            hasGuarantee = true;
            break;
        }
        return hasGuarantee;
    }

    public boolean isSelfGuarantee() {
        boolean isSelf = false;
        if (this.isExistingCustomer() && this.getEntityId().equals(this.getClientId())) {
            isSelf = true;
        }
        return isSelf;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Guarantor();
    }

    public Object _persistence_get(String string) {
        if (string == "zip") {
            return this.zip;
        }
        if (string == "country") {
            return this.country;
        }
        if (string == "mobilePhoneNumber") {
            return this.mobilePhoneNumber;
        }
        if (string == "firstname") {
            return this.firstname;
        }
        if (string == "loan") {
            return this.loan;
        }
        if (string == "city") {
            return this.city;
        }
        if (string == "clientRelationshipType") {
            return this.clientRelationshipType;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "dateOfBirth") {
            return this.dateOfBirth;
        }
        if (string == "gurantorType") {
            return this.gurantorType;
        }
        if (string == "lastname") {
            return this.lastname;
        }
        if (string == "housePhoneNumber") {
            return this.housePhoneNumber;
        }
        if (string == "guarantorFundDetails") {
            return this.guarantorFundDetails;
        }
        if (string == "addressLine1") {
            return this.addressLine1;
        }
        if (string == "addressLine2") {
            return this.addressLine2;
        }
        if (string == "comment") {
            return this.comment;
        }
        if (string == "state") {
            return this.state;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "zip") {
            this.zip = (String)object;
            return;
        }
        if (string == "country") {
            this.country = (String)object;
            return;
        }
        if (string == "mobilePhoneNumber") {
            this.mobilePhoneNumber = (String)object;
            return;
        }
        if (string == "firstname") {
            this.firstname = (String)object;
            return;
        }
        if (string == "loan") {
            this.loan = (Loan)object;
            return;
        }
        if (string == "city") {
            this.city = (String)object;
            return;
        }
        if (string == "clientRelationshipType") {
            this.clientRelationshipType = (CodeValue)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (Long)object;
            return;
        }
        if (string == "dateOfBirth") {
            this.dateOfBirth = (LocalDate)object;
            return;
        }
        if (string == "gurantorType") {
            this.gurantorType = (Integer)object;
            return;
        }
        if (string == "lastname") {
            this.lastname = (String)object;
            return;
        }
        if (string == "housePhoneNumber") {
            this.housePhoneNumber = (String)object;
            return;
        }
        if (string == "guarantorFundDetails") {
            this.guarantorFundDetails = (List)object;
            return;
        }
        if (string == "addressLine1") {
            this.addressLine1 = (String)object;
            return;
        }
        if (string == "addressLine2") {
            this.addressLine2 = (String)object;
            return;
        }
        if (string == "comment") {
            this.comment = (String)object;
            return;
        }
        if (string == "state") {
            this.state = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_zip() {
        this._persistence_checkFetched("zip");
        return this.zip;
    }

    public void _persistence_set_zip(String string) {
        this._persistence_checkFetchedForSet("zip");
        this.zip = string;
    }

    public String _persistence_get_country() {
        this._persistence_checkFetched("country");
        return this.country;
    }

    public void _persistence_set_country(String string) {
        this._persistence_checkFetchedForSet("country");
        this.country = string;
    }

    public String _persistence_get_mobilePhoneNumber() {
        this._persistence_checkFetched("mobilePhoneNumber");
        return this.mobilePhoneNumber;
    }

    public void _persistence_set_mobilePhoneNumber(String string) {
        this._persistence_checkFetchedForSet("mobilePhoneNumber");
        this.mobilePhoneNumber = string;
    }

    public String _persistence_get_firstname() {
        this._persistence_checkFetched("firstname");
        return this.firstname;
    }

    public void _persistence_set_firstname(String string) {
        this._persistence_checkFetchedForSet("firstname");
        this.firstname = string;
    }

    public Loan _persistence_get_loan() {
        this._persistence_checkFetched("loan");
        return this.loan;
    }

    public void _persistence_set_loan(Loan loan) {
        this._persistence_checkFetchedForSet("loan");
        this.loan = loan;
    }

    public String _persistence_get_city() {
        this._persistence_checkFetched("city");
        return this.city;
    }

    public void _persistence_set_city(String string) {
        this._persistence_checkFetchedForSet("city");
        this.city = string;
    }

    public CodeValue _persistence_get_clientRelationshipType() {
        this._persistence_checkFetched("clientRelationshipType");
        return this.clientRelationshipType;
    }

    public void _persistence_set_clientRelationshipType(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("clientRelationshipType");
        this.clientRelationshipType = codeValue;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public Long _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(Long l) {
        this._persistence_checkFetchedForSet("entityId");
        this.entityId = l;
    }

    public LocalDate _persistence_get_dateOfBirth() {
        this._persistence_checkFetched("dateOfBirth");
        return this.dateOfBirth;
    }

    public void _persistence_set_dateOfBirth(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dateOfBirth");
        this.dateOfBirth = localDate;
    }

    public Integer _persistence_get_gurantorType() {
        this._persistence_checkFetched("gurantorType");
        return this.gurantorType;
    }

    public void _persistence_set_gurantorType(Integer n) {
        this._persistence_checkFetchedForSet("gurantorType");
        this.gurantorType = n;
    }

    public String _persistence_get_lastname() {
        this._persistence_checkFetched("lastname");
        return this.lastname;
    }

    public void _persistence_set_lastname(String string) {
        this._persistence_checkFetchedForSet("lastname");
        this.lastname = string;
    }

    public String _persistence_get_housePhoneNumber() {
        this._persistence_checkFetched("housePhoneNumber");
        return this.housePhoneNumber;
    }

    public void _persistence_set_housePhoneNumber(String string) {
        this._persistence_checkFetchedForSet("housePhoneNumber");
        this.housePhoneNumber = string;
    }

    public List _persistence_get_guarantorFundDetails() {
        this._persistence_checkFetched("guarantorFundDetails");
        return this.guarantorFundDetails;
    }

    public void _persistence_set_guarantorFundDetails(List list) {
        this._persistence_checkFetchedForSet("guarantorFundDetails");
        this.guarantorFundDetails = list;
    }

    public String _persistence_get_addressLine1() {
        this._persistence_checkFetched("addressLine1");
        return this.addressLine1;
    }

    public void _persistence_set_addressLine1(String string) {
        this._persistence_checkFetchedForSet("addressLine1");
        this.addressLine1 = string;
    }

    public String _persistence_get_addressLine2() {
        this._persistence_checkFetched("addressLine2");
        return this.addressLine2;
    }

    public void _persistence_set_addressLine2(String string) {
        this._persistence_checkFetchedForSet("addressLine2");
        this.addressLine2 = string;
    }

    public String _persistence_get_comment() {
        this._persistence_checkFetched("comment");
        return this.comment;
    }

    public void _persistence_set_comment(String string) {
        this._persistence_checkFetchedForSet("comment");
        this.comment = string;
    }

    public String _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(String string) {
        this._persistence_checkFetchedForSet("state");
        this.state = string;
    }
}

