/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.data;

import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.ExternalIdMapper;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.loanaccount.data.LoanFeeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanInterestData;
import org.apache.fineract.portfolio.loanaccount.data.LoanPenaltyData;
import org.apache.fineract.portfolio.loanaccount.data.LoanPointInTimeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanPrincipalData;
import org.apache.fineract.portfolio.loanaccount.data.LoanStatusEnumData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTotalAmountData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoanPointInTimeData$MapperImpl
implements LoanPointInTimeData.Mapper {
    private final LoanStatusEnumData.Mapper mapper;
    private final CurrencyData.Mapper mapper1;
    private final LoanPrincipalData.Mapper mapper2;
    private final LoanInterestData.Mapper mapper3;
    private final LoanFeeData.Mapper mapper4;
    private final LoanPenaltyData.Mapper mapper5;
    private final LoanTotalAmountData.Mapper mapper6;
    private final ExternalIdMapper externalIdMapper;

    @Autowired
    public LoanPointInTimeData$MapperImpl(LoanStatusEnumData.Mapper mapper, CurrencyData.Mapper mapper1, LoanPrincipalData.Mapper mapper2, LoanInterestData.Mapper mapper3, LoanFeeData.Mapper mapper4, LoanPenaltyData.Mapper mapper5, LoanTotalAmountData.Mapper mapper6, ExternalIdMapper externalIdMapper) {
        this.mapper = mapper;
        this.mapper1 = mapper1;
        this.mapper2 = mapper2;
        this.mapper3 = mapper3;
        this.mapper4 = mapper4;
        this.mapper5 = mapper5;
        this.mapper6 = mapper6;
        this.externalIdMapper = externalIdMapper;
    }

    public LoanPointInTimeData map(Loan source) {
        if (source == null) {
            return null;
        }
        LoanPointInTimeData loanPointInTimeData = new LoanPointInTimeData();
        loanPointInTimeData.setAccountNo(source.getAccountNumber());
        loanPointInTimeData.setStatus(this.mapper.map(source));
        loanPointInTimeData.setClientId(this.sourceClientId(source));
        loanPointInTimeData.setClientAccountNo(this.sourceClientAccountNumber(source));
        loanPointInTimeData.setClientExternalId(this.externalIdMapper.mapExternalId(this.sourceClientExternalId(source)));
        loanPointInTimeData.setClientDisplayName(this.sourceClientDisplayName(source));
        loanPointInTimeData.setClientOfficeId(this.sourceClientOfficeId(source));
        loanPointInTimeData.setPrincipal(this.mapper2.map(source.getSummary()));
        loanPointInTimeData.setInterest(this.mapper3.map(source.getSummary()));
        loanPointInTimeData.setFee(this.mapper4.map(source.getSummary()));
        loanPointInTimeData.setPenalty(this.mapper5.map(source.getSummary()));
        loanPointInTimeData.setTotal(this.mapper6.map(source.getSummary()));
        loanPointInTimeData.setLoanProductId(this.sourceLoanProductId(source));
        loanPointInTimeData.setLoanProductName(this.sourceLoanProductName(source));
        loanPointInTimeData.setId((Long)source.getId());
        loanPointInTimeData.setExternalId(this.externalIdMapper.mapExternalId(source.getExternalId()));
        loanPointInTimeData.setCurrency(this.mapper1.map(source.getCurrency()));
        return loanPointInTimeData;
    }

    private Long sourceClientId(Loan loan) {
        Client client = loan.getClient();
        if (client == null) {
            return null;
        }
        return (Long)client.getId();
    }

    private String sourceClientAccountNumber(Loan loan) {
        Client client = loan.getClient();
        if (client == null) {
            return null;
        }
        return client.getAccountNumber();
    }

    private ExternalId sourceClientExternalId(Loan loan) {
        Client client = loan.getClient();
        if (client == null) {
            return null;
        }
        return client.getExternalId();
    }

    private String sourceClientDisplayName(Loan loan) {
        Client client = loan.getClient();
        if (client == null) {
            return null;
        }
        return client.getDisplayName();
    }

    private Long sourceClientOfficeId(Loan loan) {
        Client client = loan.getClient();
        if (client == null) {
            return null;
        }
        Office office = client.getOffice();
        if (office == null) {
            return null;
        }
        return (Long)office.getId();
    }

    private Long sourceLoanProductId(Loan loan) {
        LoanProduct loanProduct = loan.getLoanProduct();
        if (loanProduct == null) {
            return null;
        }
        return (Long)loanProduct.getId();
    }

    private String sourceLoanProductName(Loan loan) {
        LoanProduct loanProduct = loan.getLoanProduct();
        if (loanProduct == null) {
            return null;
        }
        return loanProduct.getName();
    }
}

