/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.CommandParameterUtil;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanaccount.api.LoanTransactionsApiResourceSwagger;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargePaidByReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans")
@Component
@Tag(name="Loan Transactions", description="Capabilities include loan repayment's, interest waivers and the ability to 'adjust' an existing transaction. An 'adjustment' of a transaction is really a 'reversal' of existing transaction followed by creation of a new transaction with the provided details.")
public class LoanTransactionsApiResource {
    public static final String CHARGE_OFF_COMMAND_VALUE = "charge-off";
    public static final String UNDO_CHARGE_OFF_COMMAND_VALUE = "undo-charge-off";
    public static final String DOWN_PAYMENT = "downPayment";
    public static final String UNDO_REAGE = "undoReAge";
    public static final String REAGE = "reAge";
    public static final String REAMORTIZE = "reAmortize";
    public static final String UNDO_REAMORTIZE = "undoReAmortize";
    private final Set<String> responseDataParameters = new HashSet<String>(Arrays.asList("id", "type", "date", "currency", "amount", "externalId", "reversalExternalId", "reversedOnDate"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOAN";
    private final PlatformSecurityContext context;
    private final LoanReadPlatformService loanReadPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<LoanTransactionData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final LoanChargePaidByReadService loanChargePaidByReadService;

    @GET
    @Path(value="{loanId}/transactions/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Transaction Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\nloans/1/transactions/template?command=repaymentloans/1/transactions/template?command=merchantIssuedRefundloans/1/transactions/template?command=payoutRefundloans/1/transactions/template?command=goodwillCredit\nloans/1/transactions/template?command=waiveinterest\nloans/1/transactions/template?command=writeoff\nloans/1/transactions/template?command=close-rescheduled\nloans/1/transactions/template?command=close\nloans/1/transactions/template?command=disburse\nloans/1/transactions/template?command=disburseToSavings\nloans/1/transactions/template?command=recoverypayment\nloans/1/transactions/template?command=prepayLoan\nloans/1/transactions/template?command=refundbycash\nloans/1/transactions/template?command=refundbytransfer\nloans/1/transactions/template?command=foreclosure\nloans/1/transactions/template?command=interestPaymentWaiver\nloans/1/transactions/template?command=creditBalanceRefund (returned 'amount' field will have the overpaid value)\nloans/1/transactions/template?command=charge-off\nloans/1/transactions/template?command=downPayment\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTemplateResponse.class))})})
    public String retrieveTransactionTemplate(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String rawDateFormat, @QueryParam(value="transactionDate") @Parameter(description="transactionDate") DateParam transactionDateParam, @QueryParam(value="locale") @Parameter(description="locale") String locale) {
        DateFormat dateFormat = StringUtils.isBlank((CharSequence)rawDateFormat) ? null : new DateFormat(rawDateFormat);
        return this.retrieveTransactionTemplate(loanId, null, commandParam, uriInfo, dateFormat, transactionDateParam, locale);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/transactions/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Transaction Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\nloans/1/transactions/template?command=repaymentloans/1/transactions/template?command=merchantIssuedRefundloans/1/transactions/template?command=payoutRefundloans/1/transactions/template?command=goodwillCredit\nloans/1/transactions/template?command=waiveinterest\nloans/1/transactions/template?command=writeoff\nloans/1/transactions/template?command=close-rescheduled\nloans/1/transactions/template?command=close\nloans/1/transactions/template?command=disburse\nloans/1/transactions/template?command=disburseToSavings\nloans/1/transactions/template?command=recoverypayment\nloans/1/transactions/template?command=prepayLoan\nloans/1/transactions/template?command=refundbycash\nloans/1/transactions/template?command=refundbytransfer\nloans/1/transactions/template?command=foreclosure\nloans/1/transactions/template?command=interestPaymentWaiver\nloans/1/transactions/template?command=creditBalanceRefund (returned 'amount' field will have the overpaid value)\nloans/1/transactions/template?command=charge-off\nloans/1/transactions/template?command=downPayment\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTemplateResponse.class))})})
    public String retrieveTransactionTemplate(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String rawDateFormat, @QueryParam(value="transactionDate") @Parameter(description="transactionDate") DateParam transactionDateParam, @QueryParam(value="locale") @Parameter(description="locale") String locale) {
        DateFormat dateFormat = StringUtils.isBlank((CharSequence)rawDateFormat) ? null : new DateFormat(rawDateFormat);
        return this.retrieveTransactionTemplate(null, loanExternalId, commandParam, uriInfo, dateFormat, transactionDateParam, locale);
    }

    @GET
    @Path(value="{loanId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Transaction Details", description="Retrieves a Transaction Details\n\nExample Request:\n\nloans/5/transactions/3")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTransactionIdResponse.class))})})
    public String retrieveTransaction(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan Transaction attribute list to be in the response", required=false, example="id,date,amount") String fields, @Context UriInfo uriInfo) {
        return this.retrieveTransaction(loanId, null, transactionId, null, uriInfo);
    }

    @GET
    @Path(value="{loanId}/transactions/external-id/{externalTransactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Transaction Details", description="Retrieves a Transaction Details\n\nExample Request:\n\nloans/5/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTransactionIdResponse.class))})})
    public String retrieveTransactionByTransactionExternalId(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="externalTransactionId") @Parameter(description="externalTransactionId", required=true) String externalTransactionId, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan Transaction attribute list to be in the response", required=false, example="id,date,amount") String fields, @Context UriInfo uriInfo) {
        return this.retrieveTransaction(loanId, null, null, externalTransactionId, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Transaction Details", description="Retrieves a Transaction Details\n\nExample Request:\n\nloans/5/transactions/3")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTransactionIdResponse.class))})})
    public String retrieveTransactionByLoanExternalIdAndTransactionId(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan Transaction attribute list to be in the response", required=false, example="id,date,amount") String fields, @Context UriInfo uriInfo) {
        return this.retrieveTransaction(null, loanExternalId, transactionId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Transaction Details", description="Retrieves a Transaction Details\n\nExample Request:\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/5dd80a7c-ccba-4446-b378-01eb6f53e871")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.GetLoansLoanIdTransactionsTransactionIdResponse.class))})})
    public String retrieveTransactionByLoanExternalIdAndTransactionExternalId(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="externalTransactionId") @Parameter(description="externalTransactionId", required=true) String externalTransactionId, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan Transaction attribute list to be in the response", required=false, example="id,date,amount") String fields, @Context UriInfo uriInfo) {
        return this.retrieveTransaction(null, loanExternalId, null, externalTransactionId, uriInfo);
    }

    @POST
    @Path(value="{loanId}/transactions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Significant Loan Transactions", description="This API covers the major loan transaction functionality\n\nExample Requests:\n\nloans/1/transactions?command=repayment | Make a Repayment | \nloans/1/transactions?command=merchantIssuedRefund | Merchant Issued Refund | \nloans/1/transactions?command=payoutRefund | Payout Refund | \nloans/1/transactions?command=goodwillCredit | Goodwil Credit | \nloans/1/transactions?command=chargeRefund | Charge Refund | \nloans/1/transactions?command=waiveinterest | Waive Interest | \nloans/1/transactions?command=writeoff | Write-off Loan | \nloans/1/transactions?command=close-rescheduled | Close Rescheduled Loan | \nloans/1/transactions?command=close | Close Loan | \nloans/1/transactions?command=undowriteoff | Undo Loan Write-off | \nloans/1/transactions?command=recoverypayment | Make Recovery Payment | \nloans/1/transactions?command=refundByCash | Make a Refund of an Active Loan by Cash | \nloans/1/transactions?command=foreclosure | Foreclosure of an Active Loan | \nloans/1/transactions?command=creditBalanceRefund | Credit Balance Refund |  \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=charge-off | Charge-off Loan |  \nloans/1/transactions?command=downPayment | Down Payment |  \n")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String executeLoanTransaction(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.executeTransaction(loanId, null, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/transactions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Significant Loan Transactions", description="This API covers the major loan transaction functionality\n\nExample Requests:\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=repayment | Make a Repayment | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=merchantIssuedRefund | Merchant Issued Refund | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=payoutRefund | Payout Refund | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=goodwillCredit | Goodwil Credit | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=chargeRefund | Charge Refund | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=waiveinterest | Waive Interest | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=writeoff | Write-off Loan | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=close-rescheduled | Close Rescheduled Loan | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=close | Close Loan | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=undowriteoff | Undo Loan Write-off | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=recoverypayment | Make Recovery Payment | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=refundByCash | Make a Refund of an Active Loan by Cash | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=foreclosure | Foreclosure of an Active Loan | \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=creditBalanceRefund | Credit Balance Refund |  \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=charge-off | Charge-off Loan |  \nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?command=downPayment | Down Payment |  \n")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String executeLoanTransaction(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.executeTransaction(null, loanExternalId, commandParam, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="{loanId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adjust a Transaction", description="Note: there is no need to specify command={transactionType} parameter.\n\nMandatory Fields: transactionDate, transactionAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsTransactionIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String adjustLoanTransaction(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.adjustTransaction(loanId, null, transactionId, null, apiRequestBodyAsJson, commandParam);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adjust a Transaction", description="Note: there is no need to specify command={transactionType} parameter.\n\nMandatory Fields: transactionDate, transactionAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsTransactionIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String adjustLoanTransaction(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.adjustTransaction(null, loanExternalId, transactionId, null, apiRequestBodyAsJson, commandParam);
    }

    @POST
    @Path(value="{loanId}/transactions/external-id/{externalTransactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adjust a Transaction", description="Note: there is no need to specify command={transactionType} parameter.\n\nMandatory Fields: transactionDate, transactionAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsTransactionIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String adjustLoanTransaction(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="externalTransactionId") @Parameter(description="externalTransactionId", required=true) String transactionExternalId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.adjustTransaction(loanId, null, null, transactionExternalId, apiRequestBodyAsJson, commandParam);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/transactions/external-id/{externalTransactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adjust a Transaction", description="Note: there is no need to specify command={transactionType} parameter.\n\nMandatory Fields: transactionDate, transactionAmount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsTransactionIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PostLoansLoanIdTransactionsResponse.class))})})
    public String adjustLoanTransaction(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="externalTransactionId") @Parameter(description="externalTransactionId", required=true) String transactionExternalId, @Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        return this.adjustTransaction(null, loanExternalId, null, transactionExternalId, apiRequestBodyAsJson, commandParam);
    }

    @PUT
    @Path(value="{loanId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Waive Charge Transaction", description="Undo a Waive Charge Transaction")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesResponse.class))})})
    public String undoWaiveCharge(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId) {
        return this.undoWaiveCharge(loanId, null, transactionId, null);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Waive Charge Transaction", description="Undo a Waive Charge Transaction")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesResponse.class))})})
    public String undoWaiveCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="transactionId") @Parameter(description="transactionId", required=true) Long transactionId) {
        return this.undoWaiveCharge(null, loanExternalId, transactionId, null);
    }

    @PUT
    @Path(value="{loanId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Waive Charge Transaction", description="Undo a Waive Charge Transaction")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesResponse.class))})})
    public String undoWaiveCharge(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId", required=true) String transactionExternalId) {
        return this.undoWaiveCharge(loanId, null, null, transactionExternalId);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/transactions/external-id/{transactionExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Undo a Waive Charge Transaction", description="Undo a Waive Charge Transaction")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanTransactionsApiResourceSwagger.PutChargeTransactionChangesResponse.class))})})
    public String undoWaiveCharge(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @PathParam(value="transactionExternalId") @Parameter(description="transactionExternalId", required=true) String transactionExternalId) {
        return this.undoWaiveCharge(null, loanExternalId, null, transactionExternalId);
    }

    private String retrieveTransaction(Long loanId, String loanExternalIdStr, Long transactionId, String transactionExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId transactionExternalId = ExternalIdFactory.produce((String)transactionExternalIdStr);
        Long resolvedLoanId = this.getResolvedLoanId(loanId, loanExternalId);
        Long resolvedLoanTransactionId = this.getResolvedLoanTransactionId(transactionId, transactionExternalId);
        LoanTransactionData transactionData = this.loanReadPlatformService.retrieveLoanTransaction(resolvedLoanId, resolvedLoanTransactionId);
        transactionData.setLoanChargePaidByList((Collection)this.loanChargePaidByReadService.fetchLoanChargesPaidByDataTransactionId(transactionData.getId()));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            Collection paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
            transactionData = LoanTransactionData.templateOnTop((LoanTransactionData)transactionData, (Collection)paymentTypeOptions);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)transactionData, this.responseDataParameters);
    }

    private String executeTransaction(Long loanId, String loanExternalIdStr, String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = this.getResolvedLoanId(loanId, loanExternalId);
        CommandWrapper commandRequest = null;
        if (CommandParameterUtil.is((String)commandParam, (String)"repayment")) {
            commandRequest = builder.loanRepaymentTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"merchantIssuedRefund")) {
            commandRequest = builder.loanMerchantIssuedRefundTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"payoutRefund")) {
            commandRequest = builder.loanPayoutRefundTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"goodwillCredit")) {
            commandRequest = builder.loanGoodwillCreditTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"interestPaymentWaiver")) {
            commandRequest = builder.loanInterestPaymentWaiverTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"chargeRefund")) {
            commandRequest = builder.refundLoanCharge(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"waiveinterest")) {
            commandRequest = builder.waiveInterestPortionTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"writeoff")) {
            commandRequest = builder.writeOffLoanTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"close-rescheduled")) {
            commandRequest = builder.closeLoanAsRescheduledTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"close")) {
            commandRequest = builder.closeLoanTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undowriteoff")) {
            commandRequest = builder.undoWriteOffLoanTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"recoverypayment")) {
            commandRequest = builder.loanRecoveryPaymentTransaction(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"refundByCash")) {
            commandRequest = builder.refundLoanTransactionByCash(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"foreclosure")) {
            commandRequest = builder.loanForeclosure(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"creditBalanceRefund")) {
            commandRequest = builder.creditBalanceRefund(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)CHARGE_OFF_COMMAND_VALUE)) {
            commandRequest = builder.chargeOff(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)UNDO_CHARGE_OFF_COMMAND_VALUE)) {
            commandRequest = builder.undoChargeOff(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)DOWN_PAYMENT)) {
            commandRequest = builder.downPayment(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)REAGE)) {
            commandRequest = builder.reAge(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)UNDO_REAGE)) {
            commandRequest = builder.undoReAge(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)REAMORTIZE)) {
            commandRequest = builder.reAmortize(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)UNDO_REAMORTIZE)) {
            commandRequest = builder.undoReAmortize(resolvedLoanId).build();
        }
        if (commandRequest == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String retrieveTransactionTemplate(Long loanId, String loanExternalIdStr, String commandParam, UriInfo uriInfo, DateFormat dateFormat, DateParam transactionDateParam, String locale) {
        LoanTransactionData transactionData;
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = this.getResolvedLoanId(loanId, loanExternalId);
        if (CommandParameterUtil.is((String)commandParam, (String)"repayment")) {
            transactionData = this.loanReadPlatformService.retrieveLoanTransactionTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"merchantIssuedRefund")) {
            transactionDate = DateUtils.getBusinessLocalDate();
            transactionData = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.MERCHANT_ISSUED_REFUND, resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"payoutRefund")) {
            transactionDate = DateUtils.getBusinessLocalDate();
            transactionData = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.PAYOUT_REFUND, resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"goodwillCredit")) {
            transactionDate = DateUtils.getBusinessLocalDate();
            transactionData = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.GOODWILL_CREDIT, resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"interestPaymentWaiver")) {
            transactionDate = DateUtils.getBusinessLocalDate();
            transactionData = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.INTEREST_PAYMENT_WAIVER, resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"waiveinterest")) {
            transactionData = this.loanReadPlatformService.retrieveWaiveInterestDetails(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"writeoff")) {
            transactionData = this.loanReadPlatformService.retrieveLoanWriteoffTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"close-rescheduled")) {
            transactionData = this.loanReadPlatformService.retrieveNewClosureDetails();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"close")) {
            transactionData = this.loanReadPlatformService.retrieveNewClosureDetails();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburse")) {
            transactionData = this.loanReadPlatformService.retrieveDisbursalTemplate(resolvedLoanId, true);
            transactionData.setNumberOfRepayments(this.loanReadPlatformService.retrieveNumberOfRepayments(resolvedLoanId));
            List loanRepaymentScheduleInstallmentData = this.loanReadPlatformService.getRepaymentDataResponse(resolvedLoanId);
            transactionData.setLoanRepaymentScheduleInstallments(loanRepaymentScheduleInstallmentData);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburseToSavings")) {
            transactionData = this.loanReadPlatformService.retrieveDisbursalTemplate(resolvedLoanId, false);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"recoverypayment")) {
            transactionData = this.loanReadPlatformService.retrieveRecoveryPaymentTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"prepayLoan")) {
            transactionDate = transactionDateParam == null ? DateUtils.getBusinessLocalDate() : transactionDateParam.getDate("transactionDate", dateFormat, locale);
            transactionData = this.loanReadPlatformService.retrieveLoanPrePaymentTemplate(LoanTransactionType.REPAYMENT, resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"refundbycash")) {
            transactionData = this.loanReadPlatformService.retrieveRefundByCashTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"refundbytransfer")) {
            transactionData = this.loanReadPlatformService.retrieveDisbursalTemplate(resolvedLoanId, true);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"foreclosure")) {
            transactionDate = transactionDateParam == null ? DateUtils.getBusinessLocalDate() : transactionDateParam.getDate("transactionDate", dateFormat, locale);
            transactionData = this.loanReadPlatformService.retrieveLoanForeclosureTemplate(resolvedLoanId, transactionDate);
        } else if (CommandParameterUtil.is((String)commandParam, (String)"creditBalanceRefund")) {
            transactionData = this.loanReadPlatformService.retrieveCreditBalanceRefundTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)CHARGE_OFF_COMMAND_VALUE)) {
            transactionData = this.loanReadPlatformService.retrieveLoanChargeOffTemplate(resolvedLoanId);
        } else if (CommandParameterUtil.is((String)commandParam, (String)DOWN_PAYMENT)) {
            transactionData = this.loanReadPlatformService.retrieveLoanTransactionTemplate(resolvedLoanId);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)transactionData, this.responseDataParameters);
    }

    private String adjustTransaction(Long loanId, String loanExternalIdStr, Long transactionId, String transactionExternalIdStr, String apiRequestBodyAsJson, String commandParam) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId transactionExternalId = ExternalIdFactory.produce((String)transactionExternalIdStr);
        Long resolvedLoanId = this.getResolvedLoanId(loanId, loanExternalId);
        Long resolvedTransactionId = this.getResolvedLoanTransactionId(transactionId, transactionExternalId);
        CommandWrapper commandRequest = CommandParameterUtil.is((String)commandParam, (String)"chargeback") ? builder.chargebackTransaction(resolvedLoanId, resolvedTransactionId).build() : builder.adjustTransaction(resolvedLoanId, resolvedTransactionId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String undoWaiveCharge(Long loanId, String loanExternalIdStr, Long transactionId, String transactionExternalIdStr) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        ExternalId transactionExternalId = ExternalIdFactory.produce((String)transactionExternalIdStr);
        Long resolvedLoanId = this.getResolvedLoanId(loanId, loanExternalId);
        Long resolvedTransactionId = this.getResolvedLoanTransactionId(transactionId, transactionExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().undoWaiveChargeTransaction(resolvedLoanId, resolvedTransactionId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private Long getResolvedLoanTransactionId(Long transactionId, ExternalId externalTransactionId) {
        Long resolvedLoanTransactionId = transactionId;
        if (resolvedLoanTransactionId == null) {
            externalTransactionId.throwExceptionIfEmpty();
            resolvedLoanTransactionId = this.loanReadPlatformService.retrieveLoanTransactionIdByExternalId(externalTransactionId);
            if (resolvedLoanTransactionId == null) {
                throw new LoanTransactionNotFoundException(externalTransactionId);
            }
        }
        return resolvedLoanTransactionId;
    }

    private Long getResolvedLoanId(Long loanId, ExternalId loanExternalId) {
        Long resolvedLoanId = loanId;
        if (resolvedLoanId == null) {
            loanExternalId.throwExceptionIfEmpty();
            resolvedLoanId = this.loanReadPlatformService.retrieveLoanIdByExternalId(loanExternalId);
            if (resolvedLoanId == null) {
                throw new LoanNotFoundException(loanExternalId);
            }
        }
        return resolvedLoanId;
    }

    @Generated
    public LoanTransactionsApiResource(PlatformSecurityContext context, LoanReadPlatformService loanReadPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<LoanTransactionData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, LoanChargePaidByReadService loanChargePaidByReadService) {
        this.context = context;
        this.loanReadPlatformService = loanReadPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.loanChargePaidByReadService = loanChargePaidByReadService;
    }
}

