/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanproduct.data.AdvancedPaymentData;
import org.apache.fineract.portfolio.loanproduct.mapper.AdvancedPaymentDataMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/loan")
public class InternalLoanInformationApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalLoanInformationApiResource.class);
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;
    private final ToApiJsonSerializer<Map> toApiJsonSerializerForMap;
    private final ToApiJsonSerializer<List> toApiJsonSerializerForList;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AdvancedPaymentDataMapper advancedPaymentDataMapper;
    private final LoanAccountDomainService loanAccountDomainService;
    private final Gson gson = new Gson();

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal loan services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @GET
    @Path(value="{loanId}/audit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public String getLoanAuditFields(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loan with {}", (Object)loanId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        HashMap<String, Serializable> auditFields = new HashMap<String, Serializable>(Map.of("createdBy", loan.getCreatedBy().orElse(null), "createdDate", loan.getCreatedDate().orElse(null), "lastModifiedBy", loan.getLastModifiedBy().orElse(null), "lastModifiedDate", loan.getLastModifiedDate().orElse(null)));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerForMap.serialize(settings, auditFields);
    }

    @GET
    @Path(value="{loanId}/transaction/{transactionId}/audit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public String getLoanTransactionAuditFields(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId, @PathParam(value="transactionId") Long transactionId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loan transaction with loanId {}, transactionId {}", (Object)loanId, (Object)transactionId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        LoanTransaction transaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)transactionId).orElseThrow();
        HashMap<String, Serializable> auditFields = new HashMap<String, Serializable>(Map.of("createdBy", transaction.getCreatedBy().orElse(null), "createdDate", transaction.getCreatedDate().orElse(null), "lastModifiedBy", transaction.getLastModifiedBy().orElse(null), "lastModifiedDate", transaction.getLastModifiedDate().orElse(null)));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerForMap.serialize(settings, auditFields);
    }

    @GET
    @Path(value="status/{statusId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public String getLoansByStatus(@Context UriInfo uriInfo, @PathParam(value="statusId") Integer statusId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching loans by status {}", (Object)statusId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        List loanIds = this.loanRepositoryWrapper.findLoanIdsByStatusId(statusId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerForList.serialize(settings, (Object)loanIds);
    }

    @GET
    @Path(value="{loanId}/advanced-payment-allocation-rules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public List<AdvancedPaymentData> getAdvancedPaymentAllocationRulesOfLoan(@Context UriInfo uriInfo, @PathParam(value="loanId") Long loanId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching advanced payment allocation rules by loanId {}", (Object)loanId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId);
        return this.advancedPaymentDataMapper.mapLoanPaymentAllocationRule(loan.getPaymentAllocationRules());
    }

    @Generated
    public InternalLoanInformationApiResource(LoanRepositoryWrapper loanRepositoryWrapper, LoanTransactionRepository loanTransactionRepository, ToApiJsonSerializer<Map> toApiJsonSerializerForMap, ToApiJsonSerializer<List> toApiJsonSerializerForList, ApiRequestParameterHelper apiRequestParameterHelper, AdvancedPaymentDataMapper advancedPaymentDataMapper, LoanAccountDomainService loanAccountDomainService) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
        this.toApiJsonSerializerForMap = toApiJsonSerializerForMap;
        this.toApiJsonSerializerForList = toApiJsonSerializerForList;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.advancedPaymentDataMapper = advancedPaymentDataMapper;
        this.loanAccountDomainService = loanAccountDomainService;
    }
}

