/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.group.data.GroupLevelData;
import org.apache.fineract.portfolio.group.service.GroupLevelReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/grouplevels")
@Component
@Tag(name="Groups Level", description="")
public class GroupsLevelApiResource {
    private static final Set<String> GROUPLEVEL_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("levelId", "levelName", "parentLevelId", "parentLevelName", "childLevelId", "childLevelName", "superParent", "recursable", "canHaveClients"));
    private final PlatformSecurityContext context;
    private final GroupLevelReadPlatformService groupLevelReadPlatformService;
    private final ToApiJsonSerializer<GroupLevelData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAllGroups(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        Collection groupLevel = this.groupLevelReadPlatformService.retrieveAllLevels();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, groupLevel, GROUPLEVEL_DATA_PARAMETERS);
    }

    @Generated
    public GroupsLevelApiResource(PlatformSecurityContext context, GroupLevelReadPlatformService groupLevelReadPlatformService, ToApiJsonSerializer<GroupLevelData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.groupLevelReadPlatformService = groupLevelReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

