/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.fund.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.fund.data.FundData;
import org.apache.fineract.portfolio.fund.exception.FundNotFoundException;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformServiceImpl;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class FundReadPlatformServiceImpl
implements FundReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Cacheable(value={"funds"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('fn')")
    public Collection<FundData> retrieveAllFunds() {
        this.context.authenticatedUser();
        FundMapper rm = new FundMapper();
        String sql = "select " + rm.schema() + " order by f.name";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public FundData retrieveFund(Long fundId) {
        try {
            this.context.authenticatedUser();
            FundMapper rm = new FundMapper();
            String sql = "select " + rm.schema() + " where f.id = ?";
            FundData selectedFund = (FundData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{fundId});
            return selectedFund;
        }
        catch (EmptyResultDataAccessException e) {
            throw new FundNotFoundException(fundId, e);
        }
    }

    @Generated
    public FundReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

