/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collectionsheet.api.CollectionSheetApiResourceSwagger;
import org.apache.fineract.portfolio.collectionsheet.data.IndividualCollectionSheetData;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/collectionsheet")
@Component
@Tag(name="Collection Sheet", description="")
public class CollectionSheetApiResource {
    private final CollectionSheetReadPlatformService collectionSheetReadPlatformService;
    private final ToApiJsonSerializer<Object> toApiJsonSerializer;
    private final FromJsonHelper fromJsonHelper;
    private final ApiRequestParameterHelper apiRequestPrameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Generate Individual Collection Sheet | Save Collection Sheet", description="Generate Individual Collection Sheet:\n\nThis Api retrieves repayment details of all individual loans under a office as on a specified meeting date.\n\nSave Collection Sheet:\n\nThis Api allows the loan officer to perform bulk repayments of individual loans and deposit of mandatory savings on a given meeting date.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollectionSheetApiResourceSwagger.PostCollectionSheetRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollectionSheetApiResourceSwagger.PostCollectionSheetResponse.class))})})
    public String generateCollectionSheet(@QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "generateCollectionSheet")) {
            this.context.authenticatedUser().validateHasReadPermission("collectionsheet");
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            IndividualCollectionSheetData collectionSheet = this.collectionSheetReadPlatformService.generateIndividualCollectionSheet(query);
            ApiRequestJsonSerializationSettings settings = this.apiRequestPrameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)collectionSheet);
        }
        if (this.is(commandParam, "saveCollectionSheet")) {
            CommandWrapper commandRequest = builder.saveIndividualCollectionSheet().build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        return null;
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public CollectionSheetApiResource(CollectionSheetReadPlatformService collectionSheetReadPlatformService, ToApiJsonSerializer<Object> toApiJsonSerializer, FromJsonHelper fromJsonHelper, ApiRequestParameterHelper apiRequestPrameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context) {
        this.collectionSheetReadPlatformService = collectionSheetReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.fromJsonHelper = fromJsonHelper;
        this.apiRequestPrameterHelper = apiRequestPrameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
    }
}

