/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.service;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateralmanagement.data.ClientCollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralTemplateData;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanTransactionData;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.service.ClientCollateralManagementReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;

public class ClientCollateralManagementReadPlatformServiceImpl
implements ClientCollateralManagementReadPlatformService {
    private final PlatformSecurityContext context;
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;

    public List<ClientCollateralManagementData> getClientCollaterals(Long clientId, Long prodId) {
        return this.clientCollateralManagementRepositoryWrapper.getClientCollateralData(clientId, prodId);
    }

    public List<LoanCollateralTemplateData> getLoanCollateralTemplate(Long clientId) {
        this.context.authenticatedUser();
        List clientCollateralManagements = this.clientCollateralManagementRepositoryWrapper.getCollateralsPerClient(clientId);
        ArrayList<LoanCollateralTemplateData> loanCollateralTemplateDataList = new ArrayList<LoanCollateralTemplateData>();
        for (ClientCollateralManagement clientCollateralManagement : clientCollateralManagements) {
            loanCollateralTemplateDataList.add(LoanCollateralTemplateData.instanceOf((ClientCollateralManagement)clientCollateralManagement));
        }
        return loanCollateralTemplateDataList;
    }

    public ClientCollateralManagementData getClientCollateralManagementData(Long collateralId) {
        ClientCollateralManagement clientCollateralManagement = this.clientCollateralManagementRepositoryWrapper.getCollateral(collateralId);
        BigDecimal basePrice = clientCollateralManagement.getCollaterals().getBasePrice();
        BigDecimal pctToBase = clientCollateralManagement.getCollaterals().getPctToBase().divide(BigDecimal.valueOf(100L));
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal totalCollateral = BigDecimal.ZERO;
        BigDecimal quantity = clientCollateralManagement.getQuantity();
        if (quantity.compareTo(BigDecimal.ZERO) != 0) {
            total = basePrice.multiply(quantity);
            totalCollateral = total.multiply(pctToBase);
        }
        Set loanCollateralManagementSet = clientCollateralManagement.getLoanCollateralManagementSet();
        ArrayList<LoanTransactionData> loanTransactionDataList = new ArrayList<LoanTransactionData>();
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagementSet) {
            if (loanCollateralManagement.getLoanTransaction() == null) continue;
            Long transactionId = (Long)loanCollateralManagement.getLoanTransaction().getId();
            LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findById((Object)transactionId).orElseThrow(() -> new LoanTransactionNotFoundException(transactionId));
            LoanTransactionData loanTransactionData = LoanTransactionData.instance((Long)((Long)loanTransaction.getLoan().getId()), (OffsetDateTime)loanTransaction.getCreatedDate().orElse(null), (BigDecimal)loanTransaction.getOutstandingLoanBalance(), (BigDecimal)loanTransaction.getPrincipalPortion());
            loanTransactionDataList.add(loanTransactionData);
        }
        return ClientCollateralManagementData.instance((String)clientCollateralManagement.getCollaterals().getName(), (BigDecimal)clientCollateralManagement.getQuantity(), (BigDecimal)total, (BigDecimal)totalCollateral, (Long)((Long)clientCollateralManagement.getClient().getId()), loanTransactionDataList, (Long)((Long)clientCollateralManagement.getId()));
    }

    @Generated
    public ClientCollateralManagementReadPlatformServiceImpl(PlatformSecurityContext context, ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper, LoanTransactionRepository loanTransactionRepository) {
        this.context = context;
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
    }
}

