/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateralmanagement.api.ClientCollateralManagementApiResourceSwagger;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementJsonInputParams;
import org.apache.fineract.portfolio.collateralmanagement.data.ClientCollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralTemplateData;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.service.ClientCollateralManagementReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients/{clientId}/collaterals")
@Component
@Tag(name="Client Collateral Management", description="Client Collateral Management is for managing collateral operations")
public class ClientCollateralManagementApiResource {
    private final DefaultToApiJsonSerializer<ClientCollateralManagement> apiJsonSerializerService;
    private final DefaultToApiJsonSerializer<ClientCollateralManagementData> apiJsonSerializerDataService;
    private final DefaultToApiJsonSerializer<LoanCollateralTemplateData> apiJsonSerializerForLoanCollateralTemplateService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final ClientCollateralManagementReadPlatformService clientCollateralManagementReadPlatformService;
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("name", "quantity", "total", "totalCollateral", "clientId", "loanTransactionData"));

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Get Clients Collateral Products", description="Get Collateral Product of a Client")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.GetClientCollateralManagementsResponse.class)))})})
    public String getClientCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo, @QueryParam(value="prodId") @Parameter(description="prodId") Long prodId) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.CLIENT_COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        List collateralProductList = null;
        collateralProductList = this.clientCollateralManagementReadPlatformService.getClientCollaterals(clientId, prodId);
        return this.apiJsonSerializerDataService.serialize((Object)collateralProductList);
    }

    @GET
    @Path(value="{clientCollateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Get Client Collateral Data", description="Get Client Collateral Data")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.GetClientCollateralManagementsResponse.class))})})
    public String getClientCollateralData(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="clientCollateralId") @Parameter(description="clientCollateralId") Long collateralId) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.CLIENT_COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        ClientCollateralManagementData clientCollateralManagementData = this.clientCollateralManagementReadPlatformService.getClientCollateralManagementData(collateralId);
        return this.apiJsonSerializerDataService.serialize((Object)clientCollateralManagementData);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Client Collateral Template", description="Get Client Collateral Template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.GetLoanCollateralManagementTemplate.class)))})})
    public String getClientCollateralTemplate(@Context UriInfo uriInfo, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        List loanCollateralTemplateDataList = this.clientCollateralManagementReadPlatformService.getLoanCollateralTemplate(clientId);
        return this.apiJsonSerializerForLoanCollateralTemplateService.serialize((Object)loanCollateralTemplateDataList);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Add New Collateral For a Client", description="Add New Collateral For a Client")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PostClientCollateralRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PostClientCollateralResponse.class))})})
    public String addCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Parameter(hidden=true) String apiJsonRequestBody) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().addClientCollateralProduct(clientId).withJson(apiJsonRequestBody).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Update New Collateral of a Client", description="Update New Collateral of a Client")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PutClientCollateralRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PutClientCollateralResponse.class))})})
    public String updateCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) String apiJsonRequestBody) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().updateClientCollateralProduct(clientId, collateralId).withJson(apiJsonRequestBody).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Delete Client Collateral", description="Delete Client Collateral")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.DeleteClientCollateralResponse.class))})})
    public String deleteCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().deleteClientCollateralProduct(collateralId, clientId).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @Generated
    public ClientCollateralManagementApiResource(DefaultToApiJsonSerializer<ClientCollateralManagement> apiJsonSerializerService, DefaultToApiJsonSerializer<ClientCollateralManagementData> apiJsonSerializerDataService, DefaultToApiJsonSerializer<LoanCollateralTemplateData> apiJsonSerializerForLoanCollateralTemplateService, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, CodeValueReadPlatformService codeValueReadPlatformService, ClientCollateralManagementReadPlatformService clientCollateralManagementReadPlatformService) {
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiJsonSerializerDataService = apiJsonSerializerDataService;
        this.apiJsonSerializerForLoanCollateralTemplateService = apiJsonSerializerForLoanCollateralTemplateService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.clientCollateralManagementReadPlatformService = clientCollateralManagementReadPlatformService;
    }
}

