/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateral.api.CollateralsApiResourceSwagger;
import org.apache.fineract.portfolio.collateral.data.CollateralData;
import org.apache.fineract.portfolio.collateral.service.CollateralReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans/{loanId}/collaterals")
@Component
@Tag(name="Loan Collateral", description="In lending agreements, collateral is a borrower's pledge of specific property to a lender, to secure repayment of a loan. The collateral serves as protection for a lender against a borrower's default - that is, any borrower failing to pay the principal and interest under the terms of a loan obligation. If a borrower does default on a loan (due to insolvency or other event), that borrower forfeits (gives up) the property pledged as collateral - and the lender then becomes the owner of the collateral")
public class CollateralsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "type", "value", "description", "allowedCollateralTypes", "currency"));
    private static final String RESOURCE_NAME_FOR_PERMISSION = "COLLATERAL";
    private final CollateralReadPlatformService collateralReadPlatformService;
    private final DefaultToApiJsonSerializer<CollateralData> apiJsonSerializerService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Collateral Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\nExample Request:\n\nloans/1/collaterals/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.GetLoansLoanIdCollateralsTemplateResponse.class))})})
    public String newCollateralTemplate(@Context UriInfo uriInfo, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
        CollateralData collateralData = CollateralData.template((Collection)codeValues);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Object)collateralData, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Collaterals", description="Example Requests:\n\nloans/1/collaterals\n\n\nloans/1/collaterals?fields=value,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CollateralsApiResourceSwagger.GetLoansLoanIdCollateralsResponse.class)))})})
    public String retrieveCollateralDetails(@Context UriInfo uriInfo, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        List collateralDatas = this.collateralReadPlatformService.retrieveCollateralsForValidLoan(loanId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.apiJsonSerializerService.serialize(settings, (Collection)collateralDatas, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Collateral", description="Example Requests:\n\n/loans/1/collaterals/1\n\n\n/loans/1/collaterals/1?fields=description,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.GetLoansLoanIdCollateralsResponse.class))})})
    public String retrieveCollateralDetails(@Context UriInfo uriInfo, @PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long CollateralId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        CollateralData collateralData = this.collateralReadPlatformService.retrieveCollateral(loanId, CollateralId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
            collateralData = collateralData.template(collateralData, (Collection)codeValues);
        }
        return this.apiJsonSerializerService.serialize(settings, (Object)collateralData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Collateral", description="Note: Currently, Collaterals may be added only before a Loan is approved")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PostLoansLoanIdCollateralsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PostLoansLoanIdCollateralsResponse.class))})})
    public String createCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCollateral(loanId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializerService.serialize((Object)result);
    }

    @PUT
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Collateral")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PutLoansLoandIdCollateralsCollateralIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.PutLoansLoanIdCollateralsCollateralIdResponse.class))})})
    public String updateCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCollateral(loanId, collateralId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializerService.serialize((Object)result);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Remove a Collateral", description="Note: A collateral can only be removed from Loans that are not yet approved.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralsApiResourceSwagger.DeleteLoansLoanIdCollateralsCollateralIdResponse.class))})})
    public String deleteCollateral(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCollateral(loanId, collateralId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializerService.serialize((Object)result);
    }

    @Generated
    public CollateralsApiResource(CollateralReadPlatformService collateralReadPlatformService, DefaultToApiJsonSerializer<CollateralData> apiJsonSerializerService, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.collateralReadPlatformService = collateralReadPlatformService;
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }
}

