/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.api.ClientIdentifiersApiResourceSwagger;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.data.ClientIdentifierData;
import org.apache.fineract.portfolio.client.exception.DuplicateClientIdentifierException;
import org.apache.fineract.portfolio.client.service.ClientIdentifierReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients/{clientId}/identifiers")
@Component
@Tag(name="Client Identifier", description="Client Identifiers refer to documents that are used to uniquely identify a customer\nEx: Drivers License, Passport, Ration card etc ")
public class ClientIdentifiersApiResource {
    private static final Set<String> CLIENT_IDENTIFIER_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "clientId", "documentType", "documentKey", "description", "allowedDocumentTypes"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CLIENTIDENTIFIER";
    private final PlatformSecurityContext context;
    private final ClientReadPlatformService clientReadPlatformService;
    private final ClientIdentifierReadPlatformService clientIdentifierReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final DefaultToApiJsonSerializer<ClientIdentifierData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all Identifiers for a Client", description="Example Requests:\nclients/1/identifiers\n\n\nclients/1/identifiers?fields=documentKey,documentType,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.GetClientsClientIdIdentifiersResponse.class)))})})
    public String retrieveAllClientIdentifiers(@Context UriInfo uriInfo, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection clientIdentifiers = this.clientIdentifierReadPlatformService.retrieveClientIdentifiers(clientId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, clientIdentifiers, CLIENT_IDENTIFIER_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Client Identifier Details Template", description="This is a convenience resource useful for building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\n Field Defaults\n Allowed description Lists\n\n\nExample Request:\nclients/1/identifiers/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.GetClientsClientIdIdentifiersTemplateResponse.class))})})
    public String newClientIdentifierDetails(@Context UriInfo uriInfo, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("Customer Identifier");
        ClientIdentifierData clientIdentifierData = ClientIdentifierData.template((Collection)codeValues);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientIdentifierData, CLIENT_IDENTIFIER_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an Identifier for a Client", description="Mandatory Fields\ndocumentKey, documentTypeId ")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.PostClientsClientIdIdentifiersRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.PostClientsClientIdIdentifiersResponse.class))})})
    public String createClientIdentifier(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        try {
            CommandWrapper commandRequest = new CommandWrapperBuilder().createClientIdentifier(clientId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        catch (DuplicateClientIdentifierException e) {
            DuplicateClientIdentifierException rethrowas = e;
            if (e.getDocumentTypeId() != null) {
                ClientData clientInfo = this.clientReadPlatformService.retrieveClientByIdentifier(e.getDocumentTypeId(), e.getIdentifierKey());
                rethrowas = new DuplicateClientIdentifierException(clientInfo.getDisplayName(), clientInfo.getOfficeName(), e.getIdentifierType(), e.getIdentifierKey());
            }
            throw rethrowas;
        }
    }

    @GET
    @Path(value="{identifierId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Identifier", description="Example Requests:\nclients/1/identifier/2\n\n\nclients/1/identifier/2?template=true\n\nclients/1/identifiers/2?fields=documentKey,documentType,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.GetClientsClientIdIdentifiersResponse.class))})})
    public String retrieveClientIdentifiers(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="identifierId") @Parameter(description="identifierId") Long clientIdentifierId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        ClientIdentifierData clientIdentifierData = this.clientIdentifierReadPlatformService.retrieveClientIdentifier(clientId, clientIdentifierId);
        if (settings.isTemplate()) {
            List codeValues = this.codeValueReadPlatformService.retrieveCodeValuesByCode("Customer Identifier");
            clientIdentifierData = ClientIdentifierData.template((ClientIdentifierData)clientIdentifierData, (Collection)codeValues);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)clientIdentifierData, CLIENT_IDENTIFIER_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{identifierId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Client Identifier", description="Updates a Client Identifier")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.PutClientsClientIdIdentifiersIdentifierIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.PutClientsClientIdIdentifiersIdentifierIdResponse.class))})})
    public String updateClientIdentifer(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="identifierId") @Parameter(description="identifierId") Long clientIdentifierId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        try {
            CommandWrapper commandRequest = new CommandWrapperBuilder().updateClientIdentifier(clientId, clientIdentifierId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        catch (DuplicateClientIdentifierException e) {
            DuplicateClientIdentifierException reThrowAs = e;
            if (e.getDocumentTypeId() != null) {
                ClientData clientInfo = this.clientReadPlatformService.retrieveClientByIdentifier(e.getDocumentTypeId(), e.getIdentifierKey());
                reThrowAs = new DuplicateClientIdentifierException(clientInfo.getDisplayName(), clientInfo.getOfficeName(), e.getIdentifierType(), e.getIdentifierKey());
            }
            throw reThrowAs;
        }
    }

    @DELETE
    @Path(value="{identifierId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Client Identifier", description="Deletes a Client Identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientIdentifiersApiResourceSwagger.DeleteClientsClientIdIdentifiersIdentifierIdResponse.class))})})
    public String deleteClientIdentifier(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="identifierId") @Parameter(description="identifierId") Long clientIdentifierId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteClientIdentifier(clientId, clientIdentifierId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ClientIdentifiersApiResource(PlatformSecurityContext context, ClientReadPlatformService clientReadPlatformService, ClientIdentifierReadPlatformService clientIdentifierReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, DefaultToApiJsonSerializer<ClientIdentifierData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.clientReadPlatformService = clientReadPlatformService;
        this.clientIdentifierReadPlatformService = clientIdentifierReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

