/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.domain;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CalendarInstanceRepository
extends JpaRepository<CalendarInstance, Long>,
JpaSpecificationExecutor<CalendarInstance> {
    public CalendarInstance findByCalendarIdAndEntityIdAndEntityTypeId(Long var1, Long var2, Integer var3);

    public Collection<CalendarInstance> findByEntityIdAndEntityTypeId(Long var1, Integer var2);

    public CalendarInstance findByEntityIdAndEntityTypeIdAndCalendarTypeId(Long var1, Integer var2, Integer var3);

    @Query(value="select ci from CalendarInstance ci where ci.entityId = :entityId and ci.entityTypeId = :entityTypeId")
    public CalendarInstance findCalendarInstaneByEntityId(@Param(value="entityId") Long var1, @Param(value="entityTypeId") Integer var2);

    public Collection<CalendarInstance> findByCalendarIdAndEntityTypeId(Long var1, Integer var2);

    @Query(value="select ci from CalendarInstance ci where ci.entityId in (select loan.id from Loan loan where loan.client.id = :clientId and loan.group.id = :groupId and (loan.loanStatus = 100 or loan.loanStatus = 200 or loan.loanStatus = 300)) and ci.entityTypeId = 3")
    public List<CalendarInstance> findCalendarInstancesForActiveLoansByGroupIdAndClientId(@Param(value="groupId") Long var1, @Param(value="clientId") Long var2);

    @Query(value="SELECT COUNT(ci.id) FROM CalendarInstance ci, Loan loan WHERE loan.id = ci.entityId AND ci.entityTypeId = 3 AND ci.calendar.id = :calendarId AND loan.loanStatus IN :loanStatuses ")
    public Integer countOfLoansSyncedWithCalendar(@Param(value="calendarId") Long var1, @Param(value="loanStatuses") Collection<Integer> var2);
}

