/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.service;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.FieldConfigurationData;
import org.apache.fineract.portfolio.address.service.FieldConfigurationReadPlatformService;
import org.apache.fineract.portfolio.address.service.FieldConfigurationReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class FieldConfigurationReadPlatformServiceImpl
implements FieldConfigurationReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public FieldConfigurationReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<FieldConfigurationData> retrieveFieldConfiguration(String entity) {
        this.context.authenticatedUser();
        FieldMapper rm = new FieldMapper();
        String sql = "select " + rm.schema() + " where fld.entity=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entity});
    }

    public List<FieldConfigurationData> retrieveFieldConfigurationList(String entity) {
        this.context.authenticatedUser();
        FieldMapper rm = new FieldMapper();
        String sql = "select " + rm.schema() + " where fld.entity=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entity});
    }
}

