/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.api.EntityFieldConfigurationApiResourcesSwagger;
import org.apache.fineract.portfolio.address.data.FieldConfigurationData;
import org.apache.fineract.portfolio.address.service.FieldConfigurationReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/fieldconfiguration/{entity}")
@Component
@Tag(name="Entity Field Configuration", description="Entity Field configuration API is a generic and extensible \nwherein various entities and subentities can be related.\nAlso it gives the user an ability to enable/disable fields,\nadd regular expression for validation")
public class EntityFieldConfigurationApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("clientAddressId", "client_id", "address_id", "address_type_id", "isActive", "fieldConfigurationId", "entity", "table", "field", "is_enabled", "is_mandatory", "validation_regex"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "Address";
    private final PlatformSecurityContext context;
    private final FieldConfigurationReadPlatformService readPlatformServicefld;
    private final DefaultToApiJsonSerializer<FieldConfigurationData> toApiJsonSerializerfld;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the Entity Field Configuration", description="It retrieves all the Entity Field Configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EntityFieldConfigurationApiResourcesSwagger.GetFieldConfigurationEntityResponse.class)))})})
    public String getAddresses(@PathParam(value="entity") @Parameter(description="entity") String entityname, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection fldconfig = this.readPlatformServicefld.retrieveFieldConfiguration(entityname);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerfld.serialize(settings, fldconfig, RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public EntityFieldConfigurationApiResource(PlatformSecurityContext context, FieldConfigurationReadPlatformService readPlatformServicefld, DefaultToApiJsonSerializer<FieldConfigurationData> toApiJsonSerializerfld, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.readPlatformServicefld = readPlatformServicefld;
        this.toApiJsonSerializerfld = toApiJsonSerializerfld;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

