/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_account_transfer_transaction")
public class AccountTransferTransaction
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="account_transfer_details_id", nullable=true)
    private AccountTransferDetails accountTransferDetails;
    @ManyToOne
    @JoinColumn(name="from_savings_transaction_id", nullable=true)
    private SavingsAccountTransaction fromSavingsTransaction;
    @ManyToOne
    @JoinColumn(name="to_savings_transaction_id", nullable=true)
    private SavingsAccountTransaction toSavingsTransaction;
    @ManyToOne
    @JoinColumn(name="to_loan_transaction_id", nullable=true)
    private LoanTransaction toLoanTransaction;
    @ManyToOne
    @JoinColumn(name="from_loan_transaction_id", nullable=true)
    private LoanTransaction fromLoanTransaction;
    @Column(name="is_reversed", nullable=false)
    private boolean reversed = false;
    @Column(name="transaction_date")
    private LocalDate date;
    @Embedded
    private MonetaryCurrency currency;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    @Column(name="description", length=100)
    private String description;
    static final long serialVersionUID = -380629379608882449L;

    public static AccountTransferTransaction savingsToSavingsTransfer(AccountTransferDetails accountTransferDetails, SavingsAccountTransaction withdrawal, SavingsAccountTransaction deposit, LocalDate transactionDate, Money transactionAmount, String description) {
        return new AccountTransferTransaction(accountTransferDetails, withdrawal, deposit, null, null, transactionDate, transactionAmount, description);
    }

    public static AccountTransferTransaction savingsToLoanTransfer(AccountTransferDetails accountTransferDetails, SavingsAccountTransaction withdrawal, LoanTransaction loanRepaymentTransaction, LocalDate transactionDate, Money transactionAmount, String description) {
        return new AccountTransferTransaction(accountTransferDetails, withdrawal, null, loanRepaymentTransaction, null, transactionDate, transactionAmount, description);
    }

    public static AccountTransferTransaction loanTosavingsTransfer(AccountTransferDetails accountTransferDetails, SavingsAccountTransaction deposit, LoanTransaction loanRefundTransaction, LocalDate transactionDate, Money transactionAmount, String description) {
        return new AccountTransferTransaction(accountTransferDetails, null, deposit, null, loanRefundTransaction, transactionDate, transactionAmount, description);
    }

    protected AccountTransferTransaction() {
    }

    private AccountTransferTransaction(AccountTransferDetails accountTransferDetails, SavingsAccountTransaction withdrawal, SavingsAccountTransaction deposit, LoanTransaction loanRepaymentTransaction, LoanTransaction loanRefundTransaction, LocalDate transactionDate, Money transactionAmount, String description) {
        this.accountTransferDetails = accountTransferDetails;
        this.fromLoanTransaction = loanRefundTransaction;
        this.fromSavingsTransaction = withdrawal;
        this.toSavingsTransaction = deposit;
        this.toLoanTransaction = loanRepaymentTransaction;
        this.date = transactionDate;
        this.currency = transactionAmount.getCurrency();
        this.amount = transactionAmount.getAmountDefaultedToNullIfZero();
        this.description = description;
    }

    public LoanTransaction getFromLoanTransaction() {
        return this._persistence_get_fromLoanTransaction();
    }

    public SavingsAccountTransaction getFromTransaction() {
        return this._persistence_get_fromSavingsTransaction();
    }

    public LoanTransaction getToLoanTransaction() {
        return this._persistence_get_toLoanTransaction();
    }

    public SavingsAccountTransaction getToSavingsTransaction() {
        return this._persistence_get_toSavingsTransaction();
    }

    public void reverse() {
        this._persistence_set_reversed(true);
    }

    public void updateToLoanTransaction(LoanTransaction toLoanTransaction) {
        this._persistence_set_toLoanTransaction(toLoanTransaction);
    }

    public AccountTransferDetails accountTransferDetails() {
        return this._persistence_get_accountTransferDetails();
    }

    public static AccountTransferTransaction loanToLoanTransfer(AccountTransferDetails accountTransferDetails, LoanTransaction disburseTransaction, LoanTransaction repaymentTransaction, LocalDate transactionDate, Money transactionMonetaryAmount, String description) {
        return new AccountTransferTransaction(accountTransferDetails, null, null, repaymentTransaction, disburseTransaction, transactionDate, transactionMonetaryAmount, description);
    }

    @Generated
    public AccountTransferDetails getAccountTransferDetails() {
        return this._persistence_get_accountTransferDetails();
    }

    @Generated
    public SavingsAccountTransaction getFromSavingsTransaction() {
        return this._persistence_get_fromSavingsTransaction();
    }

    @Generated
    public boolean isReversed() {
        return this._persistence_get_reversed();
    }

    @Generated
    public LocalDate getDate() {
        return this._persistence_get_date();
    }

    @Generated
    public MonetaryCurrency getCurrency() {
        return this._persistence_get_currency();
    }

    @Generated
    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    @Generated
    public String getDescription() {
        return this._persistence_get_description();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountTransferTransaction();
    }

    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "fromSavingsTransaction") {
            return this.fromSavingsTransaction;
        }
        if (string == "accountTransferDetails") {
            return this.accountTransferDetails;
        }
        if (string == "toSavingsTransaction") {
            return this.toSavingsTransaction;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "toLoanTransaction") {
            return this.toLoanTransaction;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "fromLoanTransaction") {
            return this.fromLoanTransaction;
        }
        if (string == "reversed") {
            return this.reversed;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (LocalDate)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "fromSavingsTransaction") {
            this.fromSavingsTransaction = (SavingsAccountTransaction)object;
            return;
        }
        if (string == "accountTransferDetails") {
            this.accountTransferDetails = (AccountTransferDetails)object;
            return;
        }
        if (string == "toSavingsTransaction") {
            this.toSavingsTransaction = (SavingsAccountTransaction)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "toLoanTransaction") {
            this.toLoanTransaction = (LoanTransaction)object;
            return;
        }
        if (string == "currency") {
            this.currency = (MonetaryCurrency)object;
            return;
        }
        if (string == "fromLoanTransaction") {
            this.fromLoanTransaction = (LoanTransaction)object;
            return;
        }
        if (string == "reversed") {
            this.reversed = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(LocalDate localDate) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", (Object)this.date, (Object)localDate);
        this.date = localDate;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public SavingsAccountTransaction _persistence_get_fromSavingsTransaction() {
        this._persistence_checkFetched("fromSavingsTransaction");
        return this.fromSavingsTransaction;
    }

    public void _persistence_set_fromSavingsTransaction(SavingsAccountTransaction savingsAccountTransaction) {
        this._persistence_checkFetchedForSet("fromSavingsTransaction");
        this._persistence_propertyChange("fromSavingsTransaction", (Object)this.fromSavingsTransaction, (Object)savingsAccountTransaction);
        this.fromSavingsTransaction = savingsAccountTransaction;
    }

    public AccountTransferDetails _persistence_get_accountTransferDetails() {
        this._persistence_checkFetched("accountTransferDetails");
        return this.accountTransferDetails;
    }

    public void _persistence_set_accountTransferDetails(AccountTransferDetails accountTransferDetails) {
        this._persistence_checkFetchedForSet("accountTransferDetails");
        this._persistence_propertyChange("accountTransferDetails", (Object)this.accountTransferDetails, (Object)accountTransferDetails);
        this.accountTransferDetails = accountTransferDetails;
    }

    public SavingsAccountTransaction _persistence_get_toSavingsTransaction() {
        this._persistence_checkFetched("toSavingsTransaction");
        return this.toSavingsTransaction;
    }

    public void _persistence_set_toSavingsTransaction(SavingsAccountTransaction savingsAccountTransaction) {
        this._persistence_checkFetchedForSet("toSavingsTransaction");
        this._persistence_propertyChange("toSavingsTransaction", (Object)this.toSavingsTransaction, (Object)savingsAccountTransaction);
        this.toSavingsTransaction = savingsAccountTransaction;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", (Object)this.description, (Object)string);
        this.description = string;
    }

    public LoanTransaction _persistence_get_toLoanTransaction() {
        this._persistence_checkFetched("toLoanTransaction");
        return this.toLoanTransaction;
    }

    public void _persistence_set_toLoanTransaction(LoanTransaction loanTransaction) {
        this._persistence_checkFetchedForSet("toLoanTransaction");
        this._persistence_propertyChange("toLoanTransaction", (Object)this.toLoanTransaction, (Object)loanTransaction);
        this.toLoanTransaction = loanTransaction;
    }

    public MonetaryCurrency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        return this.currency;
    }

    public void _persistence_set_currency(MonetaryCurrency monetaryCurrency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_propertyChange("currency", (Object)this.currency, (Object)monetaryCurrency);
        this.currency = monetaryCurrency;
    }

    public LoanTransaction _persistence_get_fromLoanTransaction() {
        this._persistence_checkFetched("fromLoanTransaction");
        return this.fromLoanTransaction;
    }

    public void _persistence_set_fromLoanTransaction(LoanTransaction loanTransaction) {
        this._persistence_checkFetchedForSet("fromLoanTransaction");
        this._persistence_propertyChange("fromLoanTransaction", (Object)this.fromLoanTransaction, (Object)loanTransaction);
        this.fromLoanTransaction = loanTransaction;
    }

    public boolean _persistence_get_reversed() {
        this._persistence_checkFetched("reversed");
        return this.reversed;
    }

    public void _persistence_set_reversed(boolean bl) {
        this._persistence_checkFetchedForSet("reversed");
        this._persistence_propertyChange("reversed", (Object)new Boolean(this.reversed), (Object)new Boolean(bl));
        this.reversed = bl;
    }
}

