/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.temporal.ChronoField;
import java.util.Collection;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferData;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;

public final class StandingInstructionData {
    private final Long id;
    private final Long accountDetailId;
    private final String name;
    private final OfficeData fromOffice;
    private final ClientData fromClient;
    private final EnumOptionData fromAccountType;
    private final PortfolioAccountData fromAccount;
    private final OfficeData toOffice;
    private final ClientData toClient;
    private final EnumOptionData toAccountType;
    private final PortfolioAccountData toAccount;
    private final EnumOptionData transferType;
    private final EnumOptionData priority;
    private final EnumOptionData instructionType;
    private final EnumOptionData status;
    private final BigDecimal amount;
    private final LocalDate validFrom;
    private final LocalDate validTill;
    private final EnumOptionData recurrenceType;
    private final EnumOptionData recurrenceFrequency;
    private final Integer recurrenceInterval;
    private final MonthDay recurrenceOnMonthDay;
    private final Page<AccountTransferData> transactions;
    private final Collection<OfficeData> fromOfficeOptions;
    private final Collection<ClientData> fromClientOptions;
    private final Collection<EnumOptionData> fromAccountTypeOptions;
    private final Collection<PortfolioAccountData> fromAccountOptions;
    private final Collection<OfficeData> toOfficeOptions;
    private final Collection<ClientData> toClientOptions;
    private final Collection<EnumOptionData> toAccountTypeOptions;
    private final Collection<PortfolioAccountData> toAccountOptions;
    private final Collection<EnumOptionData> transferTypeOptions;
    private final Collection<EnumOptionData> statusOptions;
    private final Collection<EnumOptionData> instructionTypeOptions;
    private final Collection<EnumOptionData> priorityOptions;
    private final Collection<EnumOptionData> recurrenceTypeOptions;
    private final Collection<EnumOptionData> recurrenceFrequencyOptions;

    public static StandingInstructionData template(Collection<OfficeData> fromOfficeOptions, Collection<ClientData> fromClientOptions, Collection<EnumOptionData> fromAccountTypeOptions, Collection<PortfolioAccountData> fromAccountOptions, Collection<OfficeData> toOfficeOptions, Collection<ClientData> toClientOptions, Collection<EnumOptionData> toAccountTypeOptions, Collection<PortfolioAccountData> toAccountOptions, Collection<EnumOptionData> transferTypeOptions, Collection<EnumOptionData> statusOptions, Collection<EnumOptionData> instructionTypeOptions, Collection<EnumOptionData> priorityOptions, Collection<EnumOptionData> recurrenceTypeOptions, Collection<EnumOptionData> recurrenceFrequencyOptions) {
        Long id = null;
        Long accountDetailId = null;
        String name = null;
        OfficeData fromOffice = null;
        OfficeData toOffice = null;
        ClientData fromClient = null;
        ClientData toClient = null;
        EnumOptionData fromAccountType = null;
        PortfolioAccountData fromAccount = null;
        EnumOptionData toAccountType = null;
        PortfolioAccountData toAccount = null;
        EnumOptionData transferType = null;
        EnumOptionData priority = null;
        EnumOptionData instructionType = null;
        EnumOptionData status = null;
        BigDecimal amount = null;
        LocalDate validFrom = null;
        LocalDate validTill = null;
        EnumOptionData recurrenceType = null;
        EnumOptionData recurrenceFrequency = null;
        Integer recurrenceInterval = null;
        MonthDay recurrenceOnMonthDay = null;
        Page transactions = null;
        return new StandingInstructionData(id, accountDetailId, name, fromOffice, fromClient, fromAccountType, fromAccount, toOffice, toClient, toAccountType, toAccount, transferType, priority, instructionType, status, amount, validFrom, validTill, recurrenceType, recurrenceFrequency, recurrenceInterval, recurrenceOnMonthDay, transactions, fromOfficeOptions, fromClientOptions, fromAccountTypeOptions, fromAccountOptions, toOfficeOptions, toClientOptions, toAccountTypeOptions, toAccountOptions, transferTypeOptions, statusOptions, instructionTypeOptions, priorityOptions, recurrenceTypeOptions, recurrenceFrequencyOptions);
    }

    public static StandingInstructionData instance(Long id, Long accountDetailId, String name, OfficeData fromOffice, OfficeData toOffice, ClientData fromClient, ClientData toClient, EnumOptionData fromAccountType, PortfolioAccountData fromAccount, EnumOptionData toAccountType, PortfolioAccountData toAccount, EnumOptionData transferType, EnumOptionData priority, EnumOptionData instructionType, EnumOptionData status, BigDecimal amount, LocalDate validFrom, LocalDate validTill, EnumOptionData recurrenceType, EnumOptionData recurrenceFrequency, Integer recurrenceInterval, MonthDay recurrenceOnMonthDay) {
        Page transactions = null;
        Collection fromOfficeOptions = null;
        Collection fromClientOptions = null;
        Collection fromAccountTypeOptions = null;
        Collection fromAccountOptions = null;
        Collection toOfficeOptions = null;
        Collection toClientOptions = null;
        Collection toAccountTypeOptions = null;
        Collection toAccountOptions = null;
        Collection transferTypeOptions = null;
        Collection statusOptions = null;
        Collection instructionTypeOptions = null;
        Collection priorityOptions = null;
        Collection recurrenceTypeOptions = null;
        Collection recurrenceFrequencyOptions = null;
        return new StandingInstructionData(id, accountDetailId, name, fromOffice, fromClient, fromAccountType, fromAccount, toOffice, toClient, toAccountType, toAccount, transferType, priority, instructionType, status, amount, validFrom, validTill, recurrenceType, recurrenceFrequency, recurrenceInterval, recurrenceOnMonthDay, transactions, fromOfficeOptions, fromClientOptions, fromAccountTypeOptions, fromAccountOptions, toOfficeOptions, toClientOptions, toAccountTypeOptions, toAccountOptions, transferTypeOptions, statusOptions, instructionTypeOptions, priorityOptions, recurrenceTypeOptions, recurrenceFrequencyOptions);
    }

    public static StandingInstructionData withTemplateData(StandingInstructionData instructionData, StandingInstructionData templateData) {
        return new StandingInstructionData(instructionData.id, instructionData.accountDetailId, instructionData.name, instructionData.fromOffice, instructionData.fromClient, instructionData.fromAccountType, instructionData.fromAccount, instructionData.toOffice, instructionData.toClient, instructionData.toAccountType, instructionData.toAccount, instructionData.transferType, instructionData.priority, instructionData.instructionType, instructionData.status, instructionData.amount, instructionData.validFrom, instructionData.validTill, instructionData.recurrenceType, instructionData.recurrenceFrequency, instructionData.recurrenceInterval, instructionData.recurrenceOnMonthDay, instructionData.transactions, templateData.fromOfficeOptions, templateData.fromClientOptions, templateData.fromAccountTypeOptions, templateData.fromAccountOptions, templateData.toOfficeOptions, templateData.toClientOptions, templateData.toAccountTypeOptions, templateData.toAccountOptions, templateData.transferTypeOptions, templateData.statusOptions, templateData.instructionTypeOptions, templateData.priorityOptions, templateData.recurrenceTypeOptions, templateData.recurrenceFrequencyOptions);
    }

    private StandingInstructionData(Long id, Long accountDetailId, String name, OfficeData fromOffice, ClientData fromClient, EnumOptionData fromAccountType, PortfolioAccountData fromAccount, OfficeData toOffice, ClientData toClient, EnumOptionData toAccountType, PortfolioAccountData toAccount, EnumOptionData transferType, EnumOptionData priority, EnumOptionData instructionType, EnumOptionData status, BigDecimal amount, LocalDate validFrom, LocalDate validTill, EnumOptionData recurrenceType, EnumOptionData recurrenceFrequency, Integer recurrenceInterval, MonthDay recurrenceOnMonthDay, Page<AccountTransferData> transactions, Collection<OfficeData> fromOfficeOptions, Collection<ClientData> fromClientOptions, Collection<EnumOptionData> fromAccountTypeOptions, Collection<PortfolioAccountData> fromAccountOptions, Collection<OfficeData> toOfficeOptions, Collection<ClientData> toClientOptions, Collection<EnumOptionData> toAccountTypeOptions, Collection<PortfolioAccountData> toAccountOptions, Collection<EnumOptionData> transferTypeOptions, Collection<EnumOptionData> statusOptions, Collection<EnumOptionData> instructionTypeOptions, Collection<EnumOptionData> priorityOptions, Collection<EnumOptionData> recurrenceTypeOptions, Collection<EnumOptionData> recurrenceFrequencyOptions) {
        this.id = id;
        this.accountDetailId = accountDetailId;
        this.name = name;
        this.fromOffice = fromOffice;
        this.fromClient = fromClient;
        this.fromAccountType = fromAccountType;
        this.fromAccount = fromAccount;
        this.toOffice = toOffice;
        this.toClient = toClient;
        this.toAccountType = toAccountType;
        this.toAccount = toAccount;
        this.transferType = transferType;
        this.priority = priority;
        this.instructionType = instructionType;
        this.status = status;
        this.amount = amount;
        this.validFrom = validFrom;
        this.validTill = validTill;
        this.recurrenceType = recurrenceType;
        this.recurrenceFrequency = recurrenceFrequency;
        this.recurrenceInterval = recurrenceInterval;
        this.recurrenceOnMonthDay = recurrenceOnMonthDay;
        this.fromOfficeOptions = fromOfficeOptions;
        this.fromClientOptions = fromClientOptions;
        this.fromAccountTypeOptions = fromAccountTypeOptions;
        this.fromAccountOptions = fromAccountOptions;
        this.toOfficeOptions = toOfficeOptions;
        this.toClientOptions = toClientOptions;
        this.toAccountTypeOptions = toAccountTypeOptions;
        this.toAccountOptions = toAccountOptions;
        this.transferTypeOptions = transferTypeOptions;
        this.statusOptions = statusOptions;
        this.instructionTypeOptions = instructionTypeOptions;
        this.priorityOptions = priorityOptions;
        this.recurrenceTypeOptions = recurrenceTypeOptions;
        this.recurrenceFrequencyOptions = recurrenceFrequencyOptions;
        this.transactions = transactions;
    }

    public static StandingInstructionData template(OfficeData fromOffice, ClientData fromClient, EnumOptionData fromAccountType, PortfolioAccountData fromAccount, LocalDate transferDate, OfficeData toOffice, ClientData toClient, EnumOptionData toAccountType, PortfolioAccountData toAccount, Collection<OfficeData> fromOfficeOptions, Collection<ClientData> fromClientOptions, Collection<EnumOptionData> fromAccountTypeOptions, Collection<PortfolioAccountData> fromAccountOptions, Collection<OfficeData> toOfficeOptions, Collection<ClientData> toClientOptions, Collection<EnumOptionData> toAccountTypeOptions, Collection<PortfolioAccountData> toAccountOptions, Collection<EnumOptionData> transferTypeOptions, Collection<EnumOptionData> statusOptions, Collection<EnumOptionData> instructionTypeOptions, Collection<EnumOptionData> priorityOptions, Collection<EnumOptionData> recurrenceTypeOptions, Collection<EnumOptionData> recurrenceFrequencyOptions) {
        Long id = null;
        Long accountDetailId = null;
        String name = null;
        EnumOptionData transferType = null;
        EnumOptionData priority = null;
        EnumOptionData instructionType = null;
        EnumOptionData status = null;
        BigDecimal amount = null;
        LocalDate validFrom = null;
        LocalDate validTill = null;
        EnumOptionData recurrenceType = null;
        EnumOptionData recurrenceFrequency = null;
        Integer recurrenceInterval = null;
        MonthDay recurrenceOnMonthDay = null;
        Page transactions = null;
        return new StandingInstructionData(id, accountDetailId, name, fromOffice, fromClient, fromAccountType, fromAccount, toOffice, toClient, toAccountType, toAccount, transferType, priority, instructionType, status, amount, validFrom, validTill, recurrenceType, recurrenceFrequency, recurrenceInterval, recurrenceOnMonthDay, transactions, fromOfficeOptions, fromClientOptions, fromAccountTypeOptions, fromAccountOptions, toOfficeOptions, toClientOptions, toAccountTypeOptions, toAccountOptions, transferTypeOptions, statusOptions, instructionTypeOptions, priorityOptions, recurrenceTypeOptions, recurrenceFrequencyOptions);
    }

    public static StandingInstructionData withTransferData(StandingInstructionData instructionData, Page<AccountTransferData> transactions) {
        return new StandingInstructionData(instructionData.id, instructionData.accountDetailId, instructionData.name, instructionData.fromOffice, instructionData.fromClient, instructionData.fromAccountType, instructionData.fromAccount, instructionData.toOffice, instructionData.toClient, instructionData.toAccountType, instructionData.toAccount, instructionData.transferType, instructionData.priority, instructionData.instructionType, instructionData.status, instructionData.amount, instructionData.validFrom, instructionData.validTill, instructionData.recurrenceType, instructionData.recurrenceFrequency, instructionData.recurrenceInterval, instructionData.recurrenceOnMonthDay, transactions, instructionData.fromOfficeOptions, instructionData.fromClientOptions, instructionData.fromAccountTypeOptions, instructionData.fromAccountOptions, instructionData.toOfficeOptions, instructionData.toClientOptions, instructionData.toAccountTypeOptions, instructionData.toAccountOptions, instructionData.transferTypeOptions, instructionData.statusOptions, instructionData.instructionTypeOptions, instructionData.priorityOptions, instructionData.recurrenceTypeOptions, instructionData.recurrenceFrequencyOptions);
    }

    public StandingInstructionType instructionType() {
        StandingInstructionType standingInstructionType = null;
        if (this.instructionType != null) {
            standingInstructionType = StandingInstructionType.fromInt((Integer)((Long)this.instructionType.getId()).intValue());
        }
        return standingInstructionType;
    }

    public AccountTransferRecurrenceType recurrenceType() {
        AccountTransferRecurrenceType recurrenceType = null;
        if (this.recurrenceType != null) {
            recurrenceType = AccountTransferRecurrenceType.fromInt((Integer)((Long)this.recurrenceType.getId()).intValue());
        }
        return recurrenceType;
    }

    public PeriodFrequencyType recurrenceFrequency() {
        PeriodFrequencyType frequencyType = null;
        if (this.recurrenceFrequency != null) {
            frequencyType = PeriodFrequencyType.fromInt((Integer)((Long)this.recurrenceFrequency.getId()).intValue());
        }
        return frequencyType;
    }

    public PortfolioAccountType fromAccountType() {
        PortfolioAccountType accountType = null;
        if (this.fromAccountType != null) {
            accountType = PortfolioAccountType.fromInt((Integer)((Long)this.fromAccountType.getId()).intValue());
        }
        return accountType;
    }

    public PortfolioAccountType toAccountType() {
        PortfolioAccountType accountType = null;
        if (this.toAccountType != null) {
            accountType = PortfolioAccountType.fromInt((Integer)((Long)this.toAccountType.getId()).intValue());
        }
        return accountType;
    }

    public AccountTransferType transferType() {
        AccountTransferType accountTransferType = null;
        if (this.transferType != null) {
            accountTransferType = AccountTransferType.fromInt((Integer)((Long)this.transferType.getId()).intValue());
        }
        return accountTransferType;
    }

    public Integer recurrenceInterval() {
        return this.recurrenceInterval;
    }

    public Integer recurrenceOnDay() {
        Integer recurrenceOnDay = 0;
        if (this.recurrenceOnMonthDay != null) {
            recurrenceOnDay = this.recurrenceOnMonthDay.get(ChronoField.DAY_OF_MONTH);
        }
        return recurrenceOnDay;
    }

    public Integer recurrenceOnMonth() {
        Integer recurrenceOnMonth = 0;
        if (this.recurrenceOnMonthDay != null) {
            recurrenceOnMonth = this.recurrenceOnMonthDay.get(ChronoField.MONTH_OF_YEAR);
        }
        return recurrenceOnMonth;
    }

    public LocalDate validFrom() {
        return this.validFrom;
    }

    public BigDecimal amount() {
        return this.amount;
    }

    public PortfolioAccountData fromAccount() {
        return this.fromAccount;
    }

    public PortfolioAccountData toAccount() {
        return this.toAccount;
    }

    public String name() {
        return this.name;
    }

    public Integer toTransferType() {
        Integer transferType = null;
        AccountTransferType accountTransferType = this.transferType();
        if (accountTransferType.isChargePayment()) {
            transferType = LoanTransactionType.CHARGE_PAYMENT.getValue();
        } else if (accountTransferType.isLoanRepayment()) {
            transferType = LoanTransactionType.REPAYMENT.getValue();
        }
        return transferType;
    }

    public Long accountDetailId() {
        return this.accountDetailId;
    }

    public ClientData fromClient() {
        return this.fromClient;
    }

    public ClientData toClient() {
        return this.toClient;
    }

    public Long getId() {
        return this.id;
    }
}

